/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieves the Logs status for the Amazon Security Lake account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeSourceStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeSourceStatus.Builder, DataLakeSourceStatus> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(DataLakeSourceStatus::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataLakeSourceStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resource;

    private final String status;

    private DataLakeSourceStatus(BuilderImpl builder) {
        this.resource = builder.resource;
        this.status = builder.status;
    }

    /**
     * <p>
     * Defines path the stored logs are available which has information on your systems, applications, and services.
     * </p>
     * 
     * @return Defines path the stored logs are available which has information on your systems, applications, and
     *         services.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The health status of services, including error codes and patterns.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SourceCollectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The health status of services, including error codes and patterns.
     * @see SourceCollectionStatus
     */
    public final SourceCollectionStatus status() {
        return SourceCollectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The health status of services, including error codes and patterns.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SourceCollectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The health status of services, including error codes and patterns.
     * @see SourceCollectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeSourceStatus)) {
            return false;
        }
        DataLakeSourceStatus other = (DataLakeSourceStatus) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeSourceStatus").add("Resource", resource()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeSourceStatus, T> g) {
        return obj -> g.apply((DataLakeSourceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeSourceStatus> {
        /**
         * <p>
         * Defines path the stored logs are available which has information on your systems, applications, and services.
         * </p>
         * 
         * @param resource
         *        Defines path the stored logs are available which has information on your systems, applications, and
         *        services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The health status of services, including error codes and patterns.
         * </p>
         * 
         * @param status
         *        The health status of services, including error codes and patterns.
         * @see SourceCollectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceCollectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The health status of services, including error codes and patterns.
         * </p>
         * 
         * @param status
         *        The health status of services, including error codes and patterns.
         * @see SourceCollectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceCollectionStatus
         */
        Builder status(SourceCollectionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String resource;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeSourceStatus model) {
            resource(model.resource);
            status(model.status);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SourceCollectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DataLakeSourceStatus build() {
            return new DataLakeSourceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
