/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of Amazon Security Lake object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeResource implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeResource.Builder, DataLakeResource> {
    private static final SdkField<String> CREATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createStatus").getter(getter(DataLakeResource::createStatusAsString))
            .setter(setter(Builder::createStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createStatus").build()).build();

    private static final SdkField<String> DATA_LAKE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataLakeArn").getter(getter(DataLakeResource::dataLakeArn)).setter(setter(Builder::dataLakeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLakeArn").build()).build();

    private static final SdkField<DataLakeEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<DataLakeEncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(DataLakeResource::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(DataLakeEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<DataLakeLifecycleConfiguration> LIFECYCLE_CONFIGURATION_FIELD = SdkField
            .<DataLakeLifecycleConfiguration> builder(MarshallingType.SDK_POJO).memberName("lifecycleConfiguration")
            .getter(getter(DataLakeResource::lifecycleConfiguration)).setter(setter(Builder::lifecycleConfiguration))
            .constructor(DataLakeLifecycleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleConfiguration").build())
            .build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(DataLakeResource::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<DataLakeReplicationConfiguration> REPLICATION_CONFIGURATION_FIELD = SdkField
            .<DataLakeReplicationConfiguration> builder(MarshallingType.SDK_POJO).memberName("replicationConfiguration")
            .getter(getter(DataLakeResource::replicationConfiguration)).setter(setter(Builder::replicationConfiguration))
            .constructor(DataLakeReplicationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationConfiguration").build())
            .build();

    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketArn").getter(getter(DataLakeResource::s3BucketArn)).setter(setter(Builder::s3BucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()).build();

    private static final SdkField<DataLakeUpdateStatus> UPDATE_STATUS_FIELD = SdkField
            .<DataLakeUpdateStatus> builder(MarshallingType.SDK_POJO).memberName("updateStatus")
            .getter(getter(DataLakeResource::updateStatus)).setter(setter(Builder::updateStatus))
            .constructor(DataLakeUpdateStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_STATUS_FIELD,
            DATA_LAKE_ARN_FIELD, ENCRYPTION_CONFIGURATION_FIELD, LIFECYCLE_CONFIGURATION_FIELD, REGION_FIELD,
            REPLICATION_CONFIGURATION_FIELD, S3_BUCKET_ARN_FIELD, UPDATE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String createStatus;

    private final String dataLakeArn;

    private final DataLakeEncryptionConfiguration encryptionConfiguration;

    private final DataLakeLifecycleConfiguration lifecycleConfiguration;

    private final String region;

    private final DataLakeReplicationConfiguration replicationConfiguration;

    private final String s3BucketArn;

    private final DataLakeUpdateStatus updateStatus;

    private DataLakeResource(BuilderImpl builder) {
        this.createStatus = builder.createStatus;
        this.dataLakeArn = builder.dataLakeArn;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
        this.region = builder.region;
        this.replicationConfiguration = builder.replicationConfiguration;
        this.s3BucketArn = builder.s3BucketArn;
        this.updateStatus = builder.updateStatus;
    }

    /**
     * <p>
     * Retrieves the status of the configuration operation for an account in Amazon Security Lake.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #createStatus} will
     * return {@link DataLakeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #createStatusAsString}.
     * </p>
     * 
     * @return Retrieves the status of the configuration operation for an account in Amazon Security Lake.
     * @see DataLakeStatus
     */
    public final DataLakeStatus createStatus() {
        return DataLakeStatus.fromValue(createStatus);
    }

    /**
     * <p>
     * Retrieves the status of the configuration operation for an account in Amazon Security Lake.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #createStatus} will
     * return {@link DataLakeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #createStatusAsString}.
     * </p>
     * 
     * @return Retrieves the status of the configuration operation for an account in Amazon Security Lake.
     * @see DataLakeStatus
     */
    public final String createStatusAsString() {
        return createStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about ARNs and
     * how to use them in policies, see the <a
     * href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon Security Lake
     * User Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about
     *         ARNs and how to use them in policies, see the <a
     *         href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon
     *         Security Lake User Guide</a>.
     */
    public final String dataLakeArn() {
        return dataLakeArn;
    }

    /**
     * <p>
     * Provides encryption details of Amazon Security Lake object.
     * </p>
     * 
     * @return Provides encryption details of Amazon Security Lake object.
     */
    public final DataLakeEncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * Provides lifecycle details of Amazon Security Lake object.
     * </p>
     * 
     * @return Provides lifecycle details of Amazon Security Lake object.
     */
    public final DataLakeLifecycleConfiguration lifecycleConfiguration() {
        return lifecycleConfiguration;
    }

    /**
     * <p>
     * The Amazon Web Services Regions where Security Lake is enabled.
     * </p>
     * 
     * @return The Amazon Web Services Regions where Security Lake is enabled.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Provides replication details of Amazon Security Lake object.
     * </p>
     * 
     * @return Provides replication details of Amazon Security Lake object.
     */
    public final DataLakeReplicationConfiguration replicationConfiguration() {
        return replicationConfiguration;
    }

    /**
     * <p>
     * The ARN for the Amazon Security Lake Amazon S3 bucket.
     * </p>
     * 
     * @return The ARN for the Amazon Security Lake Amazon S3 bucket.
     */
    public final String s3BucketArn() {
        return s3BucketArn;
    }

    /**
     * <p>
     * The status of the last <code>UpdateDataLake </code>or <code>DeleteDataLake</code> API request.
     * </p>
     * 
     * @return The status of the last <code>UpdateDataLake </code>or <code>DeleteDataLake</code> API request.
     */
    public final DataLakeUpdateStatus updateStatus() {
        return updateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataLakeArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeResource)) {
            return false;
        }
        DataLakeResource other = (DataLakeResource) obj;
        return Objects.equals(createStatusAsString(), other.createStatusAsString())
                && Objects.equals(dataLakeArn(), other.dataLakeArn())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(lifecycleConfiguration(), other.lifecycleConfiguration())
                && Objects.equals(region(), other.region())
                && Objects.equals(replicationConfiguration(), other.replicationConfiguration())
                && Objects.equals(s3BucketArn(), other.s3BucketArn()) && Objects.equals(updateStatus(), other.updateStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeResource").add("CreateStatus", createStatusAsString()).add("DataLakeArn", dataLakeArn())
                .add("EncryptionConfiguration", encryptionConfiguration())
                .add("LifecycleConfiguration", lifecycleConfiguration()).add("Region", region())
                .add("ReplicationConfiguration", replicationConfiguration()).add("S3BucketArn", s3BucketArn())
                .add("UpdateStatus", updateStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createStatus":
            return Optional.ofNullable(clazz.cast(createStatusAsString()));
        case "dataLakeArn":
            return Optional.ofNullable(clazz.cast(dataLakeArn()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "lifecycleConfiguration":
            return Optional.ofNullable(clazz.cast(lifecycleConfiguration()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "replicationConfiguration":
            return Optional.ofNullable(clazz.cast(replicationConfiguration()));
        case "s3BucketArn":
            return Optional.ofNullable(clazz.cast(s3BucketArn()));
        case "updateStatus":
            return Optional.ofNullable(clazz.cast(updateStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeResource, T> g) {
        return obj -> g.apply((DataLakeResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeResource> {
        /**
         * <p>
         * Retrieves the status of the configuration operation for an account in Amazon Security Lake.
         * </p>
         * 
         * @param createStatus
         *        Retrieves the status of the configuration operation for an account in Amazon Security Lake.
         * @see DataLakeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLakeStatus
         */
        Builder createStatus(String createStatus);

        /**
         * <p>
         * Retrieves the status of the configuration operation for an account in Amazon Security Lake.
         * </p>
         * 
         * @param createStatus
         *        Retrieves the status of the configuration operation for an account in Amazon Security Lake.
         * @see DataLakeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLakeStatus
         */
        Builder createStatus(DataLakeStatus createStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about ARNs
         * and how to use them in policies, see the <a
         * href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon Security
         * Lake User Guide</a>.
         * </p>
         * 
         * @param dataLakeArn
         *        The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about
         *        ARNs and how to use them in policies, see the <a
         *        href="https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html">Amazon
         *        Security Lake User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakeArn(String dataLakeArn);

        /**
         * <p>
         * Provides encryption details of Amazon Security Lake object.
         * </p>
         * 
         * @param encryptionConfiguration
         *        Provides encryption details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(DataLakeEncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * Provides encryption details of Amazon Security Lake object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeEncryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataLakeEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #encryptionConfiguration(DataLakeEncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link DataLakeEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(DataLakeEncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<DataLakeEncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(DataLakeEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)
                    .build());
        }

        /**
         * <p>
         * Provides lifecycle details of Amazon Security Lake object.
         * </p>
         * 
         * @param lifecycleConfiguration
         *        Provides lifecycle details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfiguration(DataLakeLifecycleConfiguration lifecycleConfiguration);

        /**
         * <p>
         * Provides lifecycle details of Amazon Security Lake object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeLifecycleConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataLakeLifecycleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeLifecycleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycleConfiguration(DataLakeLifecycleConfiguration)}.
         * 
         * @param lifecycleConfiguration
         *        a consumer that will call methods on {@link DataLakeLifecycleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleConfiguration(DataLakeLifecycleConfiguration)
         */
        default Builder lifecycleConfiguration(Consumer<DataLakeLifecycleConfiguration.Builder> lifecycleConfiguration) {
            return lifecycleConfiguration(DataLakeLifecycleConfiguration.builder().applyMutation(lifecycleConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Web Services Regions where Security Lake is enabled.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Regions where Security Lake is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Provides replication details of Amazon Security Lake object.
         * </p>
         * 
         * @param replicationConfiguration
         *        Provides replication details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfiguration(DataLakeReplicationConfiguration replicationConfiguration);

        /**
         * <p>
         * Provides replication details of Amazon Security Lake object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeReplicationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataLakeReplicationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeReplicationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationConfiguration(DataLakeReplicationConfiguration)}.
         * 
         * @param replicationConfiguration
         *        a consumer that will call methods on {@link DataLakeReplicationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationConfiguration(DataLakeReplicationConfiguration)
         */
        default Builder replicationConfiguration(Consumer<DataLakeReplicationConfiguration.Builder> replicationConfiguration) {
            return replicationConfiguration(DataLakeReplicationConfiguration.builder().applyMutation(replicationConfiguration)
                    .build());
        }

        /**
         * <p>
         * The ARN for the Amazon Security Lake Amazon S3 bucket.
         * </p>
         * 
         * @param s3BucketArn
         *        The ARN for the Amazon Security Lake Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketArn(String s3BucketArn);

        /**
         * <p>
         * The status of the last <code>UpdateDataLake </code>or <code>DeleteDataLake</code> API request.
         * </p>
         * 
         * @param updateStatus
         *        The status of the last <code>UpdateDataLake </code>or <code>DeleteDataLake</code> API request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatus(DataLakeUpdateStatus updateStatus);

        /**
         * <p>
         * The status of the last <code>UpdateDataLake </code>or <code>DeleteDataLake</code> API request.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeUpdateStatus.Builder} avoiding
         * the need to create one manually via {@link DataLakeUpdateStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeUpdateStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #updateStatus(DataLakeUpdateStatus)}.
         * 
         * @param updateStatus
         *        a consumer that will call methods on {@link DataLakeUpdateStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateStatus(DataLakeUpdateStatus)
         */
        default Builder updateStatus(Consumer<DataLakeUpdateStatus.Builder> updateStatus) {
            return updateStatus(DataLakeUpdateStatus.builder().applyMutation(updateStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String createStatus;

        private String dataLakeArn;

        private DataLakeEncryptionConfiguration encryptionConfiguration;

        private DataLakeLifecycleConfiguration lifecycleConfiguration;

        private String region;

        private DataLakeReplicationConfiguration replicationConfiguration;

        private String s3BucketArn;

        private DataLakeUpdateStatus updateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeResource model) {
            createStatus(model.createStatus);
            dataLakeArn(model.dataLakeArn);
            encryptionConfiguration(model.encryptionConfiguration);
            lifecycleConfiguration(model.lifecycleConfiguration);
            region(model.region);
            replicationConfiguration(model.replicationConfiguration);
            s3BucketArn(model.s3BucketArn);
            updateStatus(model.updateStatus);
        }

        public final String getCreateStatus() {
            return createStatus;
        }

        public final void setCreateStatus(String createStatus) {
            this.createStatus = createStatus;
        }

        @Override
        public final Builder createStatus(String createStatus) {
            this.createStatus = createStatus;
            return this;
        }

        @Override
        public final Builder createStatus(DataLakeStatus createStatus) {
            this.createStatus(createStatus == null ? null : createStatus.toString());
            return this;
        }

        public final String getDataLakeArn() {
            return dataLakeArn;
        }

        public final void setDataLakeArn(String dataLakeArn) {
            this.dataLakeArn = dataLakeArn;
        }

        @Override
        public final Builder dataLakeArn(String dataLakeArn) {
            this.dataLakeArn = dataLakeArn;
            return this;
        }

        public final DataLakeEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(DataLakeEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(DataLakeEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final DataLakeLifecycleConfiguration.Builder getLifecycleConfiguration() {
            return lifecycleConfiguration != null ? lifecycleConfiguration.toBuilder() : null;
        }

        public final void setLifecycleConfiguration(DataLakeLifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(DataLakeLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final DataLakeReplicationConfiguration.Builder getReplicationConfiguration() {
            return replicationConfiguration != null ? replicationConfiguration.toBuilder() : null;
        }

        public final void setReplicationConfiguration(DataLakeReplicationConfiguration.BuilderImpl replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration != null ? replicationConfiguration.build() : null;
        }

        @Override
        public final Builder replicationConfiguration(DataLakeReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        public final String getS3BucketArn() {
            return s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final DataLakeUpdateStatus.Builder getUpdateStatus() {
            return updateStatus != null ? updateStatus.toBuilder() : null;
        }

        public final void setUpdateStatus(DataLakeUpdateStatus.BuilderImpl updateStatus) {
            this.updateStatus = updateStatus != null ? updateStatus.build() : null;
        }

        @Override
        public final Builder updateStatus(DataLakeUpdateStatus updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public DataLakeResource build() {
            return new DataLakeResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
