/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the third-party custom source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLogSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLogSourceConfiguration.Builder, CustomLogSourceConfiguration> {
    private static final SdkField<CustomLogSourceCrawlerConfiguration> CRAWLER_CONFIGURATION_FIELD = SdkField
            .<CustomLogSourceCrawlerConfiguration> builder(MarshallingType.SDK_POJO).memberName("crawlerConfiguration")
            .getter(getter(CustomLogSourceConfiguration::crawlerConfiguration)).setter(setter(Builder::crawlerConfiguration))
            .constructor(CustomLogSourceCrawlerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerConfiguration").build())
            .build();

    private static final SdkField<AwsIdentity> PROVIDER_IDENTITY_FIELD = SdkField.<AwsIdentity> builder(MarshallingType.SDK_POJO)
            .memberName("providerIdentity").getter(getter(CustomLogSourceConfiguration::providerIdentity))
            .setter(setter(Builder::providerIdentity)).constructor(AwsIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_CONFIGURATION_FIELD,
            PROVIDER_IDENTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final CustomLogSourceCrawlerConfiguration crawlerConfiguration;

    private final AwsIdentity providerIdentity;

    private CustomLogSourceConfiguration(BuilderImpl builder) {
        this.crawlerConfiguration = builder.crawlerConfiguration;
        this.providerIdentity = builder.providerIdentity;
    }

    /**
     * <p>
     * The configuration for the Glue Crawler for the third-party custom source.
     * </p>
     * 
     * @return The configuration for the Glue Crawler for the third-party custom source.
     */
    public final CustomLogSourceCrawlerConfiguration crawlerConfiguration() {
        return crawlerConfiguration;
    }

    /**
     * <p>
     * The identity of the log provider for the third-party custom source.
     * </p>
     * 
     * @return The identity of the log provider for the third-party custom source.
     */
    public final AwsIdentity providerIdentity() {
        return providerIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(providerIdentity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLogSourceConfiguration)) {
            return false;
        }
        CustomLogSourceConfiguration other = (CustomLogSourceConfiguration) obj;
        return Objects.equals(crawlerConfiguration(), other.crawlerConfiguration())
                && Objects.equals(providerIdentity(), other.providerIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLogSourceConfiguration").add("CrawlerConfiguration", crawlerConfiguration())
                .add("ProviderIdentity", providerIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crawlerConfiguration":
            return Optional.ofNullable(clazz.cast(crawlerConfiguration()));
        case "providerIdentity":
            return Optional.ofNullable(clazz.cast(providerIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLogSourceConfiguration, T> g) {
        return obj -> g.apply((CustomLogSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLogSourceConfiguration> {
        /**
         * <p>
         * The configuration for the Glue Crawler for the third-party custom source.
         * </p>
         * 
         * @param crawlerConfiguration
         *        The configuration for the Glue Crawler for the third-party custom source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerConfiguration(CustomLogSourceCrawlerConfiguration crawlerConfiguration);

        /**
         * <p>
         * The configuration for the Glue Crawler for the third-party custom source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomLogSourceCrawlerConfiguration.Builder} avoiding the need to create one manually via
         * {@link CustomLogSourceCrawlerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLogSourceCrawlerConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #crawlerConfiguration(CustomLogSourceCrawlerConfiguration)}.
         * 
         * @param crawlerConfiguration
         *        a consumer that will call methods on {@link CustomLogSourceCrawlerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawlerConfiguration(CustomLogSourceCrawlerConfiguration)
         */
        default Builder crawlerConfiguration(Consumer<CustomLogSourceCrawlerConfiguration.Builder> crawlerConfiguration) {
            return crawlerConfiguration(CustomLogSourceCrawlerConfiguration.builder().applyMutation(crawlerConfiguration).build());
        }

        /**
         * <p>
         * The identity of the log provider for the third-party custom source.
         * </p>
         * 
         * @param providerIdentity
         *        The identity of the log provider for the third-party custom source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerIdentity(AwsIdentity providerIdentity);

        /**
         * <p>
         * The identity of the log provider for the third-party custom source.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsIdentity.Builder} avoiding the need to
         * create one manually via {@link AwsIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIdentity.Builder#build()} is called immediately and its result
         * is passed to {@link #providerIdentity(AwsIdentity)}.
         * 
         * @param providerIdentity
         *        a consumer that will call methods on {@link AwsIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerIdentity(AwsIdentity)
         */
        default Builder providerIdentity(Consumer<AwsIdentity.Builder> providerIdentity) {
            return providerIdentity(AwsIdentity.builder().applyMutation(providerIdentity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomLogSourceCrawlerConfiguration crawlerConfiguration;

        private AwsIdentity providerIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLogSourceConfiguration model) {
            crawlerConfiguration(model.crawlerConfiguration);
            providerIdentity(model.providerIdentity);
        }

        public final CustomLogSourceCrawlerConfiguration.Builder getCrawlerConfiguration() {
            return crawlerConfiguration != null ? crawlerConfiguration.toBuilder() : null;
        }

        public final void setCrawlerConfiguration(CustomLogSourceCrawlerConfiguration.BuilderImpl crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration != null ? crawlerConfiguration.build() : null;
        }

        @Override
        public final Builder crawlerConfiguration(CustomLogSourceCrawlerConfiguration crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration;
            return this;
        }

        public final AwsIdentity.Builder getProviderIdentity() {
            return providerIdentity != null ? providerIdentity.toBuilder() : null;
        }

        public final void setProviderIdentity(AwsIdentity.BuilderImpl providerIdentity) {
            this.providerIdentity = providerIdentity != null ? providerIdentity.build() : null;
        }

        @Override
        public final Builder providerIdentity(AwsIdentity providerIdentity) {
            this.providerIdentity = providerIdentity;
            return this;
        }

        @Override
        public CustomLogSourceConfiguration build() {
            return new CustomLogSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
