/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomLogSourceRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<CreateCustomLogSourceRequest.Builder, CreateCustomLogSourceRequest> {
    private static final SdkField<CustomLogSourceConfiguration> CONFIGURATION_FIELD = SdkField
            .<CustomLogSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateCustomLogSourceRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(CustomLogSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<List<String>> EVENT_CLASSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventClasses")
            .getter(getter(CreateCustomLogSourceRequest::eventClasses))
            .setter(setter(Builder::eventClasses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventClasses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceName").getter(getter(CreateCustomLogSourceRequest::sourceName))
            .setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVersion").getter(getter(CreateCustomLogSourceRequest::sourceVersion))
            .setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            EVENT_CLASSES_FIELD, SOURCE_NAME_FIELD, SOURCE_VERSION_FIELD));

    private final CustomLogSourceConfiguration configuration;

    private final List<String> eventClasses;

    private final String sourceName;

    private final String sourceVersion;

    private CreateCustomLogSourceRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.eventClasses = builder.eventClasses;
        this.sourceName = builder.sourceName;
        this.sourceVersion = builder.sourceVersion;
    }

    /**
     * <p>
     * The configuration for the third-party custom source.
     * </p>
     * 
     * @return The configuration for the third-party custom source.
     */
    public final CustomLogSourceConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventClasses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventClasses() {
        return eventClasses != null && !(eventClasses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom
     * source will send to Security Lake. The supported event classes are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACCESS_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FILE_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KERNEL_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KERNEL_EXTENSION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MEMORY_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODULE_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROCESS_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGISTRY_KEY_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REGISTRY_VALUE_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESOURCE_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULED_JOB_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SECURITY_FINDING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCOUNT_CHANGE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHENTICATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AUTHORIZATION</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENTITY_MANAGEMENT_AUDIT</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DHCP_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NETWORK_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DNS_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FTP_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RDP_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SMB_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSH_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONFIG_STATE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVENTORY_INFO</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMAIL_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>API_ACTIVITY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CLOUD_API</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventClasses} method.
     * </p>
     * 
     * @return The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the
     *         custom source will send to Security Lake. The supported event classes are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCESS_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FILE_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KERNEL_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KERNEL_EXTENSION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MEMORY_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODULE_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROCESS_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGISTRY_KEY_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REGISTRY_VALUE_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESOURCE_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULED_JOB_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SECURITY_FINDING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCOUNT_CHANGE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHENTICATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AUTHORIZATION</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENTITY_MANAGEMENT_AUDIT</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DHCP_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NETWORK_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DNS_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FTP_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RDP_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SMB_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSH_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONFIG_STATE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVENTORY_INFO</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMAIL_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>API_ACTIVITY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CLOUD_API</code>
     *         </p>
     *         </li>
     */
    public final List<String> eventClasses() {
        return eventClasses;
    }

    /**
     * <p>
     * Specify the name for a third-party custom source. This must be a Regionally unique value.
     * </p>
     * 
     * @return Specify the name for a third-party custom source. This must be a Regionally unique value.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * Specify the source version for the third-party custom source, to limit log collection to a specific version of
     * custom data source.
     * </p>
     * 
     * @return Specify the source version for the third-party custom source, to limit log collection to a specific
     *         version of custom data source.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventClasses() ? eventClasses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomLogSourceRequest)) {
            return false;
        }
        CreateCustomLogSourceRequest other = (CreateCustomLogSourceRequest) obj;
        return Objects.equals(configuration(), other.configuration()) && hasEventClasses() == other.hasEventClasses()
                && Objects.equals(eventClasses(), other.eventClasses()) && Objects.equals(sourceName(), other.sourceName())
                && Objects.equals(sourceVersion(), other.sourceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomLogSourceRequest").add("Configuration", configuration())
                .add("EventClasses", hasEventClasses() ? eventClasses() : null).add("SourceName", sourceName())
                .add("SourceVersion", sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "eventClasses":
            return Optional.ofNullable(clazz.cast(eventClasses()));
        case "sourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomLogSourceRequest, T> g) {
        return obj -> g.apply((CreateCustomLogSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomLogSourceRequest> {
        /**
         * <p>
         * The configuration for the third-party custom source.
         * </p>
         * 
         * @param configuration
         *        The configuration for the third-party custom source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CustomLogSourceConfiguration configuration);

        /**
         * <p>
         * The configuration for the third-party custom source.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomLogSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomLogSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLogSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(CustomLogSourceConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link CustomLogSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(CustomLogSourceConfiguration)
         */
        default Builder configuration(Consumer<CustomLogSourceConfiguration.Builder> configuration) {
            return configuration(CustomLogSourceConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom
         * source will send to Security Lake. The supported event classes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCESS_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FILE_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KERNEL_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KERNEL_EXTENSION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEMORY_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODULE_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROCESS_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGISTRY_KEY_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGISTRY_VALUE_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOURCE_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULED_JOB_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SECURITY_FINDING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCOUNT_CHANGE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHENTICATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHORIZATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENTITY_MANAGEMENT_AUDIT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DHCP_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DNS_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FTP_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RDP_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SMB_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSH_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONFIG_STATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVENTORY_INFO</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMAIL_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>API_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLOUD_API</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventClasses
         *        The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the
         *        custom source will send to Security Lake. The supported event classes are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCESS_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FILE_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KERNEL_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KERNEL_EXTENSION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEMORY_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODULE_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROCESS_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTRY_KEY_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTRY_VALUE_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOURCE_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULED_JOB_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SECURITY_FINDING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCOUNT_CHANGE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHENTICATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHORIZATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENTITY_MANAGEMENT_AUDIT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DHCP_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DNS_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FTP_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RDP_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SMB_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSH_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONFIG_STATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVENTORY_INFO</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMAIL_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>API_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLOUD_API</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventClasses(Collection<String> eventClasses);

        /**
         * <p>
         * The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom
         * source will send to Security Lake. The supported event classes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCESS_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FILE_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KERNEL_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KERNEL_EXTENSION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MEMORY_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODULE_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROCESS_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGISTRY_KEY_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REGISTRY_VALUE_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESOURCE_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULED_JOB_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SECURITY_FINDING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCOUNT_CHANGE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHENTICATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AUTHORIZATION</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENTITY_MANAGEMENT_AUDIT</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DHCP_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NETWORK_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DNS_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FTP_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RDP_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SMB_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSH_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONFIG_STATE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVENTORY_INFO</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMAIL_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>API_ACTIVITY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CLOUD_API</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventClasses
         *        The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the
         *        custom source will send to Security Lake. The supported event classes are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCESS_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FILE_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KERNEL_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KERNEL_EXTENSION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MEMORY_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODULE_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROCESS_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTRY_KEY_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REGISTRY_VALUE_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESOURCE_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULED_JOB_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SECURITY_FINDING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCOUNT_CHANGE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHENTICATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AUTHORIZATION</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENTITY_MANAGEMENT_AUDIT</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DHCP_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NETWORK_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DNS_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FTP_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RDP_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SMB_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSH_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONFIG_STATE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVENTORY_INFO</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMAIL_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>API_ACTIVITY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CLOUD_API</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventClasses(String... eventClasses);

        /**
         * <p>
         * Specify the name for a third-party custom source. This must be a Regionally unique value.
         * </p>
         * 
         * @param sourceName
         *        Specify the name for a third-party custom source. This must be a Regionally unique value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * Specify the source version for the third-party custom source, to limit log collection to a specific version
         * of custom data source.
         * </p>
         * 
         * @param sourceVersion
         *        Specify the source version for the third-party custom source, to limit log collection to a specific
         *        version of custom data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private CustomLogSourceConfiguration configuration;

        private List<String> eventClasses = DefaultSdkAutoConstructList.getInstance();

        private String sourceName;

        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomLogSourceRequest model) {
            super(model);
            configuration(model.configuration);
            eventClasses(model.eventClasses);
            sourceName(model.sourceName);
            sourceVersion(model.sourceVersion);
        }

        public final CustomLogSourceConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(CustomLogSourceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CustomLogSourceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Collection<String> getEventClasses() {
            if (eventClasses instanceof SdkAutoConstructList) {
                return null;
            }
            return eventClasses;
        }

        public final void setEventClasses(Collection<String> eventClasses) {
            this.eventClasses = OcsfEventClassListCopier.copy(eventClasses);
        }

        @Override
        public final Builder eventClasses(Collection<String> eventClasses) {
            this.eventClasses = OcsfEventClassListCopier.copy(eventClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventClasses(String... eventClasses) {
            eventClasses(Arrays.asList(eventClasses));
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomLogSourceRequest build() {
            return new CreateCustomLogSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
