/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about which control's enablement status couldn't be retrieved in a specified standard when calling
 * <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html">
 * BatchUpdateStandardsControlAssociations</a>. This parameter also provides details about why the request was
 * unprocessed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnprocessedStandardsControlAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<UnprocessedStandardsControlAssociation.Builder, UnprocessedStandardsControlAssociation> {
    private static final SdkField<StandardsControlAssociationId> STANDARDS_CONTROL_ASSOCIATION_ID_FIELD = SdkField
            .<StandardsControlAssociationId> builder(MarshallingType.SDK_POJO)
            .memberName("StandardsControlAssociationId")
            .getter(getter(UnprocessedStandardsControlAssociation::standardsControlAssociationId))
            .setter(setter(Builder::standardsControlAssociationId))
            .constructor(StandardsControlAssociationId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationId")
                    .build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(UnprocessedStandardsControlAssociation::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorReason").getter(getter(UnprocessedStandardsControlAssociation::errorReason))
            .setter(setter(Builder::errorReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STANDARDS_CONTROL_ASSOCIATION_ID_FIELD, ERROR_CODE_FIELD, ERROR_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final StandardsControlAssociationId standardsControlAssociationId;

    private final String errorCode;

    private final String errorReason;

    private UnprocessedStandardsControlAssociation(BuilderImpl builder) {
        this.standardsControlAssociationId = builder.standardsControlAssociationId;
        this.errorCode = builder.errorCode;
        this.errorReason = builder.errorReason;
    }

    /**
     * <p>
     * An array with one or more objects that includes a security control (identified with
     * <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon
     * Resource Name (ARN) of a standard. This parameter shows the specific controls for which the enablement status
     * couldn't be retrieved in specified standards when calling <a href=
     * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
     * >BatchUpdateStandardsControlAssociations</a>.
     * </p>
     * 
     * @return An array with one or more objects that includes a security control (identified with
     *         <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the
     *         Amazon Resource Name (ARN) of a standard. This parameter shows the specific controls for which the
     *         enablement status couldn't be retrieved in specified standards when calling <a href=
     *         "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
     *         >BatchUpdateStandardsControlAssociations</a>.
     */
    public final StandardsControlAssociationId standardsControlAssociationId() {
        return standardsControlAssociationId;
    }

    /**
     * <p>
     * The error code for the unprocessed standard and control association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link UnprocessedErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the unprocessed standard and control association.
     * @see UnprocessedErrorCode
     */
    public final UnprocessedErrorCode errorCode() {
        return UnprocessedErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code for the unprocessed standard and control association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link UnprocessedErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the unprocessed standard and control association.
     * @see UnprocessedErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The reason why the standard and control association was unprocessed.
     * </p>
     * 
     * @return The reason why the standard and control association was unprocessed.
     */
    public final String errorReason() {
        return errorReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardsControlAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedStandardsControlAssociation)) {
            return false;
        }
        UnprocessedStandardsControlAssociation other = (UnprocessedStandardsControlAssociation) obj;
        return Objects.equals(standardsControlAssociationId(), other.standardsControlAssociationId())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorReason(), other.errorReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnprocessedStandardsControlAssociation")
                .add("StandardsControlAssociationId", standardsControlAssociationId()).add("ErrorCode", errorCodeAsString())
                .add("ErrorReason", errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsControlAssociationId":
            return Optional.ofNullable(clazz.cast(standardsControlAssociationId()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "ErrorReason":
            return Optional.ofNullable(clazz.cast(errorReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedStandardsControlAssociation, T> g) {
        return obj -> g.apply((UnprocessedStandardsControlAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnprocessedStandardsControlAssociation> {
        /**
         * <p>
         * An array with one or more objects that includes a security control (identified with
         * <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon
         * Resource Name (ARN) of a standard. This parameter shows the specific controls for which the enablement status
         * couldn't be retrieved in specified standards when calling <a href=
         * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
         * >BatchUpdateStandardsControlAssociations</a>.
         * </p>
         * 
         * @param standardsControlAssociationId
         *        An array with one or more objects that includes a security control (identified with
         *        <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the
         *        Amazon Resource Name (ARN) of a standard. This parameter shows the specific controls for which the
         *        enablement status couldn't be retrieved in specified standards when calling <a href=
         *        "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
         *        >BatchUpdateStandardsControlAssociations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsControlAssociationId(StandardsControlAssociationId standardsControlAssociationId);

        /**
         * <p>
         * An array with one or more objects that includes a security control (identified with
         * <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of both parameters) and the Amazon
         * Resource Name (ARN) of a standard. This parameter shows the specific controls for which the enablement status
         * couldn't be retrieved in specified standards when calling <a href=
         * "https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"
         * >BatchUpdateStandardsControlAssociations</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link StandardsControlAssociationId.Builder}
         * avoiding the need to create one manually via {@link StandardsControlAssociationId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardsControlAssociationId.Builder#build()} is called
         * immediately and its result is passed to {@link #standardsControlAssociationId(StandardsControlAssociationId)}.
         * 
         * @param standardsControlAssociationId
         *        a consumer that will call methods on {@link StandardsControlAssociationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardsControlAssociationId(StandardsControlAssociationId)
         */
        default Builder standardsControlAssociationId(
                Consumer<StandardsControlAssociationId.Builder> standardsControlAssociationId) {
            return standardsControlAssociationId(StandardsControlAssociationId.builder()
                    .applyMutation(standardsControlAssociationId).build());
        }

        /**
         * <p>
         * The error code for the unprocessed standard and control association.
         * </p>
         * 
         * @param errorCode
         *        The error code for the unprocessed standard and control association.
         * @see UnprocessedErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnprocessedErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code for the unprocessed standard and control association.
         * </p>
         * 
         * @param errorCode
         *        The error code for the unprocessed standard and control association.
         * @see UnprocessedErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnprocessedErrorCode
         */
        Builder errorCode(UnprocessedErrorCode errorCode);

        /**
         * <p>
         * The reason why the standard and control association was unprocessed.
         * </p>
         * 
         * @param errorReason
         *        The reason why the standard and control association was unprocessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReason(String errorReason);
    }

    static final class BuilderImpl implements Builder {
        private StandardsControlAssociationId standardsControlAssociationId;

        private String errorCode;

        private String errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedStandardsControlAssociation model) {
            standardsControlAssociationId(model.standardsControlAssociationId);
            errorCode(model.errorCode);
            errorReason(model.errorReason);
        }

        public final StandardsControlAssociationId.Builder getStandardsControlAssociationId() {
            return standardsControlAssociationId != null ? standardsControlAssociationId.toBuilder() : null;
        }

        public final void setStandardsControlAssociationId(StandardsControlAssociationId.BuilderImpl standardsControlAssociationId) {
            this.standardsControlAssociationId = standardsControlAssociationId != null ? standardsControlAssociationId.build()
                    : null;
        }

        @Override
        public final Builder standardsControlAssociationId(StandardsControlAssociationId standardsControlAssociationId) {
            this.standardsControlAssociationId = standardsControlAssociationId;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(UnprocessedErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorReason() {
            return errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        @Override
        public UnprocessedStandardsControlAssociation build() {
            return new UnprocessedStandardsControlAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
