/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Step Functions state machine, which is a workflow consisting of a series of event- driven
 * steps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsStepFunctionStateMachineDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsStepFunctionStateMachineDetails.Builder, AwsStepFunctionStateMachineDetails> {
    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(AwsStepFunctionStateMachineDetails::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<AwsStepFunctionStateMachineLoggingConfigurationDetails> LOGGING_CONFIGURATION_FIELD = SdkField
            .<AwsStepFunctionStateMachineLoggingConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingConfiguration").getter(getter(AwsStepFunctionStateMachineDetails::loggingConfiguration))
            .setter(setter(Builder::loggingConfiguration))
            .constructor(AwsStepFunctionStateMachineLoggingConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsStepFunctionStateMachineDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AwsStepFunctionStateMachineDetails::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateMachineArn").getter(getter(AwsStepFunctionStateMachineDetails::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMachineArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsStepFunctionStateMachineDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<AwsStepFunctionStateMachineTracingConfigurationDetails> TRACING_CONFIGURATION_FIELD = SdkField
            .<AwsStepFunctionStateMachineTracingConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("TracingConfiguration").getter(getter(AwsStepFunctionStateMachineDetails::tracingConfiguration))
            .setter(setter(Builder::tracingConfiguration))
            .constructor(AwsStepFunctionStateMachineTracingConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfiguration").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsStepFunctionStateMachineDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD,
            LOGGING_CONFIGURATION_FIELD, NAME_FIELD, ROLE_ARN_FIELD, STATE_MACHINE_ARN_FIELD, STATUS_FIELD,
            TRACING_CONFIGURATION_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String label;

    private final AwsStepFunctionStateMachineLoggingConfigurationDetails loggingConfiguration;

    private final String name;

    private final String roleArn;

    private final String stateMachineArn;

    private final String status;

    private final AwsStepFunctionStateMachineTracingConfigurationDetails tracingConfiguration;

    private final String type;

    private AwsStepFunctionStateMachineDetails(BuilderImpl builder) {
        this.label = builder.label;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.stateMachineArn = builder.stateMachineArn;
        this.status = builder.status;
        this.tracingConfiguration = builder.tracingConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * A user-defined or an auto-generated string that identifies a <code>Map</code> state. This parameter is present
     * only if the <code>stateMachineArn</code> specified in input is a qualified state machine ARN.
     * </p>
     * 
     * @return A user-defined or an auto-generated string that identifies a <code>Map</code> state. This parameter is
     *         present only if the <code>stateMachineArn</code> specified in input is a qualified state machine ARN.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * Used to set CloudWatch Logs options.
     * </p>
     * 
     * @return Used to set CloudWatch Logs options.
     */
    public final AwsStepFunctionStateMachineLoggingConfigurationDetails loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The name of the state machine.
     * </p>
     * 
     * @return The name of the state machine.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used when creating this state machine.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The ARN that identifies the state machine.
     * </p>
     * 
     * @return The ARN that identifies the state machine.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The current status of the state machine.
     * </p>
     * 
     * @return The current status of the state machine.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Specifies whether X-Ray tracing is enabled.
     * </p>
     * 
     * @return Specifies whether X-Ray tracing is enabled.
     */
    public final AwsStepFunctionStateMachineTracingConfigurationDetails tracingConfiguration() {
        return tracingConfiguration;
    }

    /**
     * <p>
     * The type of the state machine (STANDARD or EXPRESS).
     * </p>
     * 
     * @return The type of the state machine (STANDARD or EXPRESS).
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(tracingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsStepFunctionStateMachineDetails)) {
            return false;
        }
        AwsStepFunctionStateMachineDetails other = (AwsStepFunctionStateMachineDetails) obj;
        return Objects.equals(label(), other.label()) && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(stateMachineArn(), other.stateMachineArn()) && Objects.equals(status(), other.status())
                && Objects.equals(tracingConfiguration(), other.tracingConfiguration()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsStepFunctionStateMachineDetails").add("Label", label())
                .add("LoggingConfiguration", loggingConfiguration()).add("Name", name()).add("RoleArn", roleArn())
                .add("StateMachineArn", stateMachineArn()).add("Status", status())
                .add("TracingConfiguration", tracingConfiguration()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "TracingConfiguration":
            return Optional.ofNullable(clazz.cast(tracingConfiguration()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsStepFunctionStateMachineDetails, T> g) {
        return obj -> g.apply((AwsStepFunctionStateMachineDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsStepFunctionStateMachineDetails> {
        /**
         * <p>
         * A user-defined or an auto-generated string that identifies a <code>Map</code> state. This parameter is
         * present only if the <code>stateMachineArn</code> specified in input is a qualified state machine ARN.
         * </p>
         * 
         * @param label
         *        A user-defined or an auto-generated string that identifies a <code>Map</code> state. This parameter is
         *        present only if the <code>stateMachineArn</code> specified in input is a qualified state machine ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * Used to set CloudWatch Logs options.
         * </p>
         * 
         * @param loggingConfiguration
         *        Used to set CloudWatch Logs options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(AwsStepFunctionStateMachineLoggingConfigurationDetails loggingConfiguration);

        /**
         * <p>
         * Used to set CloudWatch Logs options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsStepFunctionStateMachineLoggingConfigurationDetails.Builder} avoiding the need to create one
         * manually via {@link AwsStepFunctionStateMachineLoggingConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsStepFunctionStateMachineLoggingConfigurationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfiguration(AwsStepFunctionStateMachineLoggingConfigurationDetails)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on
         *        {@link AwsStepFunctionStateMachineLoggingConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(AwsStepFunctionStateMachineLoggingConfigurationDetails)
         */
        default Builder loggingConfiguration(
                Consumer<AwsStepFunctionStateMachineLoggingConfigurationDetails.Builder> loggingConfiguration) {
            return loggingConfiguration(AwsStepFunctionStateMachineLoggingConfigurationDetails.builder()
                    .applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The name of the state machine.
         * </p>
         * 
         * @param name
         *        The name of the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used when creating this state machine.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role used when creating this state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The ARN that identifies the state machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The ARN that identifies the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The current status of the state machine.
         * </p>
         * 
         * @param status
         *        The current status of the state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies whether X-Ray tracing is enabled.
         * </p>
         * 
         * @param tracingConfiguration
         *        Specifies whether X-Ray tracing is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingConfiguration(AwsStepFunctionStateMachineTracingConfigurationDetails tracingConfiguration);

        /**
         * <p>
         * Specifies whether X-Ray tracing is enabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsStepFunctionStateMachineTracingConfigurationDetails.Builder} avoiding the need to create one
         * manually via {@link AwsStepFunctionStateMachineTracingConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsStepFunctionStateMachineTracingConfigurationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #tracingConfiguration(AwsStepFunctionStateMachineTracingConfigurationDetails)}.
         * 
         * @param tracingConfiguration
         *        a consumer that will call methods on
         *        {@link AwsStepFunctionStateMachineTracingConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracingConfiguration(AwsStepFunctionStateMachineTracingConfigurationDetails)
         */
        default Builder tracingConfiguration(
                Consumer<AwsStepFunctionStateMachineTracingConfigurationDetails.Builder> tracingConfiguration) {
            return tracingConfiguration(AwsStepFunctionStateMachineTracingConfigurationDetails.builder()
                    .applyMutation(tracingConfiguration).build());
        }

        /**
         * <p>
         * The type of the state machine (STANDARD or EXPRESS).
         * </p>
         * 
         * @param type
         *        The type of the state machine (STANDARD or EXPRESS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String label;

        private AwsStepFunctionStateMachineLoggingConfigurationDetails loggingConfiguration;

        private String name;

        private String roleArn;

        private String stateMachineArn;

        private String status;

        private AwsStepFunctionStateMachineTracingConfigurationDetails tracingConfiguration;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsStepFunctionStateMachineDetails model) {
            label(model.label);
            loggingConfiguration(model.loggingConfiguration);
            name(model.name);
            roleArn(model.roleArn);
            stateMachineArn(model.stateMachineArn);
            status(model.status);
            tracingConfiguration(model.tracingConfiguration);
            type(model.type);
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final AwsStepFunctionStateMachineLoggingConfigurationDetails.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(
                AwsStepFunctionStateMachineLoggingConfigurationDetails.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(AwsStepFunctionStateMachineLoggingConfigurationDetails loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final AwsStepFunctionStateMachineTracingConfigurationDetails.Builder getTracingConfiguration() {
            return tracingConfiguration != null ? tracingConfiguration.toBuilder() : null;
        }

        public final void setTracingConfiguration(
                AwsStepFunctionStateMachineTracingConfigurationDetails.BuilderImpl tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration != null ? tracingConfiguration.build() : null;
        }

        @Override
        public final Builder tracingConfiguration(AwsStepFunctionStateMachineTracingConfigurationDetails tracingConfiguration) {
            this.tracingConfiguration = tracingConfiguration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsStepFunctionStateMachineDetails build() {
            return new AwsStepFunctionStateMachineDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
