/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListCopier {
    static List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> copy(
            Collection<? extends AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam) {
        List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> list;
        if (awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam == null
                || awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> modifiableList = new ArrayList<>();
            awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> copyFromBuilder(
            Collection<? extends AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder> awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam) {
        List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> list;
        if (awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam == null
                || awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> modifiableList = new ArrayList<>();
            awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam.forEach(entry -> {
                AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails member = entry == null ? null
                        : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder> copyToBuilder(
            Collection<? extends AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam) {
        List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder> list;
        if (awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam == null
                || awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder> modifiableList = new ArrayList<>();
            awsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsListParam
                    .forEach(entry -> {
                        AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder member = entry == null ? null
                                : entry.toBuilder();
                        modifiableList.add(member);
                    });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
