/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon OpenSearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpenSearchServiceDomainDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsOpenSearchServiceDomainDetails.Builder, AwsOpenSearchServiceDomainDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsOpenSearchServiceDomainDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPolicies").getter(getter(AwsOpenSearchServiceDomainDetails::accessPolicies))
            .setter(setter(Builder::accessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AwsOpenSearchServiceDomainDetails::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsOpenSearchServiceDomainDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DOMAIN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainEndpoint").getter(getter(AwsOpenSearchServiceDomainDetails::domainEndpoint))
            .setter(setter(Builder::domainEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpoint").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(AwsOpenSearchServiceDomainDetails::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionAtRestOptions").getter(getter(AwsOpenSearchServiceDomainDetails::encryptionAtRestOptions))
            .setter(setter(Builder::encryptionAtRestOptions))
            .constructor(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build())
            .build();

    private static final SdkField<AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("NodeToNodeEncryptionOptions")
            .getter(getter(AwsOpenSearchServiceDomainDetails::nodeToNodeEncryptionOptions))
            .setter(setter(Builder::nodeToNodeEncryptionOptions))
            .constructor(AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions")
                    .build()).build();

    private static final SdkField<AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails> SERVICE_SOFTWARE_OPTIONS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ServiceSoftwareOptions").getter(getter(AwsOpenSearchServiceDomainDetails::serviceSoftwareOptions))
            .setter(setter(Builder::serviceSoftwareOptions))
            .constructor(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSoftwareOptions").build())
            .build();

    private static final SdkField<AwsOpenSearchServiceDomainClusterConfigDetails> CLUSTER_CONFIG_FIELD = SdkField
            .<AwsOpenSearchServiceDomainClusterConfigDetails> builder(MarshallingType.SDK_POJO).memberName("ClusterConfig")
            .getter(getter(AwsOpenSearchServiceDomainDetails::clusterConfig)).setter(setter(Builder::clusterConfig))
            .constructor(AwsOpenSearchServiceDomainClusterConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()).build();

    private static final SdkField<AwsOpenSearchServiceDomainDomainEndpointOptionsDetails> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainDomainEndpointOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("DomainEndpointOptions").getter(getter(AwsOpenSearchServiceDomainDetails::domainEndpointOptions))
            .setter(setter(Builder::domainEndpointOptions))
            .constructor(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final SdkField<AwsOpenSearchServiceDomainVpcOptionsDetails> VPC_OPTIONS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainVpcOptionsDetails> builder(MarshallingType.SDK_POJO).memberName("VpcOptions")
            .getter(getter(AwsOpenSearchServiceDomainDetails::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(AwsOpenSearchServiceDomainVpcOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()).build();

    private static final SdkField<AwsOpenSearchServiceDomainLogPublishingOptionsDetails> LOG_PUBLISHING_OPTIONS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainLogPublishingOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("LogPublishingOptions").getter(getter(AwsOpenSearchServiceDomainDetails::logPublishingOptions))
            .setter(setter(Builder::logPublishingOptions))
            .constructor(AwsOpenSearchServiceDomainLogPublishingOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build())
            .build();

    private static final SdkField<Map<String, String>> DOMAIN_ENDPOINTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DomainEndpoints")
            .getter(getter(AwsOpenSearchServiceDomainDetails::domainEndpoints))
            .setter(setter(Builder::domainEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpoints").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AdvancedSecurityOptions").getter(getter(AwsOpenSearchServiceDomainDetails::advancedSecurityOptions))
            .setter(setter(Builder::advancedSecurityOptions))
            .constructor(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ACCESS_POLICIES_FIELD, DOMAIN_NAME_FIELD, ID_FIELD, DOMAIN_ENDPOINT_FIELD, ENGINE_VERSION_FIELD,
            ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, SERVICE_SOFTWARE_OPTIONS_FIELD,
            CLUSTER_CONFIG_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD,
            DOMAIN_ENDPOINTS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String accessPolicies;

    private final String domainName;

    private final String id;

    private final String domainEndpoint;

    private final String engineVersion;

    private final AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions;

    private final AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions;

    private final AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions;

    private final AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig;

    private final AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions;

    private final AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions;

    private final AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions;

    private final Map<String, String> domainEndpoints;

    private final AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions;

    private AwsOpenSearchServiceDomainDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.accessPolicies = builder.accessPolicies;
        this.domainName = builder.domainName;
        this.id = builder.id;
        this.domainEndpoint = builder.domainEndpoint;
        this.engineVersion = builder.engineVersion;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.serviceSoftwareOptions = builder.serviceSoftwareOptions;
        this.clusterConfig = builder.clusterConfig;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.vpcOptions = builder.vpcOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpoints = builder.domainEndpoints;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
    }

    /**
     * <p>
     * The ARN of the OpenSearch Service domain.
     * </p>
     * 
     * @return The ARN of the OpenSearch Service domain.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * IAM policy document that specifies the access policies for the OpenSearch Service domain.
     * </p>
     * 
     * @return IAM policy document that specifies the access policies for the OpenSearch Service domain.
     */
    public final String accessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * The name of the endpoint.
     * </p>
     * 
     * @return The name of the endpoint.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The identifier of the domain.
     * </p>
     * 
     * @return The identifier of the domain.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The domain endpoint.
     * </p>
     * 
     * @return The domain endpoint.
     */
    public final String domainEndpoint() {
        return domainEndpoint;
    }

    /**
     * <p>
     * The version of the domain engine.
     * </p>
     * 
     * @return The version of the domain engine.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Details about the configuration for encryption at rest.
     * </p>
     * 
     * @return Details about the configuration for encryption at rest.
     */
    public final AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions() {
        return encryptionAtRestOptions;
    }

    /**
     * <p>
     * Details about the configuration for node-to-node encryption.
     * </p>
     * 
     * @return Details about the configuration for node-to-node encryption.
     */
    public final AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions() {
        return nodeToNodeEncryptionOptions;
    }

    /**
     * <p>
     * Information about the status of a domain relative to the latest service software.
     * </p>
     * 
     * @return Information about the status of a domain relative to the latest service software.
     */
    public final AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions() {
        return serviceSoftwareOptions;
    }

    /**
     * <p>
     * Details about the configuration of an OpenSearch cluster.
     * </p>
     * 
     * @return Details about the configuration of an OpenSearch cluster.
     */
    public final AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig() {
        return clusterConfig;
    }

    /**
     * <p>
     * Additional options for the domain endpoint.
     * </p>
     * 
     * @return Additional options for the domain endpoint.
     */
    public final AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions() {
        return domainEndpointOptions;
    }

    /**
     * <p>
     * Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.
     * </p>
     * 
     * @return Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.
     */
    public final AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions() {
        return vpcOptions;
    }

    /**
     * <p>
     * Configures the CloudWatch Logs to publish for the OpenSearch domain.
     * </p>
     * 
     * @return Configures the CloudWatch Logs to publish for the OpenSearch domain.
     */
    public final AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions() {
        return logPublishingOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainEndpoints() {
        return domainEndpoints != null && !(domainEndpoints instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The domain endpoints. Used if the OpenSearch domain resides in a VPC.
     * </p>
     * <p>
     * This is a map of key-value pairs. The key is always <code>vpc</code>. The value is the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainEndpoints} method.
     * </p>
     * 
     * @return The domain endpoints. Used if the OpenSearch domain resides in a VPC.</p>
     *         <p>
     *         This is a map of key-value pairs. The key is always <code>vpc</code>. The value is the endpoint.
     */
    public final Map<String, String> domainEndpoints() {
        return domainEndpoints;
    }

    /**
     * <p>
     * Specifies options for fine-grained access control.
     * </p>
     * 
     * @return Specifies options for fine-grained access control.
     */
    public final AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions() {
        return advancedSecurityOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSoftwareOptions());
        hashCode = 31 * hashCode + Objects.hashCode(clusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainEndpoints() ? domainEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(advancedSecurityOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpenSearchServiceDomainDetails)) {
            return false;
        }
        AwsOpenSearchServiceDomainDetails other = (AwsOpenSearchServiceDomainDetails) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(accessPolicies(), other.accessPolicies())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(id(), other.id())
                && Objects.equals(domainEndpoint(), other.domainEndpoint())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(encryptionAtRestOptions(), other.encryptionAtRestOptions())
                && Objects.equals(nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions())
                && Objects.equals(serviceSoftwareOptions(), other.serviceSoftwareOptions())
                && Objects.equals(clusterConfig(), other.clusterConfig())
                && Objects.equals(domainEndpointOptions(), other.domainEndpointOptions())
                && Objects.equals(vpcOptions(), other.vpcOptions())
                && Objects.equals(logPublishingOptions(), other.logPublishingOptions())
                && hasDomainEndpoints() == other.hasDomainEndpoints()
                && Objects.equals(domainEndpoints(), other.domainEndpoints())
                && Objects.equals(advancedSecurityOptions(), other.advancedSecurityOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpenSearchServiceDomainDetails").add("Arn", arn()).add("AccessPolicies", accessPolicies())
                .add("DomainName", domainName()).add("Id", id()).add("DomainEndpoint", domainEndpoint())
                .add("EngineVersion", engineVersion()).add("EncryptionAtRestOptions", encryptionAtRestOptions())
                .add("NodeToNodeEncryptionOptions", nodeToNodeEncryptionOptions())
                .add("ServiceSoftwareOptions", serviceSoftwareOptions()).add("ClusterConfig", clusterConfig())
                .add("DomainEndpointOptions", domainEndpointOptions()).add("VpcOptions", vpcOptions())
                .add("LogPublishingOptions", logPublishingOptions())
                .add("DomainEndpoints", hasDomainEndpoints() ? domainEndpoints() : null)
                .add("AdvancedSecurityOptions", advancedSecurityOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AccessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "DomainEndpoint":
            return Optional.ofNullable(clazz.cast(domainEndpoint()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EncryptionAtRestOptions":
            return Optional.ofNullable(clazz.cast(encryptionAtRestOptions()));
        case "NodeToNodeEncryptionOptions":
            return Optional.ofNullable(clazz.cast(nodeToNodeEncryptionOptions()));
        case "ServiceSoftwareOptions":
            return Optional.ofNullable(clazz.cast(serviceSoftwareOptions()));
        case "ClusterConfig":
            return Optional.ofNullable(clazz.cast(clusterConfig()));
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        case "VpcOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        case "LogPublishingOptions":
            return Optional.ofNullable(clazz.cast(logPublishingOptions()));
        case "DomainEndpoints":
            return Optional.ofNullable(clazz.cast(domainEndpoints()));
        case "AdvancedSecurityOptions":
            return Optional.ofNullable(clazz.cast(advancedSecurityOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsOpenSearchServiceDomainDetails, T> g) {
        return obj -> g.apply((AwsOpenSearchServiceDomainDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpenSearchServiceDomainDetails> {
        /**
         * <p>
         * The ARN of the OpenSearch Service domain.
         * </p>
         * 
         * @param arn
         *        The ARN of the OpenSearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * IAM policy document that specifies the access policies for the OpenSearch Service domain.
         * </p>
         * 
         * @param accessPolicies
         *        IAM policy document that specifies the access policies for the OpenSearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(String accessPolicies);

        /**
         * <p>
         * The name of the endpoint.
         * </p>
         * 
         * @param domainName
         *        The name of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The identifier of the domain.
         * </p>
         * 
         * @param id
         *        The identifier of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The domain endpoint.
         * </p>
         * 
         * @param domainEndpoint
         *        The domain endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpoint(String domainEndpoint);

        /**
         * <p>
         * The version of the domain engine.
         * </p>
         * 
         * @param engineVersion
         *        The version of the domain engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Details about the configuration for encryption at rest.
         * </p>
         * 
         * @param encryptionAtRestOptions
         *        Details about the configuration for encryption at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRestOptions(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions);

        /**
         * <p>
         * Details about the configuration for encryption at rest.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #encryptionAtRestOptions(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails)}.
         * 
         * @param encryptionAtRestOptions
         *        a consumer that will call methods on
         *        {@link AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRestOptions(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails)
         */
        default Builder encryptionAtRestOptions(
                Consumer<AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder> encryptionAtRestOptions) {
            return encryptionAtRestOptions(AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.builder()
                    .applyMutation(encryptionAtRestOptions).build());
        }

        /**
         * <p>
         * Details about the configuration for node-to-node encryption.
         * </p>
         * 
         * @param nodeToNodeEncryptionOptions
         *        Details about the configuration for node-to-node encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeToNodeEncryptionOptions(
                AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions);

        /**
         * <p>
         * Details about the configuration for node-to-node encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #nodeToNodeEncryptionOptions(AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails)}.
         * 
         * @param nodeToNodeEncryptionOptions
         *        a consumer that will call methods on
         *        {@link AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeToNodeEncryptionOptions(AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails)
         */
        default Builder nodeToNodeEncryptionOptions(
                Consumer<AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder> nodeToNodeEncryptionOptions) {
            return nodeToNodeEncryptionOptions(AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.builder()
                    .applyMutation(nodeToNodeEncryptionOptions).build());
        }

        /**
         * <p>
         * Information about the status of a domain relative to the latest service software.
         * </p>
         * 
         * @param serviceSoftwareOptions
         *        Information about the status of a domain relative to the latest service software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSoftwareOptions(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions);

        /**
         * <p>
         * Information about the status of a domain relative to the latest service software.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceSoftwareOptions(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails)}.
         * 
         * @param serviceSoftwareOptions
         *        a consumer that will call methods on
         *        {@link AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSoftwareOptions(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails)
         */
        default Builder serviceSoftwareOptions(
                Consumer<AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder> serviceSoftwareOptions) {
            return serviceSoftwareOptions(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.builder()
                    .applyMutation(serviceSoftwareOptions).build());
        }

        /**
         * <p>
         * Details about the configuration of an OpenSearch cluster.
         * </p>
         * 
         * @param clusterConfig
         *        Details about the configuration of an OpenSearch cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig);

        /**
         * <p>
         * Details about the configuration of an OpenSearch cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainClusterConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsOpenSearchServiceDomainClusterConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsOpenSearchServiceDomainClusterConfigDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #clusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails)}.
         * 
         * @param clusterConfig
         *        a consumer that will call methods on {@link AwsOpenSearchServiceDomainClusterConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails)
         */
        default Builder clusterConfig(Consumer<AwsOpenSearchServiceDomainClusterConfigDetails.Builder> clusterConfig) {
            return clusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails.builder().applyMutation(clusterConfig).build());
        }

        /**
         * <p>
         * Additional options for the domain endpoint.
         * </p>
         * 
         * @param domainEndpointOptions
         *        Additional options for the domain endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions);

        /**
         * <p>
         * Additional options for the domain endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsOpenSearchServiceDomainDomainEndpointOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #domainEndpointOptions(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on
         *        {@link AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails)
         */
        default Builder domainEndpointOptions(
                Consumer<AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder> domainEndpointOptions) {
            return domainEndpointOptions(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.builder()
                    .applyMutation(domainEndpointOptions).build());
        }

        /**
         * <p>
         * Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.
         * </p>
         * 
         * @param vpcOptions
         *        Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions);

        /**
         * <p>
         * Information that OpenSearch Service derives based on <code>VPCOptions</code> for the domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainVpcOptionsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsOpenSearchServiceDomainVpcOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsOpenSearchServiceDomainVpcOptionsDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #vpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link AwsOpenSearchServiceDomainVpcOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails)
         */
        default Builder vpcOptions(Consumer<AwsOpenSearchServiceDomainVpcOptionsDetails.Builder> vpcOptions) {
            return vpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails.builder().applyMutation(vpcOptions).build());
        }

        /**
         * <p>
         * Configures the CloudWatch Logs to publish for the OpenSearch domain.
         * </p>
         * 
         * @param logPublishingOptions
         *        Configures the CloudWatch Logs to publish for the OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptions(AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions);

        /**
         * <p>
         * Configures the CloudWatch Logs to publish for the OpenSearch domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsOpenSearchServiceDomainLogPublishingOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #logPublishingOptions(AwsOpenSearchServiceDomainLogPublishingOptionsDetails)}.
         * 
         * @param logPublishingOptions
         *        a consumer that will call methods on
         *        {@link AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingOptions(AwsOpenSearchServiceDomainLogPublishingOptionsDetails)
         */
        default Builder logPublishingOptions(
                Consumer<AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder> logPublishingOptions) {
            return logPublishingOptions(AwsOpenSearchServiceDomainLogPublishingOptionsDetails.builder()
                    .applyMutation(logPublishingOptions).build());
        }

        /**
         * <p>
         * The domain endpoints. Used if the OpenSearch domain resides in a VPC.
         * </p>
         * <p>
         * This is a map of key-value pairs. The key is always <code>vpc</code>. The value is the endpoint.
         * </p>
         * 
         * @param domainEndpoints
         *        The domain endpoints. Used if the OpenSearch domain resides in a VPC.</p>
         *        <p>
         *        This is a map of key-value pairs. The key is always <code>vpc</code>. The value is the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpoints(Map<String, String> domainEndpoints);

        /**
         * <p>
         * Specifies options for fine-grained access control.
         * </p>
         * 
         * @param advancedSecurityOptions
         *        Specifies options for fine-grained access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedSecurityOptions(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions);

        /**
         * <p>
         * Specifies options for fine-grained access control.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #advancedSecurityOptions(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails)}.
         * 
         * @param advancedSecurityOptions
         *        a consumer that will call methods on
         *        {@link AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedSecurityOptions(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails)
         */
        default Builder advancedSecurityOptions(
                Consumer<AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder> advancedSecurityOptions) {
            return advancedSecurityOptions(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.builder()
                    .applyMutation(advancedSecurityOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String accessPolicies;

        private String domainName;

        private String id;

        private String domainEndpoint;

        private String engineVersion;

        private AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions;

        private AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions;

        private AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions;

        private AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig;

        private AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions;

        private AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions;

        private AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions;

        private Map<String, String> domainEndpoints = DefaultSdkAutoConstructMap.getInstance();

        private AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpenSearchServiceDomainDetails model) {
            arn(model.arn);
            accessPolicies(model.accessPolicies);
            domainName(model.domainName);
            id(model.id);
            domainEndpoint(model.domainEndpoint);
            engineVersion(model.engineVersion);
            encryptionAtRestOptions(model.encryptionAtRestOptions);
            nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            serviceSoftwareOptions(model.serviceSoftwareOptions);
            clusterConfig(model.clusterConfig);
            domainEndpointOptions(model.domainEndpointOptions);
            vpcOptions(model.vpcOptions);
            logPublishingOptions(model.logPublishingOptions);
            domainEndpoints(model.domainEndpoints);
            advancedSecurityOptions(model.advancedSecurityOptions);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAccessPolicies() {
            return accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDomainEndpoint() {
            return domainEndpoint;
        }

        public final void setDomainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
        }

        @Override
        public final Builder domainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder getEncryptionAtRestOptions() {
            return encryptionAtRestOptions != null ? encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(
                AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(
                AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder getNodeToNodeEncryptionOptions() {
            return nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(
                AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(
                AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder getServiceSoftwareOptions() {
            return serviceSoftwareOptions != null ? serviceSoftwareOptions.toBuilder() : null;
        }

        public final void setServiceSoftwareOptions(
                AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.BuilderImpl serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions != null ? serviceSoftwareOptions.build() : null;
        }

        @Override
        public final Builder serviceSoftwareOptions(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainClusterConfigDetails.Builder getClusterConfig() {
            return clusterConfig != null ? clusterConfig.toBuilder() : null;
        }

        public final void setClusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        public final Builder clusterConfig(AwsOpenSearchServiceDomainClusterConfigDetails clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(
                AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainVpcOptionsDetails.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(AwsOpenSearchServiceDomainVpcOptionsDetails vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder getLogPublishingOptions() {
            return logPublishingOptions != null ? logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(
                AwsOpenSearchServiceDomainLogPublishingOptionsDetails.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(AwsOpenSearchServiceDomainLogPublishingOptionsDetails logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final Map<String, String> getDomainEndpoints() {
            if (domainEndpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return domainEndpoints;
        }

        public final void setDomainEndpoints(Map<String, String> domainEndpoints) {
            this.domainEndpoints = FieldMapCopier.copy(domainEndpoints);
        }

        @Override
        public final Builder domainEndpoints(Map<String, String> domainEndpoints) {
            this.domainEndpoints = FieldMapCopier.copy(domainEndpoints);
            return this;
        }

        public final AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder getAdvancedSecurityOptions() {
            return advancedSecurityOptions != null ? advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(
                AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(
                AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        @Override
        public AwsOpenSearchServiceDomainDetails build() {
            return new AwsOpenSearchServiceDomainDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
