/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about domain access control options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder, AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Boolean> INTERNAL_USER_DATABASE_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InternalUserDatabaseEnabled")
            .getter(getter(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails::internalUserDatabaseEnabled))
            .setter(setter(Builder::internalUserDatabaseEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternalUserDatabaseEnabled")
                    .build()).build();

    private static final SdkField<AwsOpenSearchServiceDomainMasterUserOptionsDetails> MASTER_USER_OPTIONS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainMasterUserOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("MasterUserOptions")
            .getter(getter(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails::masterUserOptions))
            .setter(setter(Builder::masterUserOptions)).constructor(AwsOpenSearchServiceDomainMasterUserOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            INTERNAL_USER_DATABASE_ENABLED_FIELD, MASTER_USER_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Boolean internalUserDatabaseEnabled;

    private final AwsOpenSearchServiceDomainMasterUserOptionsDetails masterUserOptions;

    private AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
        this.masterUserOptions = builder.masterUserOptions;
    }

    /**
     * <p>
     * Enables fine-grained access control.
     * </p>
     * 
     * @return Enables fine-grained access control.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Enables the internal user database.
     * </p>
     * 
     * @return Enables the internal user database.
     */
    public final Boolean internalUserDatabaseEnabled() {
        return internalUserDatabaseEnabled;
    }

    /**
     * <p>
     * Specifies information about the master user of the domain.
     * </p>
     * 
     * @return Specifies information about the master user of the domain.
     */
    public final AwsOpenSearchServiceDomainMasterUserOptionsDetails masterUserOptions() {
        return masterUserOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(internalUserDatabaseEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails)) {
            return false;
        }
        AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails other = (AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(internalUserDatabaseEnabled(), other.internalUserDatabaseEnabled())
                && Objects.equals(masterUserOptions(), other.masterUserOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails").add("Enabled", enabled())
                .add("InternalUserDatabaseEnabled", internalUserDatabaseEnabled()).add("MasterUserOptions", masterUserOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "InternalUserDatabaseEnabled":
            return Optional.ofNullable(clazz.cast(internalUserDatabaseEnabled()));
        case "MasterUserOptions":
            return Optional.ofNullable(clazz.cast(masterUserOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails, T> g) {
        return obj -> g.apply((AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails> {
        /**
         * <p>
         * Enables fine-grained access control.
         * </p>
         * 
         * @param enabled
         *        Enables fine-grained access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Enables the internal user database.
         * </p>
         * 
         * @param internalUserDatabaseEnabled
         *        Enables the internal user database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled);

        /**
         * <p>
         * Specifies information about the master user of the domain.
         * </p>
         * 
         * @param masterUserOptions
         *        Specifies information about the master user of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserOptions(AwsOpenSearchServiceDomainMasterUserOptionsDetails masterUserOptions);

        /**
         * <p>
         * Specifies information about the master user of the domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsOpenSearchServiceDomainMasterUserOptionsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsOpenSearchServiceDomainMasterUserOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsOpenSearchServiceDomainMasterUserOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #masterUserOptions(AwsOpenSearchServiceDomainMasterUserOptionsDetails)}.
         * 
         * @param masterUserOptions
         *        a consumer that will call methods on
         *        {@link AwsOpenSearchServiceDomainMasterUserOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #masterUserOptions(AwsOpenSearchServiceDomainMasterUserOptionsDetails)
         */
        default Builder masterUserOptions(Consumer<AwsOpenSearchServiceDomainMasterUserOptionsDetails.Builder> masterUserOptions) {
            return masterUserOptions(AwsOpenSearchServiceDomainMasterUserOptionsDetails.builder()
                    .applyMutation(masterUserOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean internalUserDatabaseEnabled;

        private AwsOpenSearchServiceDomainMasterUserOptionsDetails masterUserOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails model) {
            enabled(model.enabled);
            internalUserDatabaseEnabled(model.internalUserDatabaseEnabled);
            masterUserOptions(model.masterUserOptions);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getInternalUserDatabaseEnabled() {
            return internalUserDatabaseEnabled;
        }

        public final void setInternalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
        }

        @Override
        public final Builder internalUserDatabaseEnabled(Boolean internalUserDatabaseEnabled) {
            this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
            return this;
        }

        public final AwsOpenSearchServiceDomainMasterUserOptionsDetails.Builder getMasterUserOptions() {
            return masterUserOptions != null ? masterUserOptions.toBuilder() : null;
        }

        public final void setMasterUserOptions(AwsOpenSearchServiceDomainMasterUserOptionsDetails.BuilderImpl masterUserOptions) {
            this.masterUserOptions = masterUserOptions != null ? masterUserOptions.build() : null;
        }

        @Override
        public final Builder masterUserOptions(AwsOpenSearchServiceDomainMasterUserOptionsDetails masterUserOptions) {
            this.masterUserOptions = masterUserOptions;
            return this;
        }

        @Override
        public AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails build() {
            return new AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
