/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A relationship between a security group and a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2SecurityGroupUserIdGroupPair implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2SecurityGroupUserIdGroupPair.Builder, AwsEc2SecurityGroupUserIdGroupPair> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(AwsEc2SecurityGroupUserIdGroupPair::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(AwsEc2SecurityGroupUserIdGroupPair::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> PEERING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeeringStatus").getter(getter(AwsEc2SecurityGroupUserIdGroupPair::peeringStatus))
            .setter(setter(Builder::peeringStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringStatus").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(AwsEc2SecurityGroupUserIdGroupPair::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsEc2SecurityGroupUserIdGroupPair::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId").getter(getter(AwsEc2SecurityGroupUserIdGroupPair::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD,
            GROUP_NAME_FIELD, PEERING_STATUS_FIELD, USER_ID_FIELD, VPC_ID_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupId;

    private final String groupName;

    private final String peeringStatus;

    private final String userId;

    private final String vpcId;

    private final String vpcPeeringConnectionId;

    private AwsEc2SecurityGroupUserIdGroupPair(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.peeringStatus = builder.peeringStatus;
        this.userId = builder.userId;
        this.vpcId = builder.vpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The status of a VPC peering connection, if applicable.
     * </p>
     * 
     * @return The status of a VPC peering connection, if applicable.
     */
    public final String peeringStatus() {
        return peeringStatus;
    }

    /**
     * <p>
     * The ID of an Amazon Web Services account.
     * </p>
     * <p>
     * For a referenced security group in another VPC, the account ID of the referenced security group is returned in
     * the response. If the referenced security group is deleted, this value is not returned.
     * </p>
     * <p>
     * [EC2-Classic] Required when adding or removing rules that reference a security group in another VPC.
     * </p>
     * 
     * @return The ID of an Amazon Web Services account.</p>
     *         <p>
     *         For a referenced security group in another VPC, the account ID of the referenced security group is
     *         returned in the response. If the referenced security group is deleted, this value is not returned.
     *         </p>
     *         <p>
     *         [EC2-Classic] Required when adding or removing rules that reference a security group in another VPC.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The ID of the VPC for the referenced security group, if applicable.
     * </p>
     * 
     * @return The ID of the VPC for the referenced security group, if applicable.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ID of the VPC peering connection, if applicable.
     * </p>
     * 
     * @return The ID of the VPC peering connection, if applicable.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(peeringStatus());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2SecurityGroupUserIdGroupPair)) {
            return false;
        }
        AwsEc2SecurityGroupUserIdGroupPair other = (AwsEc2SecurityGroupUserIdGroupPair) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(peeringStatus(), other.peeringStatus()) && Objects.equals(userId(), other.userId())
                && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2SecurityGroupUserIdGroupPair").add("GroupId", groupId()).add("GroupName", groupName())
                .add("PeeringStatus", peeringStatus()).add("UserId", userId()).add("VpcId", vpcId())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "PeeringStatus":
            return Optional.ofNullable(clazz.cast(peeringStatus()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2SecurityGroupUserIdGroupPair, T> g) {
        return obj -> g.apply((AwsEc2SecurityGroupUserIdGroupPair) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2SecurityGroupUserIdGroupPair> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The status of a VPC peering connection, if applicable.
         * </p>
         * 
         * @param peeringStatus
         *        The status of a VPC peering connection, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringStatus(String peeringStatus);

        /**
         * <p>
         * The ID of an Amazon Web Services account.
         * </p>
         * <p>
         * For a referenced security group in another VPC, the account ID of the referenced security group is returned
         * in the response. If the referenced security group is deleted, this value is not returned.
         * </p>
         * <p>
         * [EC2-Classic] Required when adding or removing rules that reference a security group in another VPC.
         * </p>
         * 
         * @param userId
         *        The ID of an Amazon Web Services account.</p>
         *        <p>
         *        For a referenced security group in another VPC, the account ID of the referenced security group is
         *        returned in the response. If the referenced security group is deleted, this value is not returned.
         *        </p>
         *        <p>
         *        [EC2-Classic] Required when adding or removing rules that reference a security group in another VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The ID of the VPC for the referenced security group, if applicable.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the referenced security group, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the VPC peering connection, if applicable.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String groupName;

        private String peeringStatus;

        private String userId;

        private String vpcId;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2SecurityGroupUserIdGroupPair model) {
            groupId(model.groupId);
            groupName(model.groupName);
            peeringStatus(model.peeringStatus);
            userId(model.userId);
            vpcId(model.vpcId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getPeeringStatus() {
            return peeringStatus;
        }

        public final void setPeeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
        }

        @Override
        public final Builder peeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        @Override
        public AwsEc2SecurityGroupUserIdGroupPair build() {
            return new AwsEc2SecurityGroupUserIdGroupPair(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
