/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the restore for the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableRestoreSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableRestoreSummary.Builder, AwsDynamoDbTableRestoreSummary> {
    private static final SdkField<String> SOURCE_BACKUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBackupArn").getter(getter(AwsDynamoDbTableRestoreSummary::sourceBackupArn))
            .setter(setter(Builder::sourceBackupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupArn").build()).build();

    private static final SdkField<String> SOURCE_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceTableArn").getter(getter(AwsDynamoDbTableRestoreSummary::sourceTableArn))
            .setter(setter(Builder::sourceTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableArn").build()).build();

    private static final SdkField<String> RESTORE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreDateTime").getter(getter(AwsDynamoDbTableRestoreSummary::restoreDateTime))
            .setter(setter(Builder::restoreDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreDateTime").build()).build();

    private static final SdkField<Boolean> RESTORE_IN_PROGRESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RestoreInProgress").getter(getter(AwsDynamoDbTableRestoreSummary::restoreInProgress))
            .setter(setter(Builder::restoreInProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreInProgress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_BACKUP_ARN_FIELD,
            SOURCE_TABLE_ARN_FIELD, RESTORE_DATE_TIME_FIELD, RESTORE_IN_PROGRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceBackupArn;

    private final String sourceTableArn;

    private final String restoreDateTime;

    private final Boolean restoreInProgress;

    private AwsDynamoDbTableRestoreSummary(BuilderImpl builder) {
        this.sourceBackupArn = builder.sourceBackupArn;
        this.sourceTableArn = builder.sourceTableArn;
        this.restoreDateTime = builder.restoreDateTime;
        this.restoreInProgress = builder.restoreInProgress;
    }

    /**
     * <p>
     * The ARN of the source backup from which the table was restored.
     * </p>
     * 
     * @return The ARN of the source backup from which the table was restored.
     */
    public final String sourceBackupArn() {
        return sourceBackupArn;
    }

    /**
     * <p>
     * The ARN of the source table for the backup.
     * </p>
     * 
     * @return The ARN of the source table for the backup.
     */
    public final String sourceTableArn() {
        return sourceTableArn;
    }

    /**
     * <p>
     * Indicates the point in time that the table was restored to.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates the point in time that the table was restored to.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String restoreDateTime() {
        return restoreDateTime;
    }

    /**
     * <p>
     * Whether a restore is currently in progress.
     * </p>
     * 
     * @return Whether a restore is currently in progress.
     */
    public final Boolean restoreInProgress() {
        return restoreInProgress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreInProgress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableRestoreSummary)) {
            return false;
        }
        AwsDynamoDbTableRestoreSummary other = (AwsDynamoDbTableRestoreSummary) obj;
        return Objects.equals(sourceBackupArn(), other.sourceBackupArn())
                && Objects.equals(sourceTableArn(), other.sourceTableArn())
                && Objects.equals(restoreDateTime(), other.restoreDateTime())
                && Objects.equals(restoreInProgress(), other.restoreInProgress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableRestoreSummary").add("SourceBackupArn", sourceBackupArn())
                .add("SourceTableArn", sourceTableArn()).add("RestoreDateTime", restoreDateTime())
                .add("RestoreInProgress", restoreInProgress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceBackupArn":
            return Optional.ofNullable(clazz.cast(sourceBackupArn()));
        case "SourceTableArn":
            return Optional.ofNullable(clazz.cast(sourceTableArn()));
        case "RestoreDateTime":
            return Optional.ofNullable(clazz.cast(restoreDateTime()));
        case "RestoreInProgress":
            return Optional.ofNullable(clazz.cast(restoreInProgress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableRestoreSummary, T> g) {
        return obj -> g.apply((AwsDynamoDbTableRestoreSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableRestoreSummary> {
        /**
         * <p>
         * The ARN of the source backup from which the table was restored.
         * </p>
         * 
         * @param sourceBackupArn
         *        The ARN of the source backup from which the table was restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupArn(String sourceBackupArn);

        /**
         * <p>
         * The ARN of the source table for the backup.
         * </p>
         * 
         * @param sourceTableArn
         *        The ARN of the source table for the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableArn(String sourceTableArn);

        /**
         * <p>
         * Indicates the point in time that the table was restored to.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param restoreDateTime
         *        Indicates the point in time that the table was restored to.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDateTime(String restoreDateTime);

        /**
         * <p>
         * Whether a restore is currently in progress.
         * </p>
         * 
         * @param restoreInProgress
         *        Whether a restore is currently in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreInProgress(Boolean restoreInProgress);
    }

    static final class BuilderImpl implements Builder {
        private String sourceBackupArn;

        private String sourceTableArn;

        private String restoreDateTime;

        private Boolean restoreInProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableRestoreSummary model) {
            sourceBackupArn(model.sourceBackupArn);
            sourceTableArn(model.sourceTableArn);
            restoreDateTime(model.restoreDateTime);
            restoreInProgress(model.restoreInProgress);
        }

        public final String getSourceBackupArn() {
            return sourceBackupArn;
        }

        public final void setSourceBackupArn(String sourceBackupArn) {
            this.sourceBackupArn = sourceBackupArn;
        }

        @Override
        public final Builder sourceBackupArn(String sourceBackupArn) {
            this.sourceBackupArn = sourceBackupArn;
            return this;
        }

        public final String getSourceTableArn() {
            return sourceTableArn;
        }

        public final void setSourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
        }

        @Override
        public final Builder sourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
            return this;
        }

        public final String getRestoreDateTime() {
            return restoreDateTime;
        }

        public final void setRestoreDateTime(String restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
        }

        @Override
        public final Builder restoreDateTime(String restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
            return this;
        }

        public final Boolean getRestoreInProgress() {
            return restoreInProgress;
        }

        public final void setRestoreInProgress(Boolean restoreInProgress) {
            this.restoreInProgress = restoreInProgress;
        }

        @Override
        public final Builder restoreInProgress(Boolean restoreInProgress) {
            this.restoreInProgress = restoreInProgress;
            return this;
        }

        @Override
        public AwsDynamoDbTableRestoreSummary build() {
            return new AwsDynamoDbTableRestoreSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
