/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the replication subnet group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDmsReplicationInstanceReplicationSubnetGroupDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder, AwsDmsReplicationInstanceReplicationSubnetGroupDetails> {
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationSubnetGroupIdentifier")
            .getter(getter(AwsDmsReplicationInstanceReplicationSubnetGroupDetails::replicationSubnetGroupIdentifier))
            .setter(setter(Builder::replicationSubnetGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationSubnetGroupIdentifier;

    private AwsDmsReplicationInstanceReplicationSubnetGroupDetails(BuilderImpl builder) {
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
    }

    /**
     * <p>
     * The identifier of the replication subnet group.
     * </p>
     * 
     * @return The identifier of the replication subnet group.
     */
    public final String replicationSubnetGroupIdentifier() {
        return replicationSubnetGroupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDmsReplicationInstanceReplicationSubnetGroupDetails)) {
            return false;
        }
        AwsDmsReplicationInstanceReplicationSubnetGroupDetails other = (AwsDmsReplicationInstanceReplicationSubnetGroupDetails) obj;
        return Objects.equals(replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDmsReplicationInstanceReplicationSubnetGroupDetails")
                .add("ReplicationSubnetGroupIdentifier", replicationSubnetGroupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationSubnetGroupIdentifier":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDmsReplicationInstanceReplicationSubnetGroupDetails, T> g) {
        return obj -> g.apply((AwsDmsReplicationInstanceReplicationSubnetGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDmsReplicationInstanceReplicationSubnetGroupDetails> {
        /**
         * <p>
         * The identifier of the replication subnet group.
         * </p>
         * 
         * @param replicationSubnetGroupIdentifier
         *        The identifier of the replication subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String replicationSubnetGroupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDmsReplicationInstanceReplicationSubnetGroupDetails model) {
            replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return replicationSubnetGroupIdentifier;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        @Override
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        @Override
        public AwsDmsReplicationInstanceReplicationSubnetGroupDetails build() {
            return new AwsDmsReplicationInstanceReplicationSubnetGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
