/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the management of a security standard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardsManagedBy implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardsManagedBy.Builder, StandardsManagedBy> {
    private static final SdkField<String> COMPANY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Company")
            .getter(getter(StandardsManagedBy::company)).setter(setter(Builder::company))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Company").build()).build();

    private static final SdkField<String> PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Product")
            .getter(getter(StandardsManagedBy::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPANY_FIELD, PRODUCT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String company;

    private final String product;

    private StandardsManagedBy(BuilderImpl builder) {
        this.company = builder.company;
        this.product = builder.product;
    }

    /**
     * <p>
     * An identifier for the company that manages a specific security standard. For existing standards, the value is
     * equal to <code>Amazon Web Services</code>.
     * </p>
     * 
     * @return An identifier for the company that manages a specific security standard. For existing standards, the
     *         value is equal to <code>Amazon Web Services</code>.
     */
    public final String company() {
        return company;
    }

    /**
     * <p>
     * An identifier for the product that manages a specific security standard. For existing standards, the value is
     * equal to the Amazon Web Services service that manages the standard.
     * </p>
     * 
     * @return An identifier for the product that manages a specific security standard. For existing standards, the
     *         value is equal to the Amazon Web Services service that manages the standard.
     */
    public final String product() {
        return product;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(company());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsManagedBy)) {
            return false;
        }
        StandardsManagedBy other = (StandardsManagedBy) obj;
        return Objects.equals(company(), other.company()) && Objects.equals(product(), other.product());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StandardsManagedBy").add("Company", company()).add("Product", product()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Company":
            return Optional.ofNullable(clazz.cast(company()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StandardsManagedBy, T> g) {
        return obj -> g.apply((StandardsManagedBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardsManagedBy> {
        /**
         * <p>
         * An identifier for the company that manages a specific security standard. For existing standards, the value is
         * equal to <code>Amazon Web Services</code>.
         * </p>
         * 
         * @param company
         *        An identifier for the company that manages a specific security standard. For existing standards, the
         *        value is equal to <code>Amazon Web Services</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder company(String company);

        /**
         * <p>
         * An identifier for the product that manages a specific security standard. For existing standards, the value is
         * equal to the Amazon Web Services service that manages the standard.
         * </p>
         * 
         * @param product
         *        An identifier for the product that manages a specific security standard. For existing standards, the
         *        value is equal to the Amazon Web Services service that manages the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);
    }

    static final class BuilderImpl implements Builder {
        private String company;

        private String product;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsManagedBy model) {
            company(model.company);
            product(model.product);
        }

        public final String getCompany() {
            return company;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final String getProduct() {
            return product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        @Override
        public StandardsManagedBy build() {
            return new StandardsManagedBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
