/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a specific security standard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Standard implements SdkPojo, Serializable, ToCopyableBuilder<Standard.Builder, Standard> {
    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardsArn").getter(getter(Standard::standardsArn)).setter(setter(Builder::standardsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Standard::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Standard::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> ENABLED_BY_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnabledByDefault").getter(getter(Standard::enabledByDefault)).setter(setter(Builder::enabledByDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledByDefault").build()).build();

    private static final SdkField<StandardsManagedBy> STANDARDS_MANAGED_BY_FIELD = SdkField
            .<StandardsManagedBy> builder(MarshallingType.SDK_POJO).memberName("StandardsManagedBy")
            .getter(getter(Standard::standardsManagedBy)).setter(setter(Builder::standardsManagedBy))
            .constructor(StandardsManagedBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsManagedBy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ENABLED_BY_DEFAULT_FIELD, STANDARDS_MANAGED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String standardsArn;

    private final String name;

    private final String description;

    private final Boolean enabledByDefault;

    private final StandardsManagedBy standardsManagedBy;

    private Standard(BuilderImpl builder) {
        this.standardsArn = builder.standardsArn;
        this.name = builder.name;
        this.description = builder.description;
        this.enabledByDefault = builder.enabledByDefault;
        this.standardsManagedBy = builder.standardsManagedBy;
    }

    /**
     * <p>
     * The ARN of a standard.
     * </p>
     * 
     * @return The ARN of a standard.
     */
    public final String standardsArn() {
        return standardsArn;
    }

    /**
     * <p>
     * The name of the standard.
     * </p>
     * 
     * @return The name of the standard.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the standard.
     * </p>
     * 
     * @return A description of the standard.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the standard is enabled by default. When Security Hub is enabled from the console, if a standard is
     * enabled by default, the check box for that standard is selected by default.
     * </p>
     * <p>
     * When Security Hub is enabled using the <code>EnableSecurityHub</code> API operation, the standard is enabled by
     * default unless <code>EnableDefaultStandards</code> is set to <code>false</code>.
     * </p>
     * 
     * @return Whether the standard is enabled by default. When Security Hub is enabled from the console, if a standard
     *         is enabled by default, the check box for that standard is selected by default.</p>
     *         <p>
     *         When Security Hub is enabled using the <code>EnableSecurityHub</code> API operation, the standard is
     *         enabled by default unless <code>EnableDefaultStandards</code> is set to <code>false</code>.
     */
    public final Boolean enabledByDefault() {
        return enabledByDefault;
    }

    /**
     * <p>
     * Provides details about the management of a standard.
     * </p>
     * 
     * @return Provides details about the management of a standard.
     */
    public final StandardsManagedBy standardsManagedBy() {
        return standardsManagedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enabledByDefault());
        hashCode = 31 * hashCode + Objects.hashCode(standardsManagedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Standard)) {
            return false;
        }
        Standard other = (Standard) obj;
        return Objects.equals(standardsArn(), other.standardsArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(enabledByDefault(), other.enabledByDefault())
                && Objects.equals(standardsManagedBy(), other.standardsManagedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Standard").add("StandardsArn", standardsArn()).add("Name", name())
                .add("Description", description()).add("EnabledByDefault", enabledByDefault())
                .add("StandardsManagedBy", standardsManagedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsArn":
            return Optional.ofNullable(clazz.cast(standardsArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EnabledByDefault":
            return Optional.ofNullable(clazz.cast(enabledByDefault()));
        case "StandardsManagedBy":
            return Optional.ofNullable(clazz.cast(standardsManagedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Standard, T> g) {
        return obj -> g.apply((Standard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Standard> {
        /**
         * <p>
         * The ARN of a standard.
         * </p>
         * 
         * @param standardsArn
         *        The ARN of a standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsArn(String standardsArn);

        /**
         * <p>
         * The name of the standard.
         * </p>
         * 
         * @param name
         *        The name of the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the standard.
         * </p>
         * 
         * @param description
         *        A description of the standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the standard is enabled by default. When Security Hub is enabled from the console, if a standard is
         * enabled by default, the check box for that standard is selected by default.
         * </p>
         * <p>
         * When Security Hub is enabled using the <code>EnableSecurityHub</code> API operation, the standard is enabled
         * by default unless <code>EnableDefaultStandards</code> is set to <code>false</code>.
         * </p>
         * 
         * @param enabledByDefault
         *        Whether the standard is enabled by default. When Security Hub is enabled from the console, if a
         *        standard is enabled by default, the check box for that standard is selected by default.</p>
         *        <p>
         *        When Security Hub is enabled using the <code>EnableSecurityHub</code> API operation, the standard is
         *        enabled by default unless <code>EnableDefaultStandards</code> is set to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledByDefault(Boolean enabledByDefault);

        /**
         * <p>
         * Provides details about the management of a standard.
         * </p>
         * 
         * @param standardsManagedBy
         *        Provides details about the management of a standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsManagedBy(StandardsManagedBy standardsManagedBy);

        /**
         * <p>
         * Provides details about the management of a standard.
         * </p>
         * This is a convenience method that creates an instance of the {@link StandardsManagedBy.Builder} avoiding the
         * need to create one manually via {@link StandardsManagedBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StandardsManagedBy.Builder#build()} is called immediately and its
         * result is passed to {@link #standardsManagedBy(StandardsManagedBy)}.
         * 
         * @param standardsManagedBy
         *        a consumer that will call methods on {@link StandardsManagedBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardsManagedBy(StandardsManagedBy)
         */
        default Builder standardsManagedBy(Consumer<StandardsManagedBy.Builder> standardsManagedBy) {
            return standardsManagedBy(StandardsManagedBy.builder().applyMutation(standardsManagedBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String standardsArn;

        private String name;

        private String description;

        private Boolean enabledByDefault;

        private StandardsManagedBy standardsManagedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(Standard model) {
            standardsArn(model.standardsArn);
            name(model.name);
            description(model.description);
            enabledByDefault(model.enabledByDefault);
            standardsManagedBy(model.standardsManagedBy);
        }

        public final String getStandardsArn() {
            return standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnabledByDefault() {
            return enabledByDefault;
        }

        public final void setEnabledByDefault(Boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
        }

        @Override
        public final Builder enabledByDefault(Boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
            return this;
        }

        public final StandardsManagedBy.Builder getStandardsManagedBy() {
            return standardsManagedBy != null ? standardsManagedBy.toBuilder() : null;
        }

        public final void setStandardsManagedBy(StandardsManagedBy.BuilderImpl standardsManagedBy) {
            this.standardsManagedBy = standardsManagedBy != null ? standardsManagedBy.build() : null;
        }

        @Override
        public final Builder standardsManagedBy(StandardsManagedBy standardsManagedBy) {
            this.standardsManagedBy = standardsManagedBy;
            return this;
        }

        @Override
        public Standard build() {
            return new Standard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
