/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A port range to specify the source ports to inspect for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatelessRuleMatchAttributesSourcePorts
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.Builder, RuleGroupSourceStatelessRuleMatchAttributesSourcePorts> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort").getter(getter(RuleGroupSourceStatelessRuleMatchAttributesSourcePorts::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort").getter(getter(RuleGroupSourceStatelessRuleMatchAttributesSourcePorts::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FROM_PORT_FIELD, TO_PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fromPort;

    private final Integer toPort;

    private RuleGroupSourceStatelessRuleMatchAttributesSourcePorts(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
    }

    /**
     * <p>
     * The starting port value for the port range.
     * </p>
     * 
     * @return The starting port value for the port range.
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The ending port value for the port range.
     * </p>
     * 
     * @return The ending port value for the port range.
     */
    public final Integer toPort() {
        return toPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRuleMatchAttributesSourcePorts)) {
            return false;
        }
        RuleGroupSourceStatelessRuleMatchAttributesSourcePorts other = (RuleGroupSourceStatelessRuleMatchAttributesSourcePorts) obj;
        return Objects.equals(fromPort(), other.fromPort()) && Objects.equals(toPort(), other.toPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatelessRuleMatchAttributesSourcePorts").add("FromPort", fromPort())
                .add("ToPort", toPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRuleMatchAttributesSourcePorts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatelessRuleMatchAttributesSourcePorts> {
        /**
         * <p>
         * The starting port value for the port range.
         * </p>
         * 
         * @param fromPort
         *        The starting port value for the port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The ending port value for the port range.
         * </p>
         * 
         * @param toPort
         *        The ending port value for the port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private Integer toPort;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRuleMatchAttributesSourcePorts model) {
            fromPort(model.fromPort);
            toPort(model.toPort);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        @Override
        public RuleGroupSourceStatelessRuleMatchAttributesSourcePorts build() {
            return new RuleGroupSourceStatelessRuleMatchAttributesSourcePorts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
