/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about rules in a rule group. A rule identifies web requests that you want to allow, block, or count.
 * Each rule includes one top-level Statement that WAF uses to identify matching web requests, and parameters that
 * govern how WAF handles them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2RulesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2RulesDetails.Builder, AwsWafv2RulesDetails> {
    private static final SdkField<AwsWafv2RulesActionDetails> ACTION_FIELD = SdkField
            .<AwsWafv2RulesActionDetails> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(AwsWafv2RulesDetails::action)).setter(setter(Builder::action))
            .constructor(AwsWafv2RulesActionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsWafv2RulesDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OVERRIDE_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OverrideAction").getter(getter(AwsWafv2RulesDetails::overrideAction))
            .setter(setter(Builder::overrideAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideAction").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(AwsWafv2RulesDetails::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<AwsWafv2VisibilityConfigDetails> VISIBILITY_CONFIG_FIELD = SdkField
            .<AwsWafv2VisibilityConfigDetails> builder(MarshallingType.SDK_POJO).memberName("VisibilityConfig")
            .getter(getter(AwsWafv2RulesDetails::visibilityConfig)).setter(setter(Builder::visibilityConfig))
            .constructor(AwsWafv2VisibilityConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisibilityConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, NAME_FIELD,
            OVERRIDE_ACTION_FIELD, PRIORITY_FIELD, VISIBILITY_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsWafv2RulesActionDetails action;

    private final String name;

    private final String overrideAction;

    private final Integer priority;

    private final AwsWafv2VisibilityConfigDetails visibilityConfig;

    private AwsWafv2RulesDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.name = builder.name;
        this.overrideAction = builder.overrideAction;
        this.priority = builder.priority;
        this.visibilityConfig = builder.visibilityConfig;
    }

    /**
     * <p>
     * The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL
     * level can override the rule action setting.
     * </p>
     * 
     * @return The action that WAF should take on a web request when it matches the rule statement. Settings at the web
     *         ACL level can override the rule action setting.
     */
    public final AwsWafv2RulesActionDetails action() {
        return action;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The action to use in the place of the action that results from the rule group evaluation.
     * </p>
     * 
     * @return The action to use in the place of the action that results from the rule group evaluation.
     */
    public final String overrideAction() {
        return overrideAction;
    }

    /**
     * <p>
     * If you define more than one Rule in a WebACL, WAF evaluates each request against the Rules in order based on the
     * value of <code>Priority</code>. WAF processes rules with lower priority first. The priorities don't need to be
     * consecutive, but they must all be different.
     * </p>
     * 
     * @return If you define more than one Rule in a WebACL, WAF evaluates each request against the Rules in order based
     *         on the value of <code>Priority</code>. WAF processes rules with lower priority first. The priorities
     *         don't need to be consecutive, but they must all be different.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     * </p>
     * 
     * @return Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    public final AwsWafv2VisibilityConfigDetails visibilityConfig() {
        return visibilityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(overrideAction());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2RulesDetails)) {
            return false;
        }
        AwsWafv2RulesDetails other = (AwsWafv2RulesDetails) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(name(), other.name())
                && Objects.equals(overrideAction(), other.overrideAction()) && Objects.equals(priority(), other.priority())
                && Objects.equals(visibilityConfig(), other.visibilityConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2RulesDetails").add("Action", action()).add("Name", name())
                .add("OverrideAction", overrideAction()).add("Priority", priority()).add("VisibilityConfig", visibilityConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OverrideAction":
            return Optional.ofNullable(clazz.cast(overrideAction()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "VisibilityConfig":
            return Optional.ofNullable(clazz.cast(visibilityConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2RulesDetails, T> g) {
        return obj -> g.apply((AwsWafv2RulesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2RulesDetails> {
        /**
         * <p>
         * The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL
         * level can override the rule action setting.
         * </p>
         * 
         * @param action
         *        The action that WAF should take on a web request when it matches the rule statement. Settings at the
         *        web ACL level can override the rule action setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(AwsWafv2RulesActionDetails action);

        /**
         * <p>
         * The action that WAF should take on a web request when it matches the rule statement. Settings at the web ACL
         * level can override the rule action setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2RulesActionDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2RulesActionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2RulesActionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #action(AwsWafv2RulesActionDetails)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link AwsWafv2RulesActionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(AwsWafv2RulesActionDetails)
         */
        default Builder action(Consumer<AwsWafv2RulesActionDetails.Builder> action) {
            return action(AwsWafv2RulesActionDetails.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The action to use in the place of the action that results from the rule group evaluation.
         * </p>
         * 
         * @param overrideAction
         *        The action to use in the place of the action that results from the rule group evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAction(String overrideAction);

        /**
         * <p>
         * If you define more than one Rule in a WebACL, WAF evaluates each request against the Rules in order based on
         * the value of <code>Priority</code>. WAF processes rules with lower priority first. The priorities don't need
         * to be consecutive, but they must all be different.
         * </p>
         * 
         * @param priority
         *        If you define more than one Rule in a WebACL, WAF evaluates each request against the Rules in order
         *        based on the value of <code>Priority</code>. WAF processes rules with lower priority first. The
         *        priorities don't need to be consecutive, but they must all be different.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * 
         * @param visibilityConfig
         *        Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visibilityConfig(AwsWafv2VisibilityConfigDetails visibilityConfig);

        /**
         * <p>
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsWafv2VisibilityConfigDetails.Builder}
         * avoiding the need to create one manually via {@link AwsWafv2VisibilityConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsWafv2VisibilityConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #visibilityConfig(AwsWafv2VisibilityConfigDetails)}.
         * 
         * @param visibilityConfig
         *        a consumer that will call methods on {@link AwsWafv2VisibilityConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visibilityConfig(AwsWafv2VisibilityConfigDetails)
         */
        default Builder visibilityConfig(Consumer<AwsWafv2VisibilityConfigDetails.Builder> visibilityConfig) {
            return visibilityConfig(AwsWafv2VisibilityConfigDetails.builder().applyMutation(visibilityConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsWafv2RulesActionDetails action;

        private String name;

        private String overrideAction;

        private Integer priority;

        private AwsWafv2VisibilityConfigDetails visibilityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2RulesDetails model) {
            action(model.action);
            name(model.name);
            overrideAction(model.overrideAction);
            priority(model.priority);
            visibilityConfig(model.visibilityConfig);
        }

        public final AwsWafv2RulesActionDetails.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(AwsWafv2RulesActionDetails.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(AwsWafv2RulesActionDetails action) {
            this.action = action;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOverrideAction() {
            return overrideAction;
        }

        public final void setOverrideAction(String overrideAction) {
            this.overrideAction = overrideAction;
        }

        @Override
        public final Builder overrideAction(String overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final AwsWafv2VisibilityConfigDetails.Builder getVisibilityConfig() {
            return visibilityConfig != null ? visibilityConfig.toBuilder() : null;
        }

        public final void setVisibilityConfig(AwsWafv2VisibilityConfigDetails.BuilderImpl visibilityConfig) {
            this.visibilityConfig = visibilityConfig != null ? visibilityConfig.build() : null;
        }

        @Override
        public final Builder visibilityConfig(AwsWafv2VisibilityConfigDetails visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        @Override
        public AwsWafv2RulesDetails build() {
            return new AwsWafv2RulesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
