/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an WAF Regional rule. This rule identifies the web requests that you want to allow, block,
 * or count.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafRegionalRuleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafRegionalRuleDetails.Builder, AwsWafRegionalRuleDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(AwsWafRegionalRuleDetails::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsWafRegionalRuleDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<AwsWafRegionalRulePredicateListDetails>> PREDICATE_LIST_FIELD = SdkField
            .<List<AwsWafRegionalRulePredicateListDetails>> builder(MarshallingType.LIST)
            .memberName("PredicateList")
            .getter(getter(AwsWafRegionalRuleDetails::predicateList))
            .setter(setter(Builder::predicateList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredicateList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafRegionalRulePredicateListDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafRegionalRulePredicateListDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(AwsWafRegionalRuleDetails::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAME_FIELD,
            PREDICATE_LIST_FIELD, RULE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String name;

    private final List<AwsWafRegionalRulePredicateListDetails> predicateList;

    private final String ruleId;

    private AwsWafRegionalRuleDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.predicateList = builder.predicateList;
        this.ruleId = builder.ruleId;
    }

    /**
     * <p>
     * A name for the metrics for the rule.
     * </p>
     * 
     * @return A name for the metrics for the rule.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * A descriptive name for the rule.
     * </p>
     * 
     * @return A descriptive name for the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the PredicateList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPredicateList() {
        return predicateList != null && !(predicateList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>,
     * <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and
     * <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether you
     * want to negate the settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredicateList} method.
     * </p>
     * 
     * @return Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>,
     *         <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and
     *         <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates
     *         whether you want to negate the settings.
     */
    public final List<AwsWafRegionalRulePredicateListDetails> predicateList() {
        return predicateList;
    }

    /**
     * <p>
     * The ID of the rule.
     * </p>
     * 
     * @return The ID of the rule.
     */
    public final String ruleId() {
        return ruleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasPredicateList() ? predicateList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRegionalRuleDetails)) {
            return false;
        }
        AwsWafRegionalRuleDetails other = (AwsWafRegionalRuleDetails) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(name(), other.name())
                && hasPredicateList() == other.hasPredicateList() && Objects.equals(predicateList(), other.predicateList())
                && Objects.equals(ruleId(), other.ruleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafRegionalRuleDetails").add("MetricName", metricName()).add("Name", name())
                .add("PredicateList", hasPredicateList() ? predicateList() : null).add("RuleId", ruleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PredicateList":
            return Optional.ofNullable(clazz.cast(predicateList()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRegionalRuleDetails, T> g) {
        return obj -> g.apply((AwsWafRegionalRuleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafRegionalRuleDetails> {
        /**
         * <p>
         * A name for the metrics for the rule.
         * </p>
         * 
         * @param metricName
         *        A name for the metrics for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * A descriptive name for the rule.
         * </p>
         * 
         * @param name
         *        A descriptive name for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>,
         * <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and
         * <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether
         * you want to negate the settings.
         * </p>
         * 
         * @param predicateList
         *        Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>,
         *        <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and
         *        <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates
         *        whether you want to negate the settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicateList(Collection<AwsWafRegionalRulePredicateListDetails> predicateList);

        /**
         * <p>
         * Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>,
         * <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and
         * <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether
         * you want to negate the settings.
         * </p>
         * 
         * @param predicateList
         *        Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>,
         *        <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and
         *        <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates
         *        whether you want to negate the settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicateList(AwsWafRegionalRulePredicateListDetails... predicateList);

        /**
         * <p>
         * Specifies the <code>ByteMatchSet</code>, <code>IPSet</code>, <code>SqlInjectionMatchSet</code>,
         * <code>XssMatchSet</code>, <code>RegexMatchSet</code>, <code>GeoMatchSet</code>, and
         * <code>SizeConstraintSet</code> objects that you want to add to a rule and, for each object, indicates whether
         * you want to negate the settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #predicateList(List<AwsWafRegionalRulePredicateListDetails>)}.
         * 
         * @param predicateList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predicateList(java.util.Collection<AwsWafRegionalRulePredicateListDetails>)
         */
        Builder predicateList(Consumer<AwsWafRegionalRulePredicateListDetails.Builder>... predicateList);

        /**
         * <p>
         * The ID of the rule.
         * </p>
         * 
         * @param ruleId
         *        The ID of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String name;

        private List<AwsWafRegionalRulePredicateListDetails> predicateList = DefaultSdkAutoConstructList.getInstance();

        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRegionalRuleDetails model) {
            metricName(model.metricName);
            name(model.name);
            predicateList(model.predicateList);
            ruleId(model.ruleId);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AwsWafRegionalRulePredicateListDetails.Builder> getPredicateList() {
            List<AwsWafRegionalRulePredicateListDetails.Builder> result = AwsWafRegionalRulePredicateListCopier
                    .copyToBuilder(this.predicateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredicateList(Collection<AwsWafRegionalRulePredicateListDetails.BuilderImpl> predicateList) {
            this.predicateList = AwsWafRegionalRulePredicateListCopier.copyFromBuilder(predicateList);
        }

        @Override
        public final Builder predicateList(Collection<AwsWafRegionalRulePredicateListDetails> predicateList) {
            this.predicateList = AwsWafRegionalRulePredicateListCopier.copy(predicateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicateList(AwsWafRegionalRulePredicateListDetails... predicateList) {
            predicateList(Arrays.asList(predicateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicateList(Consumer<AwsWafRegionalRulePredicateListDetails.Builder>... predicateList) {
            predicateList(Stream.of(predicateList)
                    .map(c -> AwsWafRegionalRulePredicateListDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        @Override
        public AwsWafRegionalRuleDetails build() {
            return new AwsWafRegionalRuleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
