/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * contains details about a rate-based rule for Regional resources. A rate-based rule provides settings to indicate when
 * to allow, block, or count a request. Rate-based rules include the number of requests that arrive over a specified
 * period of time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafRegionalRateBasedRuleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafRegionalRateBasedRuleDetails.Builder, AwsWafRegionalRateBasedRuleDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(AwsWafRegionalRateBasedRuleDetails::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsWafRegionalRateBasedRuleDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateKey").getter(getter(AwsWafRegionalRateBasedRuleDetails::rateKey)).setter(setter(Builder::rateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateKey").build()).build();

    private static final SdkField<Long> RATE_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("RateLimit")
            .getter(getter(AwsWafRegionalRateBasedRuleDetails::rateLimit)).setter(setter(Builder::rateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RateLimit").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(AwsWafRegionalRateBasedRuleDetails::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<List<AwsWafRegionalRateBasedRuleMatchPredicate>> MATCH_PREDICATES_FIELD = SdkField
            .<List<AwsWafRegionalRateBasedRuleMatchPredicate>> builder(MarshallingType.LIST)
            .memberName("MatchPredicates")
            .getter(getter(AwsWafRegionalRateBasedRuleDetails::matchPredicates))
            .setter(setter(Builder::matchPredicates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPredicates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafRegionalRateBasedRuleMatchPredicate> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafRegionalRateBasedRuleMatchPredicate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAME_FIELD,
            RATE_KEY_FIELD, RATE_LIMIT_FIELD, RULE_ID_FIELD, MATCH_PREDICATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String name;

    private final String rateKey;

    private final Long rateLimit;

    private final String ruleId;

    private final List<AwsWafRegionalRateBasedRuleMatchPredicate> matchPredicates;

    private AwsWafRegionalRateBasedRuleDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.rateKey = builder.rateKey;
        this.rateLimit = builder.rateLimit;
        this.ruleId = builder.ruleId;
        this.matchPredicates = builder.matchPredicates;
    }

    /**
     * <p>
     * The name of the metrics for the rate-based rule.
     * </p>
     * 
     * @return The name of the metrics for the rate-based rule.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The name of the rate-based rule.
     * </p>
     * 
     * @return The name of the rate-based rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The field that WAF uses to determine whether requests are likely arriving from single source and are subject to
     * rate monitoring.
     * </p>
     * 
     * @return The field that WAF uses to determine whether requests are likely arriving from single source and are
     *         subject to rate monitoring.
     */
    public final String rateKey() {
        return rateKey;
    }

    /**
     * <p>
     * The maximum number of requests that have an identical value for the field specified in <code>RateKey</code> that
     * are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and the other
     * predicates specified in the rule are met, WAF triggers the action for the rule.
     * </p>
     * 
     * @return The maximum number of requests that have an identical value for the field specified in
     *         <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds
     *         <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action
     *         for the rule.
     */
    public final Long rateLimit() {
        return rateLimit;
    }

    /**
     * <p>
     * The unique identifier for the rate-based rule.
     * </p>
     * 
     * @return The unique identifier for the rate-based rule.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchPredicates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchPredicates() {
        return matchPredicates != null && !(matchPredicates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The predicates to include in the rate-based rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchPredicates} method.
     * </p>
     * 
     * @return The predicates to include in the rate-based rule.
     */
    public final List<AwsWafRegionalRateBasedRuleMatchPredicate> matchPredicates() {
        return matchPredicates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(rateKey());
        hashCode = 31 * hashCode + Objects.hashCode(rateLimit());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchPredicates() ? matchPredicates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRegionalRateBasedRuleDetails)) {
            return false;
        }
        AwsWafRegionalRateBasedRuleDetails other = (AwsWafRegionalRateBasedRuleDetails) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(name(), other.name())
                && Objects.equals(rateKey(), other.rateKey()) && Objects.equals(rateLimit(), other.rateLimit())
                && Objects.equals(ruleId(), other.ruleId()) && hasMatchPredicates() == other.hasMatchPredicates()
                && Objects.equals(matchPredicates(), other.matchPredicates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafRegionalRateBasedRuleDetails").add("MetricName", metricName()).add("Name", name())
                .add("RateKey", rateKey()).add("RateLimit", rateLimit()).add("RuleId", ruleId())
                .add("MatchPredicates", hasMatchPredicates() ? matchPredicates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RateKey":
            return Optional.ofNullable(clazz.cast(rateKey()));
        case "RateLimit":
            return Optional.ofNullable(clazz.cast(rateLimit()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "MatchPredicates":
            return Optional.ofNullable(clazz.cast(matchPredicates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRegionalRateBasedRuleDetails, T> g) {
        return obj -> g.apply((AwsWafRegionalRateBasedRuleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafRegionalRateBasedRuleDetails> {
        /**
         * <p>
         * The name of the metrics for the rate-based rule.
         * </p>
         * 
         * @param metricName
         *        The name of the metrics for the rate-based rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The name of the rate-based rule.
         * </p>
         * 
         * @param name
         *        The name of the rate-based rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The field that WAF uses to determine whether requests are likely arriving from single source and are subject
         * to rate monitoring.
         * </p>
         * 
         * @param rateKey
         *        The field that WAF uses to determine whether requests are likely arriving from single source and are
         *        subject to rate monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateKey(String rateKey);

        /**
         * <p>
         * The maximum number of requests that have an identical value for the field specified in <code>RateKey</code>
         * that are allowed within a five-minute period. If the number of requests exceeds <code>RateLimit</code> and
         * the other predicates specified in the rule are met, WAF triggers the action for the rule.
         * </p>
         * 
         * @param rateLimit
         *        The maximum number of requests that have an identical value for the field specified in
         *        <code>RateKey</code> that are allowed within a five-minute period. If the number of requests exceeds
         *        <code>RateLimit</code> and the other predicates specified in the rule are met, WAF triggers the action
         *        for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateLimit(Long rateLimit);

        /**
         * <p>
         * The unique identifier for the rate-based rule.
         * </p>
         * 
         * @param ruleId
         *        The unique identifier for the rate-based rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The predicates to include in the rate-based rule.
         * </p>
         * 
         * @param matchPredicates
         *        The predicates to include in the rate-based rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchPredicates(Collection<AwsWafRegionalRateBasedRuleMatchPredicate> matchPredicates);

        /**
         * <p>
         * The predicates to include in the rate-based rule.
         * </p>
         * 
         * @param matchPredicates
         *        The predicates to include in the rate-based rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchPredicates(AwsWafRegionalRateBasedRuleMatchPredicate... matchPredicates);

        /**
         * <p>
         * The predicates to include in the rate-based rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRateBasedRuleMatchPredicate.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRateBasedRuleMatchPredicate#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRateBasedRuleMatchPredicate.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #matchPredicates(List<AwsWafRegionalRateBasedRuleMatchPredicate>)}.
         * 
         * @param matchPredicates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRateBasedRuleMatchPredicate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchPredicates(java.util.Collection<AwsWafRegionalRateBasedRuleMatchPredicate>)
         */
        Builder matchPredicates(Consumer<AwsWafRegionalRateBasedRuleMatchPredicate.Builder>... matchPredicates);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String name;

        private String rateKey;

        private Long rateLimit;

        private String ruleId;

        private List<AwsWafRegionalRateBasedRuleMatchPredicate> matchPredicates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRegionalRateBasedRuleDetails model) {
            metricName(model.metricName);
            name(model.name);
            rateKey(model.rateKey);
            rateLimit(model.rateLimit);
            ruleId(model.ruleId);
            matchPredicates(model.matchPredicates);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRateKey() {
            return rateKey;
        }

        public final void setRateKey(String rateKey) {
            this.rateKey = rateKey;
        }

        @Override
        public final Builder rateKey(String rateKey) {
            this.rateKey = rateKey;
            return this;
        }

        public final Long getRateLimit() {
            return rateLimit;
        }

        public final void setRateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public final Builder rateLimit(Long rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final List<AwsWafRegionalRateBasedRuleMatchPredicate.Builder> getMatchPredicates() {
            List<AwsWafRegionalRateBasedRuleMatchPredicate.Builder> result = AwsWafRegionalRateBasedRuleMatchPredicateListCopier
                    .copyToBuilder(this.matchPredicates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchPredicates(Collection<AwsWafRegionalRateBasedRuleMatchPredicate.BuilderImpl> matchPredicates) {
            this.matchPredicates = AwsWafRegionalRateBasedRuleMatchPredicateListCopier.copyFromBuilder(matchPredicates);
        }

        @Override
        public final Builder matchPredicates(Collection<AwsWafRegionalRateBasedRuleMatchPredicate> matchPredicates) {
            this.matchPredicates = AwsWafRegionalRateBasedRuleMatchPredicateListCopier.copy(matchPredicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPredicates(AwsWafRegionalRateBasedRuleMatchPredicate... matchPredicates) {
            matchPredicates(Arrays.asList(matchPredicates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPredicates(Consumer<AwsWafRegionalRateBasedRuleMatchPredicate.Builder>... matchPredicates) {
            matchPredicates(Stream.of(matchPredicates)
                    .map(c -> AwsWafRegionalRateBasedRuleMatchPredicate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsWafRegionalRateBasedRuleDetails build() {
            return new AwsWafRegionalRateBasedRuleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
