/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule for redirecting requests to the website.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketWebsiteConfigurationRoutingRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketWebsiteConfigurationRoutingRule.Builder, AwsS3BucketWebsiteConfigurationRoutingRule> {
    private static final SdkField<AwsS3BucketWebsiteConfigurationRoutingRuleCondition> CONDITION_FIELD = SdkField
            .<AwsS3BucketWebsiteConfigurationRoutingRuleCondition> builder(MarshallingType.SDK_POJO).memberName("Condition")
            .getter(getter(AwsS3BucketWebsiteConfigurationRoutingRule::condition)).setter(setter(Builder::condition))
            .constructor(AwsS3BucketWebsiteConfigurationRoutingRuleCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<AwsS3BucketWebsiteConfigurationRoutingRuleRedirect> REDIRECT_FIELD = SdkField
            .<AwsS3BucketWebsiteConfigurationRoutingRuleRedirect> builder(MarshallingType.SDK_POJO).memberName("Redirect")
            .getter(getter(AwsS3BucketWebsiteConfigurationRoutingRule::redirect)).setter(setter(Builder::redirect))
            .constructor(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redirect").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD,
            REDIRECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsS3BucketWebsiteConfigurationRoutingRuleCondition condition;

    private final AwsS3BucketWebsiteConfigurationRoutingRuleRedirect redirect;

    private AwsS3BucketWebsiteConfigurationRoutingRule(BuilderImpl builder) {
        this.condition = builder.condition;
        this.redirect = builder.redirect;
    }

    /**
     * <p>
     * Provides the condition that must be met in order to apply the routing rule.
     * </p>
     * 
     * @return Provides the condition that must be met in order to apply the routing rule.
     */
    public final AwsS3BucketWebsiteConfigurationRoutingRuleCondition condition() {
        return condition;
    }

    /**
     * <p>
     * Provides the rules to redirect the request if the condition in <code>Condition</code> is met.
     * </p>
     * 
     * @return Provides the rules to redirect the request if the condition in <code>Condition</code> is met.
     */
    public final AwsS3BucketWebsiteConfigurationRoutingRuleRedirect redirect() {
        return redirect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(redirect());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketWebsiteConfigurationRoutingRule)) {
            return false;
        }
        AwsS3BucketWebsiteConfigurationRoutingRule other = (AwsS3BucketWebsiteConfigurationRoutingRule) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(redirect(), other.redirect());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketWebsiteConfigurationRoutingRule").add("Condition", condition())
                .add("Redirect", redirect()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "Redirect":
            return Optional.ofNullable(clazz.cast(redirect()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketWebsiteConfigurationRoutingRule, T> g) {
        return obj -> g.apply((AwsS3BucketWebsiteConfigurationRoutingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketWebsiteConfigurationRoutingRule> {
        /**
         * <p>
         * Provides the condition that must be met in order to apply the routing rule.
         * </p>
         * 
         * @param condition
         *        Provides the condition that must be met in order to apply the routing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(AwsS3BucketWebsiteConfigurationRoutingRuleCondition condition);

        /**
         * <p>
         * Provides the condition that must be met in order to apply the routing rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketWebsiteConfigurationRoutingRuleCondition.Builder} avoiding the need to create one manually
         * via {@link AwsS3BucketWebsiteConfigurationRoutingRuleCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsS3BucketWebsiteConfigurationRoutingRuleCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #condition(AwsS3BucketWebsiteConfigurationRoutingRuleCondition)}.
         * 
         * @param condition
         *        a consumer that will call methods on
         *        {@link AwsS3BucketWebsiteConfigurationRoutingRuleCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(AwsS3BucketWebsiteConfigurationRoutingRuleCondition)
         */
        default Builder condition(Consumer<AwsS3BucketWebsiteConfigurationRoutingRuleCondition.Builder> condition) {
            return condition(AwsS3BucketWebsiteConfigurationRoutingRuleCondition.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * Provides the rules to redirect the request if the condition in <code>Condition</code> is met.
         * </p>
         * 
         * @param redirect
         *        Provides the rules to redirect the request if the condition in <code>Condition</code> is met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirect(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect redirect);

        /**
         * <p>
         * Provides the rules to redirect the request if the condition in <code>Condition</code> is met.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.Builder} avoiding the need to create one manually
         * via {@link AwsS3BucketWebsiteConfigurationRoutingRuleRedirect#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.Builder#build()} is called immediately and its
         * result is passed to {@link #redirect(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect)}.
         * 
         * @param redirect
         *        a consumer that will call methods on
         *        {@link AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redirect(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect)
         */
        default Builder redirect(Consumer<AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.Builder> redirect) {
            return redirect(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.builder().applyMutation(redirect).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsS3BucketWebsiteConfigurationRoutingRuleCondition condition;

        private AwsS3BucketWebsiteConfigurationRoutingRuleRedirect redirect;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketWebsiteConfigurationRoutingRule model) {
            condition(model.condition);
            redirect(model.redirect);
        }

        public final AwsS3BucketWebsiteConfigurationRoutingRuleCondition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(AwsS3BucketWebsiteConfigurationRoutingRuleCondition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(AwsS3BucketWebsiteConfigurationRoutingRuleCondition condition) {
            this.condition = condition;
            return this;
        }

        public final AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.Builder getRedirect() {
            return redirect != null ? redirect.toBuilder() : null;
        }

        public final void setRedirect(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect.BuilderImpl redirect) {
            this.redirect = redirect != null ? redirect.build() : null;
        }

        @Override
        public final Builder redirect(AwsS3BucketWebsiteConfigurationRoutingRuleRedirect redirect) {
            this.redirect = redirect;
            return this;
        }

        @Override
        public AwsS3BucketWebsiteConfigurationRoutingRule build() {
            return new AwsS3BucketWebsiteConfigurationRoutingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
