/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon Redshift cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterDetails.Builder, AwsRedshiftClusterDetails> {
    private static final SdkField<Boolean> ALLOW_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowVersionUpgrade").getter(getter(AwsRedshiftClusterDetails::allowVersionUpgrade))
            .setter(setter(Builder::allowVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomatedSnapshotRetentionPeriod")
            .getter(getter(AwsRedshiftClusterDetails::automatedSnapshotRetentionPeriod))
            .setter(setter(Builder::automatedSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(AwsRedshiftClusterDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> CLUSTER_AVAILABILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterAvailabilityStatus").getter(getter(AwsRedshiftClusterDetails::clusterAvailabilityStatus))
            .setter(setter(Builder::clusterAvailabilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterAvailabilityStatus").build())
            .build();

    private static final SdkField<String> CLUSTER_CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterCreateTime").getter(getter(AwsRedshiftClusterDetails::clusterCreateTime))
            .setter(setter(Builder::clusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(AwsRedshiftClusterDetails::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<List<AwsRedshiftClusterClusterNode>> CLUSTER_NODES_FIELD = SdkField
            .<List<AwsRedshiftClusterClusterNode>> builder(MarshallingType.LIST)
            .memberName("ClusterNodes")
            .getter(getter(AwsRedshiftClusterDetails::clusterNodes))
            .setter(setter(Builder::clusterNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRedshiftClusterClusterNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRedshiftClusterClusterNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsRedshiftClusterClusterParameterGroup>> CLUSTER_PARAMETER_GROUPS_FIELD = SdkField
            .<List<AwsRedshiftClusterClusterParameterGroup>> builder(MarshallingType.LIST)
            .memberName("ClusterParameterGroups")
            .getter(getter(AwsRedshiftClusterDetails::clusterParameterGroups))
            .setter(setter(Builder::clusterParameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRedshiftClusterClusterParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRedshiftClusterClusterParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterPublicKey").getter(getter(AwsRedshiftClusterDetails::clusterPublicKey))
            .setter(setter(Builder::clusterPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterPublicKey").build()).build();

    private static final SdkField<String> CLUSTER_REVISION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterRevisionNumber").getter(getter(AwsRedshiftClusterDetails::clusterRevisionNumber))
            .setter(setter(Builder::clusterRevisionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterRevisionNumber").build())
            .build();

    private static final SdkField<List<AwsRedshiftClusterClusterSecurityGroup>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField
            .<List<AwsRedshiftClusterClusterSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("ClusterSecurityGroups")
            .getter(getter(AwsRedshiftClusterDetails::clusterSecurityGroups))
            .setter(setter(Builder::clusterSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRedshiftClusterClusterSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRedshiftClusterClusterSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsRedshiftClusterClusterSnapshotCopyStatus> CLUSTER_SNAPSHOT_COPY_STATUS_FIELD = SdkField
            .<AwsRedshiftClusterClusterSnapshotCopyStatus> builder(MarshallingType.SDK_POJO)
            .memberName("ClusterSnapshotCopyStatus").getter(getter(AwsRedshiftClusterDetails::clusterSnapshotCopyStatus))
            .setter(setter(Builder::clusterSnapshotCopyStatus)).constructor(AwsRedshiftClusterClusterSnapshotCopyStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSnapshotCopyStatus").build())
            .build();

    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterStatus").getter(getter(AwsRedshiftClusterDetails::clusterStatus))
            .setter(setter(Builder::clusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()).build();

    private static final SdkField<String> CLUSTER_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSubnetGroupName").getter(getter(AwsRedshiftClusterDetails::clusterSubnetGroupName))
            .setter(setter(Builder::clusterSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroupName").build())
            .build();

    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterVersion").getter(getter(AwsRedshiftClusterDetails::clusterVersion))
            .setter(setter(Builder::clusterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DBName")
            .getter(getter(AwsRedshiftClusterDetails::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<List<AwsRedshiftClusterDeferredMaintenanceWindow>> DEFERRED_MAINTENANCE_WINDOWS_FIELD = SdkField
            .<List<AwsRedshiftClusterDeferredMaintenanceWindow>> builder(MarshallingType.LIST)
            .memberName("DeferredMaintenanceWindows")
            .getter(getter(AwsRedshiftClusterDetails::deferredMaintenanceWindows))
            .setter(setter(Builder::deferredMaintenanceWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferredMaintenanceWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRedshiftClusterDeferredMaintenanceWindow> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRedshiftClusterDeferredMaintenanceWindow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsRedshiftClusterElasticIpStatus> ELASTIC_IP_STATUS_FIELD = SdkField
            .<AwsRedshiftClusterElasticIpStatus> builder(MarshallingType.SDK_POJO).memberName("ElasticIpStatus")
            .getter(getter(AwsRedshiftClusterDetails::elasticIpStatus)).setter(setter(Builder::elasticIpStatus))
            .constructor(AwsRedshiftClusterElasticIpStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIpStatus").build()).build();

    private static final SdkField<String> ELASTIC_RESIZE_NUMBER_OF_NODE_OPTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ElasticResizeNumberOfNodeOptions")
            .getter(getter(AwsRedshiftClusterDetails::elasticResizeNumberOfNodeOptions))
            .setter(setter(Builder::elasticResizeNumberOfNodeOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticResizeNumberOfNodeOptions")
                    .build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(AwsRedshiftClusterDetails::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<AwsRedshiftClusterEndpoint> ENDPOINT_FIELD = SdkField
            .<AwsRedshiftClusterEndpoint> builder(MarshallingType.SDK_POJO).memberName("Endpoint")
            .getter(getter(AwsRedshiftClusterDetails::endpoint)).setter(setter(Builder::endpoint))
            .constructor(AwsRedshiftClusterEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnhancedVpcRouting").getter(getter(AwsRedshiftClusterDetails::enhancedVpcRouting))
            .setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build())
            .build();

    private static final SdkField<String> EXPECTED_NEXT_SNAPSHOT_SCHEDULE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExpectedNextSnapshotScheduleTime")
            .getter(getter(AwsRedshiftClusterDetails::expectedNextSnapshotScheduleTime))
            .setter(setter(Builder::expectedNextSnapshotScheduleTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedNextSnapshotScheduleTime")
                    .build()).build();

    private static final SdkField<String> EXPECTED_NEXT_SNAPSHOT_SCHEDULE_TIME_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExpectedNextSnapshotScheduleTimeStatus")
            .getter(getter(AwsRedshiftClusterDetails::expectedNextSnapshotScheduleTimeStatus))
            .setter(setter(Builder::expectedNextSnapshotScheduleTimeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ExpectedNextSnapshotScheduleTimeStatus").build()).build();

    private static final SdkField<AwsRedshiftClusterHsmStatus> HSM_STATUS_FIELD = SdkField
            .<AwsRedshiftClusterHsmStatus> builder(MarshallingType.SDK_POJO).memberName("HsmStatus")
            .getter(getter(AwsRedshiftClusterDetails::hsmStatus)).setter(setter(Builder::hsmStatus))
            .constructor(AwsRedshiftClusterHsmStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmStatus").build()).build();

    private static final SdkField<List<AwsRedshiftClusterIamRole>> IAM_ROLES_FIELD = SdkField
            .<List<AwsRedshiftClusterIamRole>> builder(MarshallingType.LIST)
            .memberName("IamRoles")
            .getter(getter(AwsRedshiftClusterDetails::iamRoles))
            .setter(setter(Builder::iamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRedshiftClusterIamRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRedshiftClusterIamRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsRedshiftClusterDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceTrackName").getter(getter(AwsRedshiftClusterDetails::maintenanceTrackName))
            .setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManualSnapshotRetentionPeriod")
            .getter(getter(AwsRedshiftClusterDetails::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(AwsRedshiftClusterDetails::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> NEXT_MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMaintenanceWindowStartTime")
            .getter(getter(AwsRedshiftClusterDetails::nextMaintenanceWindowStartTime))
            .setter(setter(Builder::nextMaintenanceWindowStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMaintenanceWindowStartTime")
                    .build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(AwsRedshiftClusterDetails::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(AwsRedshiftClusterDetails::numberOfNodes))
            .setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<List<String>> PENDING_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PendingActions")
            .getter(getter(AwsRedshiftClusterDetails::pendingActions))
            .setter(setter(Builder::pendingActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsRedshiftClusterPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<AwsRedshiftClusterPendingModifiedValues> builder(MarshallingType.SDK_POJO).memberName("PendingModifiedValues")
            .getter(getter(AwsRedshiftClusterDetails::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(AwsRedshiftClusterPendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(AwsRedshiftClusterDetails::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(AwsRedshiftClusterDetails::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<AwsRedshiftClusterResizeInfo> RESIZE_INFO_FIELD = SdkField
            .<AwsRedshiftClusterResizeInfo> builder(MarshallingType.SDK_POJO).memberName("ResizeInfo")
            .getter(getter(AwsRedshiftClusterDetails::resizeInfo)).setter(setter(Builder::resizeInfo))
            .constructor(AwsRedshiftClusterResizeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeInfo").build()).build();

    private static final SdkField<AwsRedshiftClusterRestoreStatus> RESTORE_STATUS_FIELD = SdkField
            .<AwsRedshiftClusterRestoreStatus> builder(MarshallingType.SDK_POJO).memberName("RestoreStatus")
            .getter(getter(AwsRedshiftClusterDetails::restoreStatus)).setter(setter(Builder::restoreStatus))
            .constructor(AwsRedshiftClusterRestoreStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreStatus").build()).build();

    private static final SdkField<String> SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotScheduleIdentifier")
            .getter(getter(AwsRedshiftClusterDetails::snapshotScheduleIdentifier))
            .setter(setter(Builder::snapshotScheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_SCHEDULE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotScheduleState").getter(getter(AwsRedshiftClusterDetails::snapshotScheduleState))
            .setter(setter(Builder::snapshotScheduleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleState").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsRedshiftClusterDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<AwsRedshiftClusterVpcSecurityGroup>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<AwsRedshiftClusterVpcSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(AwsRedshiftClusterDetails::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRedshiftClusterVpcSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRedshiftClusterVpcSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsRedshiftClusterLoggingStatus> LOGGING_STATUS_FIELD = SdkField
            .<AwsRedshiftClusterLoggingStatus> builder(MarshallingType.SDK_POJO).memberName("LoggingStatus")
            .getter(getter(AwsRedshiftClusterDetails::loggingStatus)).setter(setter(Builder::loggingStatus))
            .constructor(AwsRedshiftClusterLoggingStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_VERSION_UPGRADE_FIELD,
            AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD, AVAILABILITY_ZONE_FIELD, CLUSTER_AVAILABILITY_STATUS_FIELD,
            CLUSTER_CREATE_TIME_FIELD, CLUSTER_IDENTIFIER_FIELD, CLUSTER_NODES_FIELD, CLUSTER_PARAMETER_GROUPS_FIELD,
            CLUSTER_PUBLIC_KEY_FIELD, CLUSTER_REVISION_NUMBER_FIELD, CLUSTER_SECURITY_GROUPS_FIELD,
            CLUSTER_SNAPSHOT_COPY_STATUS_FIELD, CLUSTER_STATUS_FIELD, CLUSTER_SUBNET_GROUP_NAME_FIELD, CLUSTER_VERSION_FIELD,
            DB_NAME_FIELD, DEFERRED_MAINTENANCE_WINDOWS_FIELD, ELASTIC_IP_STATUS_FIELD,
            ELASTIC_RESIZE_NUMBER_OF_NODE_OPTIONS_FIELD, ENCRYPTED_FIELD, ENDPOINT_FIELD, ENHANCED_VPC_ROUTING_FIELD,
            EXPECTED_NEXT_SNAPSHOT_SCHEDULE_TIME_FIELD, EXPECTED_NEXT_SNAPSHOT_SCHEDULE_TIME_STATUS_FIELD, HSM_STATUS_FIELD,
            IAM_ROLES_FIELD, KMS_KEY_ID_FIELD, MAINTENANCE_TRACK_NAME_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD,
            MASTER_USERNAME_FIELD, NEXT_MAINTENANCE_WINDOW_START_TIME_FIELD, NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD,
            PENDING_ACTIONS_FIELD, PENDING_MODIFIED_VALUES_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            RESIZE_INFO_FIELD, RESTORE_STATUS_FIELD, SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD, SNAPSHOT_SCHEDULE_STATE_FIELD,
            VPC_ID_FIELD, VPC_SECURITY_GROUPS_FIELD, LOGGING_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowVersionUpgrade;

    private final Integer automatedSnapshotRetentionPeriod;

    private final String availabilityZone;

    private final String clusterAvailabilityStatus;

    private final String clusterCreateTime;

    private final String clusterIdentifier;

    private final List<AwsRedshiftClusterClusterNode> clusterNodes;

    private final List<AwsRedshiftClusterClusterParameterGroup> clusterParameterGroups;

    private final String clusterPublicKey;

    private final String clusterRevisionNumber;

    private final List<AwsRedshiftClusterClusterSecurityGroup> clusterSecurityGroups;

    private final AwsRedshiftClusterClusterSnapshotCopyStatus clusterSnapshotCopyStatus;

    private final String clusterStatus;

    private final String clusterSubnetGroupName;

    private final String clusterVersion;

    private final String dbName;

    private final List<AwsRedshiftClusterDeferredMaintenanceWindow> deferredMaintenanceWindows;

    private final AwsRedshiftClusterElasticIpStatus elasticIpStatus;

    private final String elasticResizeNumberOfNodeOptions;

    private final Boolean encrypted;

    private final AwsRedshiftClusterEndpoint endpoint;

    private final Boolean enhancedVpcRouting;

    private final String expectedNextSnapshotScheduleTime;

    private final String expectedNextSnapshotScheduleTimeStatus;

    private final AwsRedshiftClusterHsmStatus hsmStatus;

    private final List<AwsRedshiftClusterIamRole> iamRoles;

    private final String kmsKeyId;

    private final String maintenanceTrackName;

    private final Integer manualSnapshotRetentionPeriod;

    private final String masterUsername;

    private final String nextMaintenanceWindowStartTime;

    private final String nodeType;

    private final Integer numberOfNodes;

    private final List<String> pendingActions;

    private final AwsRedshiftClusterPendingModifiedValues pendingModifiedValues;

    private final String preferredMaintenanceWindow;

    private final Boolean publiclyAccessible;

    private final AwsRedshiftClusterResizeInfo resizeInfo;

    private final AwsRedshiftClusterRestoreStatus restoreStatus;

    private final String snapshotScheduleIdentifier;

    private final String snapshotScheduleState;

    private final String vpcId;

    private final List<AwsRedshiftClusterVpcSecurityGroup> vpcSecurityGroups;

    private final AwsRedshiftClusterLoggingStatus loggingStatus;

    private AwsRedshiftClusterDetails(BuilderImpl builder) {
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.availabilityZone = builder.availabilityZone;
        this.clusterAvailabilityStatus = builder.clusterAvailabilityStatus;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterNodes = builder.clusterNodes;
        this.clusterParameterGroups = builder.clusterParameterGroups;
        this.clusterPublicKey = builder.clusterPublicKey;
        this.clusterRevisionNumber = builder.clusterRevisionNumber;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.clusterSnapshotCopyStatus = builder.clusterSnapshotCopyStatus;
        this.clusterStatus = builder.clusterStatus;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.clusterVersion = builder.clusterVersion;
        this.dbName = builder.dbName;
        this.deferredMaintenanceWindows = builder.deferredMaintenanceWindows;
        this.elasticIpStatus = builder.elasticIpStatus;
        this.elasticResizeNumberOfNodeOptions = builder.elasticResizeNumberOfNodeOptions;
        this.encrypted = builder.encrypted;
        this.endpoint = builder.endpoint;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.expectedNextSnapshotScheduleTime = builder.expectedNextSnapshotScheduleTime;
        this.expectedNextSnapshotScheduleTimeStatus = builder.expectedNextSnapshotScheduleTimeStatus;
        this.hsmStatus = builder.hsmStatus;
        this.iamRoles = builder.iamRoles;
        this.kmsKeyId = builder.kmsKeyId;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.masterUsername = builder.masterUsername;
        this.nextMaintenanceWindowStartTime = builder.nextMaintenanceWindowStartTime;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.pendingActions = builder.pendingActions;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.resizeInfo = builder.resizeInfo;
        this.restoreStatus = builder.restoreStatus;
        this.snapshotScheduleIdentifier = builder.snapshotScheduleIdentifier;
        this.snapshotScheduleState = builder.snapshotScheduleState;
        this.vpcId = builder.vpcId;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.loggingStatus = builder.loggingStatus;
    }

    /**
     * <p>
     * Indicates whether major version upgrades are applied automatically to the cluster during the maintenance window.
     * </p>
     * 
     * @return Indicates whether major version upgrades are applied automatically to the cluster during the maintenance
     *         window.
     */
    public final Boolean allowVersionUpgrade() {
        return allowVersionUpgrade;
    }

    /**
     * <p>
     * The number of days that automatic cluster snapshots are retained.
     * </p>
     * 
     * @return The number of days that automatic cluster snapshots are retained.
     */
    public final Integer automatedSnapshotRetentionPeriod() {
        return automatedSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The name of the Availability Zone in which the cluster is located.
     * </p>
     * 
     * @return The name of the Availability Zone in which the cluster is located.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The availability status of the cluster for queries. Possible values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Available</code> - The cluster is available for queries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unavailable</code> - The cluster is not available for queries.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Maintenance</code> - The cluster is intermittently available for queries due to maintenance activities.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Modifying</code> -The cluster is intermittently available for queries due to changes that modify the
     * cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The cluster failed and is not available for queries.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The availability status of the cluster for queries. Possible values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Available</code> - The cluster is available for queries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unavailable</code> - The cluster is not available for queries.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Maintenance</code> - The cluster is intermittently available for queries due to maintenance
     *         activities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Modifying</code> -The cluster is intermittently available for queries due to changes that modify
     *         the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The cluster failed and is not available for queries.
     *         </p>
     *         </li>
     */
    public final String clusterAvailabilityStatus() {
        return clusterAvailabilityStatus;
    }

    /**
     * <p>
     * Indicates when the cluster was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the cluster was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String clusterCreateTime() {
        return clusterCreateTime;
    }

    /**
     * <p>
     * The unique identifier of the cluster.
     * </p>
     * 
     * @return The unique identifier of the cluster.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterNodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterNodes() {
        return clusterNodes != null && !(clusterNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nodes in the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterNodes} method.
     * </p>
     * 
     * @return The nodes in the cluster.
     */
    public final List<AwsRedshiftClusterClusterNode> clusterNodes() {
        return clusterNodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterParameterGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClusterParameterGroups() {
        return clusterParameterGroups != null && !(clusterParameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of cluster parameter groups that are associated with this cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterParameterGroups} method.
     * </p>
     * 
     * @return The list of cluster parameter groups that are associated with this cluster.
     */
    public final List<AwsRedshiftClusterClusterParameterGroup> clusterParameterGroups() {
        return clusterParameterGroups;
    }

    /**
     * <p>
     * The public key for the cluster.
     * </p>
     * 
     * @return The public key for the cluster.
     */
    public final String clusterPublicKey() {
        return clusterPublicKey;
    }

    /**
     * <p>
     * The specific revision number of the database in the cluster.
     * </p>
     * 
     * @return The specific revision number of the database in the cluster.
     */
    public final String clusterRevisionNumber() {
        return clusterRevisionNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterSecurityGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClusterSecurityGroups() {
        return clusterSecurityGroups != null && !(clusterSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cluster security groups that are associated with the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterSecurityGroups} method.
     * </p>
     * 
     * @return A list of cluster security groups that are associated with the cluster.
     */
    public final List<AwsRedshiftClusterClusterSecurityGroup> clusterSecurityGroups() {
        return clusterSecurityGroups;
    }

    /**
     * <p>
     * Information about the destination Region and retention period for the cross-Region snapshot copy.
     * </p>
     * 
     * @return Information about the destination Region and retention period for the cross-Region snapshot copy.
     */
    public final AwsRedshiftClusterClusterSnapshotCopyStatus clusterSnapshotCopyStatus() {
        return clusterSnapshotCopyStatus;
    }

    /**
     * <p>
     * The current status of the cluster.
     * </p>
     * <p>
     * Valid values: <code>available</code> | <code>available, prep-for-resize</code> |
     * <code>available, resize-cleanup</code> |<code> cancelling-resize</code> | <code>creating</code> |
     * <code>deleting</code> | <code>final-snapshot</code> | <code>hardware-failure</code> |
     * <code>incompatible-hsm</code> |<code> incompatible-network</code> | <code>incompatible-parameters</code> |
     * <code>incompatible-restore</code> | <code>modifying</code> | <code>paused</code> | <code>rebooting</code> |
     * <code>renaming</code> | <code>resizing</code> | <code>rotating-keys</code> | <code>storage-full</code> |
     * <code>updating-hsm</code>
     * </p>
     * 
     * @return The current status of the cluster.</p>
     *         <p>
     *         Valid values: <code>available</code> | <code>available, prep-for-resize</code> |
     *         <code>available, resize-cleanup</code> |<code> cancelling-resize</code> | <code>creating</code> |
     *         <code>deleting</code> | <code>final-snapshot</code> | <code>hardware-failure</code> |
     *         <code>incompatible-hsm</code> |<code> incompatible-network</code> | <code>incompatible-parameters</code>
     *         | <code>incompatible-restore</code> | <code>modifying</code> | <code>paused</code> |
     *         <code>rebooting</code> | <code>renaming</code> | <code>resizing</code> | <code>rotating-keys</code> |
     *         <code>storage-full</code> | <code>updating-hsm</code>
     */
    public final String clusterStatus() {
        return clusterStatus;
    }

    /**
     * <p>
     * The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster
     * is in a VPC.
     * </p>
     * 
     * @return The name of the subnet group that is associated with the cluster. This parameter is valid only when the
     *         cluster is in a VPC.
     */
    public final String clusterSubnetGroupName() {
        return clusterSubnetGroupName;
    }

    /**
     * <p>
     * The version ID of the Amazon Redshift engine that runs on the cluster.
     * </p>
     * 
     * @return The version ID of the Amazon Redshift engine that runs on the cluster.
     */
    public final String clusterVersion() {
        return clusterVersion;
    }

    /**
     * <p>
     * The name of the initial database that was created when the cluster was created.
     * </p>
     * <p>
     * The same name is returned for the life of the cluster.
     * </p>
     * <p>
     * If an initial database is not specified, a database named <code>devdev</code> is created by default.
     * </p>
     * 
     * @return The name of the initial database that was created when the cluster was created.</p>
     *         <p>
     *         The same name is returned for the life of the cluster.
     *         </p>
     *         <p>
     *         If an initial database is not specified, a database named <code>devdev</code> is created by default.
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeferredMaintenanceWindows property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeferredMaintenanceWindows() {
        return deferredMaintenanceWindows != null && !(deferredMaintenanceWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of time windows during which maintenance was deferred.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeferredMaintenanceWindows} method.
     * </p>
     * 
     * @return List of time windows during which maintenance was deferred.
     */
    public final List<AwsRedshiftClusterDeferredMaintenanceWindow> deferredMaintenanceWindows() {
        return deferredMaintenanceWindows;
    }

    /**
     * <p>
     * Information about the status of the Elastic IP (EIP) address.
     * </p>
     * 
     * @return Information about the status of the Elastic IP (EIP) address.
     */
    public final AwsRedshiftClusterElasticIpStatus elasticIpStatus() {
        return elasticIpStatus;
    }

    /**
     * <p>
     * The number of nodes that you can use the elastic resize method to resize the cluster to.
     * </p>
     * 
     * @return The number of nodes that you can use the elastic resize method to resize the cluster to.
     */
    public final String elasticResizeNumberOfNodeOptions() {
        return elasticResizeNumberOfNodeOptions;
    }

    /**
     * <p>
     * Indicates whether the data in the cluster is encrypted at rest.
     * </p>
     * 
     * @return Indicates whether the data in the cluster is encrypted at rest.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The connection endpoint.
     * </p>
     * 
     * @return The connection endpoint.
     */
    public final AwsRedshiftClusterEndpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Indicates whether to create the cluster with enhanced VPC routing enabled.
     * </p>
     * 
     * @return Indicates whether to create the cluster with enhanced VPC routing enabled.
     */
    public final Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * Indicates when the next snapshot is expected to be taken. The cluster must have a valid snapshot schedule and
     * have backups enabled.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the next snapshot is expected to be taken. The cluster must have a valid snapshot schedule
     *         and have backups enabled.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String expectedNextSnapshotScheduleTime() {
        return expectedNextSnapshotScheduleTime;
    }

    /**
     * <p>
     * The status of the next expected snapshot.
     * </p>
     * <p>
     * Valid values: <code>OnTrack</code> | <code>Pending</code>
     * </p>
     * 
     * @return The status of the next expected snapshot.</p>
     *         <p>
     *         Valid values: <code>OnTrack</code> | <code>Pending</code>
     */
    public final String expectedNextSnapshotScheduleTimeStatus() {
        return expectedNextSnapshotScheduleTimeStatus;
    }

    /**
     * <p>
     * Information about whether the Amazon Redshift cluster finished applying any changes to hardware security module
     * (HSM) settings that were specified in a modify cluster command.
     * </p>
     * 
     * @return Information about whether the Amazon Redshift cluster finished applying any changes to hardware security
     *         module (HSM) settings that were specified in a modify cluster command.
     */
    public final AwsRedshiftClusterHsmStatus hsmStatus() {
        return hsmStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the IamRoles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIamRoles() {
        return iamRoles != null && !(iamRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM roles that the cluster can use to access other Amazon Web Services services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIamRoles} method.
     * </p>
     * 
     * @return A list of IAM roles that the cluster can use to access other Amazon Web Services services.
     */
    public final List<AwsRedshiftClusterIamRole> iamRoles() {
        return iamRoles;
    }

    /**
     * <p>
     * The identifier of the KMS encryption key that is used to encrypt data in the cluster.
     * </p>
     * 
     * @return The identifier of the KMS encryption key that is used to encrypt data in the cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The name of the maintenance track for the cluster.
     * </p>
     * 
     * @return The name of the maintenance track for the cluster.
     */
    public final String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * The default number of days to retain a manual snapshot.
     * </p>
     * <p>
     * If the value is <code>-1</code>, the snapshot is retained indefinitely.
     * </p>
     * <p>
     * This setting doesn't change the retention period of existing snapshots.
     * </p>
     * <p>
     * Valid values: Either <code>-1</code> or an integer between 1 and 3,653
     * </p>
     * 
     * @return The default number of days to retain a manual snapshot.</p>
     *         <p>
     *         If the value is <code>-1</code>, the snapshot is retained indefinitely.
     *         </p>
     *         <p>
     *         This setting doesn't change the retention period of existing snapshots.
     *         </p>
     *         <p>
     *         Valid values: Either <code>-1</code> or an integer between 1 and 3,653
     */
    public final Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The master user name for the cluster. This name is used to connect to the database that is specified in as the
     * value of <code>DBName</code>.
     * </p>
     * 
     * @return The master user name for the cluster. This name is used to connect to the database that is specified in
     *         as the value of <code>DBName</code>.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * Indicates the start of the next maintenance window.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces, and date and time should be
     * separated by <code>T</code>. For example, <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates the start of the next maintenance window.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>. For
     *         example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String nextMaintenanceWindowStartTime() {
        return nextMaintenanceWindowStartTime;
    }

    /**
     * <p>
     * The node type for the nodes in the cluster.
     * </p>
     * 
     * @return The node type for the nodes in the cluster.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The number of compute nodes in the cluster.
     * </p>
     * 
     * @return The number of compute nodes in the cluster.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the PendingActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPendingActions() {
        return pendingActions != null && !(pendingActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cluster operations that are waiting to start.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPendingActions} method.
     * </p>
     * 
     * @return A list of cluster operations that are waiting to start.
     */
    public final List<String> pendingActions() {
        return pendingActions;
    }

    /**
     * <p>
     * A list of changes to the cluster that are currently pending.
     * </p>
     * 
     * @return A list of changes to the cluster that are currently pending.
     */
    public final AwsRedshiftClusterPendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * <p>
     * The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
     * </p>
     * <p>
     * Format: <code> <i>&lt;day&gt;</i>:HH:MM-<i>&lt;day&gt;</i>:HH:MM</code>
     * </p>
     * <p>
     * For the day values, use <code>mon</code> | <code>tue</code> | <code>wed</code> | <code>thu</code> |
     * <code>fri</code> | <code>sat</code> | <code>sun</code>
     * </p>
     * <p>
     * For example, <code>sun:09:32-sun:10:02</code>
     * </p>
     * 
     * @return The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can
     *         occur.</p>
     *         <p>
     *         Format: <code> <i>&lt;day&gt;</i>:HH:MM-<i>&lt;day&gt;</i>:HH:MM</code>
     *         </p>
     *         <p>
     *         For the day values, use <code>mon</code> | <code>tue</code> | <code>wed</code> | <code>thu</code> |
     *         <code>fri</code> | <code>sat</code> | <code>sun</code>
     *         </p>
     *         <p>
     *         For example, <code>sun:09:32-sun:10:02</code>
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Whether the cluster can be accessed from a public network.
     * </p>
     * 
     * @return Whether the cluster can be accessed from a public network.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * Information about the resize operation for the cluster.
     * </p>
     * 
     * @return Information about the resize operation for the cluster.
     */
    public final AwsRedshiftClusterResizeInfo resizeInfo() {
        return resizeInfo;
    }

    /**
     * <p>
     * Information about the status of a cluster restore action. Only applies to a cluster that was created by restoring
     * a snapshot.
     * </p>
     * 
     * @return Information about the status of a cluster restore action. Only applies to a cluster that was created by
     *         restoring a snapshot.
     */
    public final AwsRedshiftClusterRestoreStatus restoreStatus() {
        return restoreStatus;
    }

    /**
     * <p>
     * A unique identifier for the cluster snapshot schedule.
     * </p>
     * 
     * @return A unique identifier for the cluster snapshot schedule.
     */
    public final String snapshotScheduleIdentifier() {
        return snapshotScheduleIdentifier;
    }

    /**
     * <p>
     * The current state of the cluster snapshot schedule.
     * </p>
     * <p>
     * Valid values: <code>MODIFYING</code> | <code>ACTIVE</code> | <code>FAILED</code>
     * </p>
     * 
     * @return The current state of the cluster snapshot schedule.</p>
     *         <p>
     *         Valid values: <code>MODIFYING</code> | <code>ACTIVE</code> | <code>FAILED</code>
     */
    public final String snapshotScheduleState() {
        return snapshotScheduleState;
    }

    /**
     * <p>
     * The identifier of the VPC that the cluster is in, if the cluster is in a VPC.
     * </p>
     * 
     * @return The identifier of the VPC that the cluster is in, if the cluster is in a VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroups} method.
     * </p>
     * 
     * @return The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
     */
    public final List<AwsRedshiftClusterVpcSecurityGroup> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * <p>
     * Information about the logging status of the cluster.
     * </p>
     * 
     * @return Information about the logging status of the cluster.
     */
    public final AwsRedshiftClusterLoggingStatus loggingStatus() {
        return loggingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(clusterAvailabilityStatus());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterNodes() ? clusterNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterParameterGroups() ? clusterParameterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(clusterRevisionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterSecurityGroups() ? clusterSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterSnapshotCopyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeferredMaintenanceWindows() ? deferredMaintenanceWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(elasticIpStatus());
        hashCode = 31 * hashCode + Objects.hashCode(elasticResizeNumberOfNodeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(expectedNextSnapshotScheduleTime());
        hashCode = 31 * hashCode + Objects.hashCode(expectedNextSnapshotScheduleTimeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hsmStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasIamRoles() ? iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(nextMaintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingActions() ? pendingActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(resizeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(restoreStatus());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotScheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotScheduleState());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(loggingStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterDetails)) {
            return false;
        }
        AwsRedshiftClusterDetails other = (AwsRedshiftClusterDetails) obj;
        return Objects.equals(allowVersionUpgrade(), other.allowVersionUpgrade())
                && Objects.equals(automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(clusterAvailabilityStatus(), other.clusterAvailabilityStatus())
                && Objects.equals(clusterCreateTime(), other.clusterCreateTime())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && hasClusterNodes() == other.hasClusterNodes()
                && Objects.equals(clusterNodes(), other.clusterNodes())
                && hasClusterParameterGroups() == other.hasClusterParameterGroups()
                && Objects.equals(clusterParameterGroups(), other.clusterParameterGroups())
                && Objects.equals(clusterPublicKey(), other.clusterPublicKey())
                && Objects.equals(clusterRevisionNumber(), other.clusterRevisionNumber())
                && hasClusterSecurityGroups() == other.hasClusterSecurityGroups()
                && Objects.equals(clusterSecurityGroups(), other.clusterSecurityGroups())
                && Objects.equals(clusterSnapshotCopyStatus(), other.clusterSnapshotCopyStatus())
                && Objects.equals(clusterStatus(), other.clusterStatus())
                && Objects.equals(clusterSubnetGroupName(), other.clusterSubnetGroupName())
                && Objects.equals(clusterVersion(), other.clusterVersion()) && Objects.equals(dbName(), other.dbName())
                && hasDeferredMaintenanceWindows() == other.hasDeferredMaintenanceWindows()
                && Objects.equals(deferredMaintenanceWindows(), other.deferredMaintenanceWindows())
                && Objects.equals(elasticIpStatus(), other.elasticIpStatus())
                && Objects.equals(elasticResizeNumberOfNodeOptions(), other.elasticResizeNumberOfNodeOptions())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(expectedNextSnapshotScheduleTime(), other.expectedNextSnapshotScheduleTime())
                && Objects.equals(expectedNextSnapshotScheduleTimeStatus(), other.expectedNextSnapshotScheduleTimeStatus())
                && Objects.equals(hsmStatus(), other.hsmStatus()) && hasIamRoles() == other.hasIamRoles()
                && Objects.equals(iamRoles(), other.iamRoles()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(nextMaintenanceWindowStartTime(), other.nextMaintenanceWindowStartTime())
                && Objects.equals(nodeType(), other.nodeType()) && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && hasPendingActions() == other.hasPendingActions() && Objects.equals(pendingActions(), other.pendingActions())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(resizeInfo(), other.resizeInfo()) && Objects.equals(restoreStatus(), other.restoreStatus())
                && Objects.equals(snapshotScheduleIdentifier(), other.snapshotScheduleIdentifier())
                && Objects.equals(snapshotScheduleState(), other.snapshotScheduleState())
                && Objects.equals(vpcId(), other.vpcId()) && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups())
                && Objects.equals(loggingStatus(), other.loggingStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterDetails").add("AllowVersionUpgrade", allowVersionUpgrade())
                .add("AutomatedSnapshotRetentionPeriod", automatedSnapshotRetentionPeriod())
                .add("AvailabilityZone", availabilityZone()).add("ClusterAvailabilityStatus", clusterAvailabilityStatus())
                .add("ClusterCreateTime", clusterCreateTime()).add("ClusterIdentifier", clusterIdentifier())
                .add("ClusterNodes", hasClusterNodes() ? clusterNodes() : null)
                .add("ClusterParameterGroups", hasClusterParameterGroups() ? clusterParameterGroups() : null)
                .add("ClusterPublicKey", clusterPublicKey()).add("ClusterRevisionNumber", clusterRevisionNumber())
                .add("ClusterSecurityGroups", hasClusterSecurityGroups() ? clusterSecurityGroups() : null)
                .add("ClusterSnapshotCopyStatus", clusterSnapshotCopyStatus()).add("ClusterStatus", clusterStatus())
                .add("ClusterSubnetGroupName", clusterSubnetGroupName()).add("ClusterVersion", clusterVersion())
                .add("DBName", dbName())
                .add("DeferredMaintenanceWindows", hasDeferredMaintenanceWindows() ? deferredMaintenanceWindows() : null)
                .add("ElasticIpStatus", elasticIpStatus())
                .add("ElasticResizeNumberOfNodeOptions", elasticResizeNumberOfNodeOptions()).add("Encrypted", encrypted())
                .add("Endpoint", endpoint()).add("EnhancedVpcRouting", enhancedVpcRouting())
                .add("ExpectedNextSnapshotScheduleTime", expectedNextSnapshotScheduleTime())
                .add("ExpectedNextSnapshotScheduleTimeStatus", expectedNextSnapshotScheduleTimeStatus())
                .add("HsmStatus", hsmStatus()).add("IamRoles", hasIamRoles() ? iamRoles() : null).add("KmsKeyId", kmsKeyId())
                .add("MaintenanceTrackName", maintenanceTrackName())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod()).add("MasterUsername", masterUsername())
                .add("NextMaintenanceWindowStartTime", nextMaintenanceWindowStartTime()).add("NodeType", nodeType())
                .add("NumberOfNodes", numberOfNodes()).add("PendingActions", hasPendingActions() ? pendingActions() : null)
                .add("PendingModifiedValues", pendingModifiedValues())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("PubliclyAccessible", publiclyAccessible())
                .add("ResizeInfo", resizeInfo()).add("RestoreStatus", restoreStatus())
                .add("SnapshotScheduleIdentifier", snapshotScheduleIdentifier())
                .add("SnapshotScheduleState", snapshotScheduleState()).add("VpcId", vpcId())
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null)
                .add("LoggingStatus", loggingStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowVersionUpgrade()));
        case "AutomatedSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(automatedSnapshotRetentionPeriod()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ClusterAvailabilityStatus":
            return Optional.ofNullable(clazz.cast(clusterAvailabilityStatus()));
        case "ClusterCreateTime":
            return Optional.ofNullable(clazz.cast(clusterCreateTime()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "ClusterNodes":
            return Optional.ofNullable(clazz.cast(clusterNodes()));
        case "ClusterParameterGroups":
            return Optional.ofNullable(clazz.cast(clusterParameterGroups()));
        case "ClusterPublicKey":
            return Optional.ofNullable(clazz.cast(clusterPublicKey()));
        case "ClusterRevisionNumber":
            return Optional.ofNullable(clazz.cast(clusterRevisionNumber()));
        case "ClusterSecurityGroups":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroups()));
        case "ClusterSnapshotCopyStatus":
            return Optional.ofNullable(clazz.cast(clusterSnapshotCopyStatus()));
        case "ClusterStatus":
            return Optional.ofNullable(clazz.cast(clusterStatus()));
        case "ClusterSubnetGroupName":
            return Optional.ofNullable(clazz.cast(clusterSubnetGroupName()));
        case "ClusterVersion":
            return Optional.ofNullable(clazz.cast(clusterVersion()));
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "DeferredMaintenanceWindows":
            return Optional.ofNullable(clazz.cast(deferredMaintenanceWindows()));
        case "ElasticIpStatus":
            return Optional.ofNullable(clazz.cast(elasticIpStatus()));
        case "ElasticResizeNumberOfNodeOptions":
            return Optional.ofNullable(clazz.cast(elasticResizeNumberOfNodeOptions()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "EnhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "ExpectedNextSnapshotScheduleTime":
            return Optional.ofNullable(clazz.cast(expectedNextSnapshotScheduleTime()));
        case "ExpectedNextSnapshotScheduleTimeStatus":
            return Optional.ofNullable(clazz.cast(expectedNextSnapshotScheduleTimeStatus()));
        case "HsmStatus":
            return Optional.ofNullable(clazz.cast(hsmStatus()));
        case "IamRoles":
            return Optional.ofNullable(clazz.cast(iamRoles()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "NextMaintenanceWindowStartTime":
            return Optional.ofNullable(clazz.cast(nextMaintenanceWindowStartTime()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "PendingActions":
            return Optional.ofNullable(clazz.cast(pendingActions()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "ResizeInfo":
            return Optional.ofNullable(clazz.cast(resizeInfo()));
        case "RestoreStatus":
            return Optional.ofNullable(clazz.cast(restoreStatus()));
        case "SnapshotScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotScheduleIdentifier()));
        case "SnapshotScheduleState":
            return Optional.ofNullable(clazz.cast(snapshotScheduleState()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "LoggingStatus":
            return Optional.ofNullable(clazz.cast(loggingStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterDetails, T> g) {
        return obj -> g.apply((AwsRedshiftClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterDetails> {
        /**
         * <p>
         * Indicates whether major version upgrades are applied automatically to the cluster during the maintenance
         * window.
         * </p>
         * 
         * @param allowVersionUpgrade
         *        Indicates whether major version upgrades are applied automatically to the cluster during the
         *        maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowVersionUpgrade(Boolean allowVersionUpgrade);

        /**
         * <p>
         * The number of days that automatic cluster snapshots are retained.
         * </p>
         * 
         * @param automatedSnapshotRetentionPeriod
         *        The number of days that automatic cluster snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod);

        /**
         * <p>
         * The name of the Availability Zone in which the cluster is located.
         * </p>
         * 
         * @param availabilityZone
         *        The name of the Availability Zone in which the cluster is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The availability status of the cluster for queries. Possible values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Available</code> - The cluster is available for queries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unavailable</code> - The cluster is not available for queries.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Maintenance</code> - The cluster is intermittently available for queries due to maintenance activities.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Modifying</code> -The cluster is intermittently available for queries due to changes that modify the
         * cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The cluster failed and is not available for queries.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterAvailabilityStatus
         *        The availability status of the cluster for queries. Possible values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Available</code> - The cluster is available for queries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unavailable</code> - The cluster is not available for queries.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Maintenance</code> - The cluster is intermittently available for queries due to maintenance
         *        activities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Modifying</code> -The cluster is intermittently available for queries due to changes that modify
         *        the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The cluster failed and is not available for queries.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterAvailabilityStatus(String clusterAvailabilityStatus);

        /**
         * <p>
         * Indicates when the cluster was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param clusterCreateTime
         *        Indicates when the cluster was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreateTime(String clusterCreateTime);

        /**
         * <p>
         * The unique identifier of the cluster.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The nodes in the cluster.
         * </p>
         * 
         * @param clusterNodes
         *        The nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNodes(Collection<AwsRedshiftClusterClusterNode> clusterNodes);

        /**
         * <p>
         * The nodes in the cluster.
         * </p>
         * 
         * @param clusterNodes
         *        The nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNodes(AwsRedshiftClusterClusterNode... clusterNodes);

        /**
         * <p>
         * The nodes in the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode.Builder#build()} is
         * called immediately and its result is passed to {@link #clusterNodes(List<AwsRedshiftClusterClusterNode>)}.
         * 
         * @param clusterNodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterNodes(java.util.Collection<AwsRedshiftClusterClusterNode>)
         */
        Builder clusterNodes(Consumer<AwsRedshiftClusterClusterNode.Builder>... clusterNodes);

        /**
         * <p>
         * The list of cluster parameter groups that are associated with this cluster.
         * </p>
         * 
         * @param clusterParameterGroups
         *        The list of cluster parameter groups that are associated with this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroups(Collection<AwsRedshiftClusterClusterParameterGroup> clusterParameterGroups);

        /**
         * <p>
         * The list of cluster parameter groups that are associated with this cluster.
         * </p>
         * 
         * @param clusterParameterGroups
         *        The list of cluster parameter groups that are associated with this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroups(AwsRedshiftClusterClusterParameterGroup... clusterParameterGroups);

        /**
         * <p>
         * The list of cluster parameter groups that are associated with this cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #clusterParameterGroups(List<AwsRedshiftClusterClusterParameterGroup>)}.
         * 
         * @param clusterParameterGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterParameterGroups(java.util.Collection<AwsRedshiftClusterClusterParameterGroup>)
         */
        Builder clusterParameterGroups(Consumer<AwsRedshiftClusterClusterParameterGroup.Builder>... clusterParameterGroups);

        /**
         * <p>
         * The public key for the cluster.
         * </p>
         * 
         * @param clusterPublicKey
         *        The public key for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterPublicKey(String clusterPublicKey);

        /**
         * <p>
         * The specific revision number of the database in the cluster.
         * </p>
         * 
         * @param clusterRevisionNumber
         *        The specific revision number of the database in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterRevisionNumber(String clusterRevisionNumber);

        /**
         * <p>
         * A list of cluster security groups that are associated with the cluster.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of cluster security groups that are associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(Collection<AwsRedshiftClusterClusterSecurityGroup> clusterSecurityGroups);

        /**
         * <p>
         * A list of cluster security groups that are associated with the cluster.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of cluster security groups that are associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(AwsRedshiftClusterClusterSecurityGroup... clusterSecurityGroups);

        /**
         * <p>
         * A list of cluster security groups that are associated with the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #clusterSecurityGroups(List<AwsRedshiftClusterClusterSecurityGroup>)}.
         * 
         * @param clusterSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSecurityGroups(java.util.Collection<AwsRedshiftClusterClusterSecurityGroup>)
         */
        Builder clusterSecurityGroups(Consumer<AwsRedshiftClusterClusterSecurityGroup.Builder>... clusterSecurityGroups);

        /**
         * <p>
         * Information about the destination Region and retention period for the cross-Region snapshot copy.
         * </p>
         * 
         * @param clusterSnapshotCopyStatus
         *        Information about the destination Region and retention period for the cross-Region snapshot copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSnapshotCopyStatus(AwsRedshiftClusterClusterSnapshotCopyStatus clusterSnapshotCopyStatus);

        /**
         * <p>
         * Information about the destination Region and retention period for the cross-Region snapshot copy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsRedshiftClusterClusterSnapshotCopyStatus.Builder} avoiding the need to create one manually via
         * {@link AwsRedshiftClusterClusterSnapshotCopyStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterClusterSnapshotCopyStatus.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #clusterSnapshotCopyStatus(AwsRedshiftClusterClusterSnapshotCopyStatus)}.
         * 
         * @param clusterSnapshotCopyStatus
         *        a consumer that will call methods on {@link AwsRedshiftClusterClusterSnapshotCopyStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSnapshotCopyStatus(AwsRedshiftClusterClusterSnapshotCopyStatus)
         */
        default Builder clusterSnapshotCopyStatus(
                Consumer<AwsRedshiftClusterClusterSnapshotCopyStatus.Builder> clusterSnapshotCopyStatus) {
            return clusterSnapshotCopyStatus(AwsRedshiftClusterClusterSnapshotCopyStatus.builder()
                    .applyMutation(clusterSnapshotCopyStatus).build());
        }

        /**
         * <p>
         * The current status of the cluster.
         * </p>
         * <p>
         * Valid values: <code>available</code> | <code>available, prep-for-resize</code> |
         * <code>available, resize-cleanup</code> |<code> cancelling-resize</code> | <code>creating</code> |
         * <code>deleting</code> | <code>final-snapshot</code> | <code>hardware-failure</code> |
         * <code>incompatible-hsm</code> |<code> incompatible-network</code> | <code>incompatible-parameters</code> |
         * <code>incompatible-restore</code> | <code>modifying</code> | <code>paused</code> | <code>rebooting</code> |
         * <code>renaming</code> | <code>resizing</code> | <code>rotating-keys</code> | <code>storage-full</code> |
         * <code>updating-hsm</code>
         * </p>
         * 
         * @param clusterStatus
         *        The current status of the cluster.</p>
         *        <p>
         *        Valid values: <code>available</code> | <code>available, prep-for-resize</code> |
         *        <code>available, resize-cleanup</code> |<code> cancelling-resize</code> | <code>creating</code> |
         *        <code>deleting</code> | <code>final-snapshot</code> | <code>hardware-failure</code> |
         *        <code>incompatible-hsm</code> |<code> incompatible-network</code> |
         *        <code>incompatible-parameters</code> | <code>incompatible-restore</code> | <code>modifying</code> |
         *        <code>paused</code> | <code>rebooting</code> | <code>renaming</code> | <code>resizing</code> |
         *        <code>rotating-keys</code> | <code>storage-full</code> | <code>updating-hsm</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterStatus(String clusterStatus);

        /**
         * <p>
         * The name of the subnet group that is associated with the cluster. This parameter is valid only when the
         * cluster is in a VPC.
         * </p>
         * 
         * @param clusterSubnetGroupName
         *        The name of the subnet group that is associated with the cluster. This parameter is valid only when
         *        the cluster is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSubnetGroupName(String clusterSubnetGroupName);

        /**
         * <p>
         * The version ID of the Amazon Redshift engine that runs on the cluster.
         * </p>
         * 
         * @param clusterVersion
         *        The version ID of the Amazon Redshift engine that runs on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersion(String clusterVersion);

        /**
         * <p>
         * The name of the initial database that was created when the cluster was created.
         * </p>
         * <p>
         * The same name is returned for the life of the cluster.
         * </p>
         * <p>
         * If an initial database is not specified, a database named <code>devdev</code> is created by default.
         * </p>
         * 
         * @param dbName
         *        The name of the initial database that was created when the cluster was created.</p>
         *        <p>
         *        The same name is returned for the life of the cluster.
         *        </p>
         *        <p>
         *        If an initial database is not specified, a database named <code>devdev</code> is created by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * List of time windows during which maintenance was deferred.
         * </p>
         * 
         * @param deferredMaintenanceWindows
         *        List of time windows during which maintenance was deferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferredMaintenanceWindows(Collection<AwsRedshiftClusterDeferredMaintenanceWindow> deferredMaintenanceWindows);

        /**
         * <p>
         * List of time windows during which maintenance was deferred.
         * </p>
         * 
         * @param deferredMaintenanceWindows
         *        List of time windows during which maintenance was deferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferredMaintenanceWindows(AwsRedshiftClusterDeferredMaintenanceWindow... deferredMaintenanceWindows);

        /**
         * <p>
         * List of time windows during which maintenance was deferred.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #deferredMaintenanceWindows(List<AwsRedshiftClusterDeferredMaintenanceWindow>)}.
         * 
         * @param deferredMaintenanceWindows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deferredMaintenanceWindows(java.util.Collection<AwsRedshiftClusterDeferredMaintenanceWindow>)
         */
        Builder deferredMaintenanceWindows(
                Consumer<AwsRedshiftClusterDeferredMaintenanceWindow.Builder>... deferredMaintenanceWindows);

        /**
         * <p>
         * Information about the status of the Elastic IP (EIP) address.
         * </p>
         * 
         * @param elasticIpStatus
         *        Information about the status of the Elastic IP (EIP) address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIpStatus(AwsRedshiftClusterElasticIpStatus elasticIpStatus);

        /**
         * <p>
         * Information about the status of the Elastic IP (EIP) address.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsRedshiftClusterElasticIpStatus.Builder} avoiding the need to create one manually via
         * {@link AwsRedshiftClusterElasticIpStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterElasticIpStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticIpStatus(AwsRedshiftClusterElasticIpStatus)}.
         * 
         * @param elasticIpStatus
         *        a consumer that will call methods on {@link AwsRedshiftClusterElasticIpStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticIpStatus(AwsRedshiftClusterElasticIpStatus)
         */
        default Builder elasticIpStatus(Consumer<AwsRedshiftClusterElasticIpStatus.Builder> elasticIpStatus) {
            return elasticIpStatus(AwsRedshiftClusterElasticIpStatus.builder().applyMutation(elasticIpStatus).build());
        }

        /**
         * <p>
         * The number of nodes that you can use the elastic resize method to resize the cluster to.
         * </p>
         * 
         * @param elasticResizeNumberOfNodeOptions
         *        The number of nodes that you can use the elastic resize method to resize the cluster to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticResizeNumberOfNodeOptions(String elasticResizeNumberOfNodeOptions);

        /**
         * <p>
         * Indicates whether the data in the cluster is encrypted at rest.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the data in the cluster is encrypted at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The connection endpoint.
         * </p>
         * 
         * @param endpoint
         *        The connection endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(AwsRedshiftClusterEndpoint endpoint);

        /**
         * <p>
         * The connection endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRedshiftClusterEndpoint.Builder}
         * avoiding the need to create one manually via {@link AwsRedshiftClusterEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #endpoint(AwsRedshiftClusterEndpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link AwsRedshiftClusterEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(AwsRedshiftClusterEndpoint)
         */
        default Builder endpoint(Consumer<AwsRedshiftClusterEndpoint.Builder> endpoint) {
            return endpoint(AwsRedshiftClusterEndpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * Indicates whether to create the cluster with enhanced VPC routing enabled.
         * </p>
         * 
         * @param enhancedVpcRouting
         *        Indicates whether to create the cluster with enhanced VPC routing enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * Indicates when the next snapshot is expected to be taken. The cluster must have a valid snapshot schedule and
         * have backups enabled.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param expectedNextSnapshotScheduleTime
         *        Indicates when the next snapshot is expected to be taken. The cluster must have a valid snapshot
         *        schedule and have backups enabled.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedNextSnapshotScheduleTime(String expectedNextSnapshotScheduleTime);

        /**
         * <p>
         * The status of the next expected snapshot.
         * </p>
         * <p>
         * Valid values: <code>OnTrack</code> | <code>Pending</code>
         * </p>
         * 
         * @param expectedNextSnapshotScheduleTimeStatus
         *        The status of the next expected snapshot.</p>
         *        <p>
         *        Valid values: <code>OnTrack</code> | <code>Pending</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedNextSnapshotScheduleTimeStatus(String expectedNextSnapshotScheduleTimeStatus);

        /**
         * <p>
         * Information about whether the Amazon Redshift cluster finished applying any changes to hardware security
         * module (HSM) settings that were specified in a modify cluster command.
         * </p>
         * 
         * @param hsmStatus
         *        Information about whether the Amazon Redshift cluster finished applying any changes to hardware
         *        security module (HSM) settings that were specified in a modify cluster command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmStatus(AwsRedshiftClusterHsmStatus hsmStatus);

        /**
         * <p>
         * Information about whether the Amazon Redshift cluster finished applying any changes to hardware security
         * module (HSM) settings that were specified in a modify cluster command.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRedshiftClusterHsmStatus.Builder}
         * avoiding the need to create one manually via {@link AwsRedshiftClusterHsmStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterHsmStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #hsmStatus(AwsRedshiftClusterHsmStatus)}.
         * 
         * @param hsmStatus
         *        a consumer that will call methods on {@link AwsRedshiftClusterHsmStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hsmStatus(AwsRedshiftClusterHsmStatus)
         */
        default Builder hsmStatus(Consumer<AwsRedshiftClusterHsmStatus.Builder> hsmStatus) {
            return hsmStatus(AwsRedshiftClusterHsmStatus.builder().applyMutation(hsmStatus).build());
        }

        /**
         * <p>
         * A list of IAM roles that the cluster can use to access other Amazon Web Services services.
         * </p>
         * 
         * @param iamRoles
         *        A list of IAM roles that the cluster can use to access other Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(Collection<AwsRedshiftClusterIamRole> iamRoles);

        /**
         * <p>
         * A list of IAM roles that the cluster can use to access other Amazon Web Services services.
         * </p>
         * 
         * @param iamRoles
         *        A list of IAM roles that the cluster can use to access other Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(AwsRedshiftClusterIamRole... iamRoles);

        /**
         * <p>
         * A list of IAM roles that the cluster can use to access other Amazon Web Services services.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole.Builder#build()} is called
         * immediately and its result is passed to {@link #iamRoles(List<AwsRedshiftClusterIamRole>)}.
         * 
         * @param iamRoles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamRoles(java.util.Collection<AwsRedshiftClusterIamRole>)
         */
        Builder iamRoles(Consumer<AwsRedshiftClusterIamRole.Builder>... iamRoles);

        /**
         * <p>
         * The identifier of the KMS encryption key that is used to encrypt data in the cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of the KMS encryption key that is used to encrypt data in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The name of the maintenance track for the cluster.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the maintenance track for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * The default number of days to retain a manual snapshot.
         * </p>
         * <p>
         * If the value is <code>-1</code>, the snapshot is retained indefinitely.
         * </p>
         * <p>
         * This setting doesn't change the retention period of existing snapshots.
         * </p>
         * <p>
         * Valid values: Either <code>-1</code> or an integer between 1 and 3,653
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The default number of days to retain a manual snapshot.</p>
         *        <p>
         *        If the value is <code>-1</code>, the snapshot is retained indefinitely.
         *        </p>
         *        <p>
         *        This setting doesn't change the retention period of existing snapshots.
         *        </p>
         *        <p>
         *        Valid values: Either <code>-1</code> or an integer between 1 and 3,653
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * The master user name for the cluster. This name is used to connect to the database that is specified in as
         * the value of <code>DBName</code>.
         * </p>
         * 
         * @param masterUsername
         *        The master user name for the cluster. This name is used to connect to the database that is specified
         *        in as the value of <code>DBName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * Indicates the start of the next maintenance window.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces, and date and time should be separated by <code>T</code>. For example,
         * <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param nextMaintenanceWindowStartTime
         *        Indicates the start of the next maintenance window.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces, and date and time should be separated by <code>T</code>.
         *        For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMaintenanceWindowStartTime(String nextMaintenanceWindowStartTime);

        /**
         * <p>
         * The node type for the nodes in the cluster.
         * </p>
         * 
         * @param nodeType
         *        The node type for the nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The number of compute nodes in the cluster.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of compute nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * A list of cluster operations that are waiting to start.
         * </p>
         * 
         * @param pendingActions
         *        A list of cluster operations that are waiting to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingActions(Collection<String> pendingActions);

        /**
         * <p>
         * A list of cluster operations that are waiting to start.
         * </p>
         * 
         * @param pendingActions
         *        A list of cluster operations that are waiting to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingActions(String... pendingActions);

        /**
         * <p>
         * A list of changes to the cluster that are currently pending.
         * </p>
         * 
         * @param pendingModifiedValues
         *        A list of changes to the cluster that are currently pending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(AwsRedshiftClusterPendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * A list of changes to the cluster that are currently pending.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsRedshiftClusterPendingModifiedValues.Builder} avoiding the need to create one manually via
         * {@link AwsRedshiftClusterPendingModifiedValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterPendingModifiedValues.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #pendingModifiedValues(AwsRedshiftClusterPendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link AwsRedshiftClusterPendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(AwsRedshiftClusterPendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<AwsRedshiftClusterPendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(AwsRedshiftClusterPendingModifiedValues.builder().applyMutation(pendingModifiedValues)
                    .build());
        }

        /**
         * <p>
         * The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
         * </p>
         * <p>
         * Format: <code> <i>&lt;day&gt;</i>:HH:MM-<i>&lt;day&gt;</i>:HH:MM</code>
         * </p>
         * <p>
         * For the day values, use <code>mon</code> | <code>tue</code> | <code>wed</code> | <code>thu</code> |
         * <code>fri</code> | <code>sat</code> | <code>sun</code>
         * </p>
         * <p>
         * For example, <code>sun:09:32-sun:10:02</code>
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can
         *        occur.</p>
         *        <p>
         *        Format: <code> <i>&lt;day&gt;</i>:HH:MM-<i>&lt;day&gt;</i>:HH:MM</code>
         *        </p>
         *        <p>
         *        For the day values, use <code>mon</code> | <code>tue</code> | <code>wed</code> | <code>thu</code> |
         *        <code>fri</code> | <code>sat</code> | <code>sun</code>
         *        </p>
         *        <p>
         *        For example, <code>sun:09:32-sun:10:02</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Whether the cluster can be accessed from a public network.
         * </p>
         * 
         * @param publiclyAccessible
         *        Whether the cluster can be accessed from a public network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * Information about the resize operation for the cluster.
         * </p>
         * 
         * @param resizeInfo
         *        Information about the resize operation for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resizeInfo(AwsRedshiftClusterResizeInfo resizeInfo);

        /**
         * <p>
         * Information about the resize operation for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRedshiftClusterResizeInfo.Builder}
         * avoiding the need to create one manually via {@link AwsRedshiftClusterResizeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterResizeInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #resizeInfo(AwsRedshiftClusterResizeInfo)}.
         * 
         * @param resizeInfo
         *        a consumer that will call methods on {@link AwsRedshiftClusterResizeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resizeInfo(AwsRedshiftClusterResizeInfo)
         */
        default Builder resizeInfo(Consumer<AwsRedshiftClusterResizeInfo.Builder> resizeInfo) {
            return resizeInfo(AwsRedshiftClusterResizeInfo.builder().applyMutation(resizeInfo).build());
        }

        /**
         * <p>
         * Information about the status of a cluster restore action. Only applies to a cluster that was created by
         * restoring a snapshot.
         * </p>
         * 
         * @param restoreStatus
         *        Information about the status of a cluster restore action. Only applies to a cluster that was created
         *        by restoring a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreStatus(AwsRedshiftClusterRestoreStatus restoreStatus);

        /**
         * <p>
         * Information about the status of a cluster restore action. Only applies to a cluster that was created by
         * restoring a snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRedshiftClusterRestoreStatus.Builder}
         * avoiding the need to create one manually via {@link AwsRedshiftClusterRestoreStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterRestoreStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreStatus(AwsRedshiftClusterRestoreStatus)}.
         * 
         * @param restoreStatus
         *        a consumer that will call methods on {@link AwsRedshiftClusterRestoreStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreStatus(AwsRedshiftClusterRestoreStatus)
         */
        default Builder restoreStatus(Consumer<AwsRedshiftClusterRestoreStatus.Builder> restoreStatus) {
            return restoreStatus(AwsRedshiftClusterRestoreStatus.builder().applyMutation(restoreStatus).build());
        }

        /**
         * <p>
         * A unique identifier for the cluster snapshot schedule.
         * </p>
         * 
         * @param snapshotScheduleIdentifier
         *        A unique identifier for the cluster snapshot schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier);

        /**
         * <p>
         * The current state of the cluster snapshot schedule.
         * </p>
         * <p>
         * Valid values: <code>MODIFYING</code> | <code>ACTIVE</code> | <code>FAILED</code>
         * </p>
         * 
         * @param snapshotScheduleState
         *        The current state of the cluster snapshot schedule.</p>
         *        <p>
         *        Valid values: <code>MODIFYING</code> | <code>ACTIVE</code> | <code>FAILED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotScheduleState(String snapshotScheduleState);

        /**
         * <p>
         * The identifier of the VPC that the cluster is in, if the cluster is in a VPC.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC that the cluster is in, if the cluster is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<AwsRedshiftClusterVpcSecurityGroup> vpcSecurityGroups);

        /**
         * <p>
         * The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(AwsRedshiftClusterVpcSecurityGroup... vpcSecurityGroups);

        /**
         * <p>
         * The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #vpcSecurityGroups(List<AwsRedshiftClusterVpcSecurityGroup>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterVpcSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(java.util.Collection<AwsRedshiftClusterVpcSecurityGroup>)
         */
        Builder vpcSecurityGroups(Consumer<AwsRedshiftClusterVpcSecurityGroup.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * Information about the logging status of the cluster.
         * </p>
         * 
         * @param loggingStatus
         *        Information about the logging status of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingStatus(AwsRedshiftClusterLoggingStatus loggingStatus);

        /**
         * <p>
         * Information about the logging status of the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRedshiftClusterLoggingStatus.Builder}
         * avoiding the need to create one manually via {@link AwsRedshiftClusterLoggingStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRedshiftClusterLoggingStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #loggingStatus(AwsRedshiftClusterLoggingStatus)}.
         * 
         * @param loggingStatus
         *        a consumer that will call methods on {@link AwsRedshiftClusterLoggingStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingStatus(AwsRedshiftClusterLoggingStatus)
         */
        default Builder loggingStatus(Consumer<AwsRedshiftClusterLoggingStatus.Builder> loggingStatus) {
            return loggingStatus(AwsRedshiftClusterLoggingStatus.builder().applyMutation(loggingStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowVersionUpgrade;

        private Integer automatedSnapshotRetentionPeriod;

        private String availabilityZone;

        private String clusterAvailabilityStatus;

        private String clusterCreateTime;

        private String clusterIdentifier;

        private List<AwsRedshiftClusterClusterNode> clusterNodes = DefaultSdkAutoConstructList.getInstance();

        private List<AwsRedshiftClusterClusterParameterGroup> clusterParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private String clusterPublicKey;

        private String clusterRevisionNumber;

        private List<AwsRedshiftClusterClusterSecurityGroup> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private AwsRedshiftClusterClusterSnapshotCopyStatus clusterSnapshotCopyStatus;

        private String clusterStatus;

        private String clusterSubnetGroupName;

        private String clusterVersion;

        private String dbName;

        private List<AwsRedshiftClusterDeferredMaintenanceWindow> deferredMaintenanceWindows = DefaultSdkAutoConstructList
                .getInstance();

        private AwsRedshiftClusterElasticIpStatus elasticIpStatus;

        private String elasticResizeNumberOfNodeOptions;

        private Boolean encrypted;

        private AwsRedshiftClusterEndpoint endpoint;

        private Boolean enhancedVpcRouting;

        private String expectedNextSnapshotScheduleTime;

        private String expectedNextSnapshotScheduleTimeStatus;

        private AwsRedshiftClusterHsmStatus hsmStatus;

        private List<AwsRedshiftClusterIamRole> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private String maintenanceTrackName;

        private Integer manualSnapshotRetentionPeriod;

        private String masterUsername;

        private String nextMaintenanceWindowStartTime;

        private String nodeType;

        private Integer numberOfNodes;

        private List<String> pendingActions = DefaultSdkAutoConstructList.getInstance();

        private AwsRedshiftClusterPendingModifiedValues pendingModifiedValues;

        private String preferredMaintenanceWindow;

        private Boolean publiclyAccessible;

        private AwsRedshiftClusterResizeInfo resizeInfo;

        private AwsRedshiftClusterRestoreStatus restoreStatus;

        private String snapshotScheduleIdentifier;

        private String snapshotScheduleState;

        private String vpcId;

        private List<AwsRedshiftClusterVpcSecurityGroup> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private AwsRedshiftClusterLoggingStatus loggingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterDetails model) {
            allowVersionUpgrade(model.allowVersionUpgrade);
            automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            availabilityZone(model.availabilityZone);
            clusterAvailabilityStatus(model.clusterAvailabilityStatus);
            clusterCreateTime(model.clusterCreateTime);
            clusterIdentifier(model.clusterIdentifier);
            clusterNodes(model.clusterNodes);
            clusterParameterGroups(model.clusterParameterGroups);
            clusterPublicKey(model.clusterPublicKey);
            clusterRevisionNumber(model.clusterRevisionNumber);
            clusterSecurityGroups(model.clusterSecurityGroups);
            clusterSnapshotCopyStatus(model.clusterSnapshotCopyStatus);
            clusterStatus(model.clusterStatus);
            clusterSubnetGroupName(model.clusterSubnetGroupName);
            clusterVersion(model.clusterVersion);
            dbName(model.dbName);
            deferredMaintenanceWindows(model.deferredMaintenanceWindows);
            elasticIpStatus(model.elasticIpStatus);
            elasticResizeNumberOfNodeOptions(model.elasticResizeNumberOfNodeOptions);
            encrypted(model.encrypted);
            endpoint(model.endpoint);
            enhancedVpcRouting(model.enhancedVpcRouting);
            expectedNextSnapshotScheduleTime(model.expectedNextSnapshotScheduleTime);
            expectedNextSnapshotScheduleTimeStatus(model.expectedNextSnapshotScheduleTimeStatus);
            hsmStatus(model.hsmStatus);
            iamRoles(model.iamRoles);
            kmsKeyId(model.kmsKeyId);
            maintenanceTrackName(model.maintenanceTrackName);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            masterUsername(model.masterUsername);
            nextMaintenanceWindowStartTime(model.nextMaintenanceWindowStartTime);
            nodeType(model.nodeType);
            numberOfNodes(model.numberOfNodes);
            pendingActions(model.pendingActions);
            pendingModifiedValues(model.pendingModifiedValues);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            publiclyAccessible(model.publiclyAccessible);
            resizeInfo(model.resizeInfo);
            restoreStatus(model.restoreStatus);
            snapshotScheduleIdentifier(model.snapshotScheduleIdentifier);
            snapshotScheduleState(model.snapshotScheduleState);
            vpcId(model.vpcId);
            vpcSecurityGroups(model.vpcSecurityGroups);
            loggingStatus(model.loggingStatus);
        }

        public final Boolean getAllowVersionUpgrade() {
            return allowVersionUpgrade;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return automatedSnapshotRetentionPeriod;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getClusterAvailabilityStatus() {
            return clusterAvailabilityStatus;
        }

        public final void setClusterAvailabilityStatus(String clusterAvailabilityStatus) {
            this.clusterAvailabilityStatus = clusterAvailabilityStatus;
        }

        @Override
        public final Builder clusterAvailabilityStatus(String clusterAvailabilityStatus) {
            this.clusterAvailabilityStatus = clusterAvailabilityStatus;
            return this;
        }

        public final String getClusterCreateTime() {
            return clusterCreateTime;
        }

        public final void setClusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final List<AwsRedshiftClusterClusterNode.Builder> getClusterNodes() {
            List<AwsRedshiftClusterClusterNode.Builder> result = AwsRedshiftClusterClusterNodesCopier
                    .copyToBuilder(this.clusterNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterNodes(Collection<AwsRedshiftClusterClusterNode.BuilderImpl> clusterNodes) {
            this.clusterNodes = AwsRedshiftClusterClusterNodesCopier.copyFromBuilder(clusterNodes);
        }

        @Override
        public final Builder clusterNodes(Collection<AwsRedshiftClusterClusterNode> clusterNodes) {
            this.clusterNodes = AwsRedshiftClusterClusterNodesCopier.copy(clusterNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(AwsRedshiftClusterClusterNode... clusterNodes) {
            clusterNodes(Arrays.asList(clusterNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(Consumer<AwsRedshiftClusterClusterNode.Builder>... clusterNodes) {
            clusterNodes(Stream.of(clusterNodes).map(c -> AwsRedshiftClusterClusterNode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsRedshiftClusterClusterParameterGroup.Builder> getClusterParameterGroups() {
            List<AwsRedshiftClusterClusterParameterGroup.Builder> result = AwsRedshiftClusterClusterParameterGroupsCopier
                    .copyToBuilder(this.clusterParameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterParameterGroups(
                Collection<AwsRedshiftClusterClusterParameterGroup.BuilderImpl> clusterParameterGroups) {
            this.clusterParameterGroups = AwsRedshiftClusterClusterParameterGroupsCopier.copyFromBuilder(clusterParameterGroups);
        }

        @Override
        public final Builder clusterParameterGroups(Collection<AwsRedshiftClusterClusterParameterGroup> clusterParameterGroups) {
            this.clusterParameterGroups = AwsRedshiftClusterClusterParameterGroupsCopier.copy(clusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterGroups(AwsRedshiftClusterClusterParameterGroup... clusterParameterGroups) {
            clusterParameterGroups(Arrays.asList(clusterParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterGroups(
                Consumer<AwsRedshiftClusterClusterParameterGroup.Builder>... clusterParameterGroups) {
            clusterParameterGroups(Stream.of(clusterParameterGroups)
                    .map(c -> AwsRedshiftClusterClusterParameterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClusterPublicKey() {
            return clusterPublicKey;
        }

        public final void setClusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
        }

        @Override
        public final Builder clusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
            return this;
        }

        public final String getClusterRevisionNumber() {
            return clusterRevisionNumber;
        }

        public final void setClusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
        }

        @Override
        public final Builder clusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
            return this;
        }

        public final List<AwsRedshiftClusterClusterSecurityGroup.Builder> getClusterSecurityGroups() {
            List<AwsRedshiftClusterClusterSecurityGroup.Builder> result = AwsRedshiftClusterClusterSecurityGroupsCopier
                    .copyToBuilder(this.clusterSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSecurityGroups(
                Collection<AwsRedshiftClusterClusterSecurityGroup.BuilderImpl> clusterSecurityGroups) {
            this.clusterSecurityGroups = AwsRedshiftClusterClusterSecurityGroupsCopier.copyFromBuilder(clusterSecurityGroups);
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<AwsRedshiftClusterClusterSecurityGroup> clusterSecurityGroups) {
            this.clusterSecurityGroups = AwsRedshiftClusterClusterSecurityGroupsCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(AwsRedshiftClusterClusterSecurityGroup... clusterSecurityGroups) {
            clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(
                Consumer<AwsRedshiftClusterClusterSecurityGroup.Builder>... clusterSecurityGroups) {
            clusterSecurityGroups(Stream.of(clusterSecurityGroups)
                    .map(c -> AwsRedshiftClusterClusterSecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsRedshiftClusterClusterSnapshotCopyStatus.Builder getClusterSnapshotCopyStatus() {
            return clusterSnapshotCopyStatus != null ? clusterSnapshotCopyStatus.toBuilder() : null;
        }

        public final void setClusterSnapshotCopyStatus(
                AwsRedshiftClusterClusterSnapshotCopyStatus.BuilderImpl clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus != null ? clusterSnapshotCopyStatus.build() : null;
        }

        @Override
        public final Builder clusterSnapshotCopyStatus(AwsRedshiftClusterClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
            return this;
        }

        public final String getClusterStatus() {
            return clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        public final String getClusterSubnetGroupName() {
            return clusterSubnetGroupName;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final String getClusterVersion() {
            return clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final List<AwsRedshiftClusterDeferredMaintenanceWindow.Builder> getDeferredMaintenanceWindows() {
            List<AwsRedshiftClusterDeferredMaintenanceWindow.Builder> result = AwsRedshiftClusterDeferredMaintenanceWindowsCopier
                    .copyToBuilder(this.deferredMaintenanceWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeferredMaintenanceWindows(
                Collection<AwsRedshiftClusterDeferredMaintenanceWindow.BuilderImpl> deferredMaintenanceWindows) {
            this.deferredMaintenanceWindows = AwsRedshiftClusterDeferredMaintenanceWindowsCopier
                    .copyFromBuilder(deferredMaintenanceWindows);
        }

        @Override
        public final Builder deferredMaintenanceWindows(
                Collection<AwsRedshiftClusterDeferredMaintenanceWindow> deferredMaintenanceWindows) {
            this.deferredMaintenanceWindows = AwsRedshiftClusterDeferredMaintenanceWindowsCopier.copy(deferredMaintenanceWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deferredMaintenanceWindows(AwsRedshiftClusterDeferredMaintenanceWindow... deferredMaintenanceWindows) {
            deferredMaintenanceWindows(Arrays.asList(deferredMaintenanceWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deferredMaintenanceWindows(
                Consumer<AwsRedshiftClusterDeferredMaintenanceWindow.Builder>... deferredMaintenanceWindows) {
            deferredMaintenanceWindows(Stream.of(deferredMaintenanceWindows)
                    .map(c -> AwsRedshiftClusterDeferredMaintenanceWindow.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsRedshiftClusterElasticIpStatus.Builder getElasticIpStatus() {
            return elasticIpStatus != null ? elasticIpStatus.toBuilder() : null;
        }

        public final void setElasticIpStatus(AwsRedshiftClusterElasticIpStatus.BuilderImpl elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus != null ? elasticIpStatus.build() : null;
        }

        @Override
        public final Builder elasticIpStatus(AwsRedshiftClusterElasticIpStatus elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus;
            return this;
        }

        public final String getElasticResizeNumberOfNodeOptions() {
            return elasticResizeNumberOfNodeOptions;
        }

        public final void setElasticResizeNumberOfNodeOptions(String elasticResizeNumberOfNodeOptions) {
            this.elasticResizeNumberOfNodeOptions = elasticResizeNumberOfNodeOptions;
        }

        @Override
        public final Builder elasticResizeNumberOfNodeOptions(String elasticResizeNumberOfNodeOptions) {
            this.elasticResizeNumberOfNodeOptions = elasticResizeNumberOfNodeOptions;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final AwsRedshiftClusterEndpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(AwsRedshiftClusterEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(AwsRedshiftClusterEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final String getExpectedNextSnapshotScheduleTime() {
            return expectedNextSnapshotScheduleTime;
        }

        public final void setExpectedNextSnapshotScheduleTime(String expectedNextSnapshotScheduleTime) {
            this.expectedNextSnapshotScheduleTime = expectedNextSnapshotScheduleTime;
        }

        @Override
        public final Builder expectedNextSnapshotScheduleTime(String expectedNextSnapshotScheduleTime) {
            this.expectedNextSnapshotScheduleTime = expectedNextSnapshotScheduleTime;
            return this;
        }

        public final String getExpectedNextSnapshotScheduleTimeStatus() {
            return expectedNextSnapshotScheduleTimeStatus;
        }

        public final void setExpectedNextSnapshotScheduleTimeStatus(String expectedNextSnapshotScheduleTimeStatus) {
            this.expectedNextSnapshotScheduleTimeStatus = expectedNextSnapshotScheduleTimeStatus;
        }

        @Override
        public final Builder expectedNextSnapshotScheduleTimeStatus(String expectedNextSnapshotScheduleTimeStatus) {
            this.expectedNextSnapshotScheduleTimeStatus = expectedNextSnapshotScheduleTimeStatus;
            return this;
        }

        public final AwsRedshiftClusterHsmStatus.Builder getHsmStatus() {
            return hsmStatus != null ? hsmStatus.toBuilder() : null;
        }

        public final void setHsmStatus(AwsRedshiftClusterHsmStatus.BuilderImpl hsmStatus) {
            this.hsmStatus = hsmStatus != null ? hsmStatus.build() : null;
        }

        @Override
        public final Builder hsmStatus(AwsRedshiftClusterHsmStatus hsmStatus) {
            this.hsmStatus = hsmStatus;
            return this;
        }

        public final List<AwsRedshiftClusterIamRole.Builder> getIamRoles() {
            List<AwsRedshiftClusterIamRole.Builder> result = AwsRedshiftClusterIamRolesCopier.copyToBuilder(this.iamRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIamRoles(Collection<AwsRedshiftClusterIamRole.BuilderImpl> iamRoles) {
            this.iamRoles = AwsRedshiftClusterIamRolesCopier.copyFromBuilder(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<AwsRedshiftClusterIamRole> iamRoles) {
            this.iamRoles = AwsRedshiftClusterIamRolesCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(AwsRedshiftClusterIamRole... iamRoles) {
            iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(Consumer<AwsRedshiftClusterIamRole.Builder>... iamRoles) {
            iamRoles(Stream.of(iamRoles).map(c -> AwsRedshiftClusterIamRole.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getNextMaintenanceWindowStartTime() {
            return nextMaintenanceWindowStartTime;
        }

        public final void setNextMaintenanceWindowStartTime(String nextMaintenanceWindowStartTime) {
            this.nextMaintenanceWindowStartTime = nextMaintenanceWindowStartTime;
        }

        @Override
        public final Builder nextMaintenanceWindowStartTime(String nextMaintenanceWindowStartTime) {
            this.nextMaintenanceWindowStartTime = nextMaintenanceWindowStartTime;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final Collection<String> getPendingActions() {
            if (pendingActions instanceof SdkAutoConstructList) {
                return null;
            }
            return pendingActions;
        }

        public final void setPendingActions(Collection<String> pendingActions) {
            this.pendingActions = StringListCopier.copy(pendingActions);
        }

        @Override
        public final Builder pendingActions(Collection<String> pendingActions) {
            this.pendingActions = StringListCopier.copy(pendingActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingActions(String... pendingActions) {
            pendingActions(Arrays.asList(pendingActions));
            return this;
        }

        public final AwsRedshiftClusterPendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(AwsRedshiftClusterPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(AwsRedshiftClusterPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final AwsRedshiftClusterResizeInfo.Builder getResizeInfo() {
            return resizeInfo != null ? resizeInfo.toBuilder() : null;
        }

        public final void setResizeInfo(AwsRedshiftClusterResizeInfo.BuilderImpl resizeInfo) {
            this.resizeInfo = resizeInfo != null ? resizeInfo.build() : null;
        }

        @Override
        public final Builder resizeInfo(AwsRedshiftClusterResizeInfo resizeInfo) {
            this.resizeInfo = resizeInfo;
            return this;
        }

        public final AwsRedshiftClusterRestoreStatus.Builder getRestoreStatus() {
            return restoreStatus != null ? restoreStatus.toBuilder() : null;
        }

        public final void setRestoreStatus(AwsRedshiftClusterRestoreStatus.BuilderImpl restoreStatus) {
            this.restoreStatus = restoreStatus != null ? restoreStatus.build() : null;
        }

        @Override
        public final Builder restoreStatus(AwsRedshiftClusterRestoreStatus restoreStatus) {
            this.restoreStatus = restoreStatus;
            return this;
        }

        public final String getSnapshotScheduleIdentifier() {
            return snapshotScheduleIdentifier;
        }

        public final void setSnapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
        }

        @Override
        public final Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
            return this;
        }

        public final String getSnapshotScheduleState() {
            return snapshotScheduleState;
        }

        public final void setSnapshotScheduleState(String snapshotScheduleState) {
            this.snapshotScheduleState = snapshotScheduleState;
        }

        @Override
        public final Builder snapshotScheduleState(String snapshotScheduleState) {
            this.snapshotScheduleState = snapshotScheduleState;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<AwsRedshiftClusterVpcSecurityGroup.Builder> getVpcSecurityGroups() {
            List<AwsRedshiftClusterVpcSecurityGroup.Builder> result = AwsRedshiftClusterVpcSecurityGroupsCopier
                    .copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<AwsRedshiftClusterVpcSecurityGroup.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRedshiftClusterVpcSecurityGroupsCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<AwsRedshiftClusterVpcSecurityGroup> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRedshiftClusterVpcSecurityGroupsCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(AwsRedshiftClusterVpcSecurityGroup... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<AwsRedshiftClusterVpcSecurityGroup.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> AwsRedshiftClusterVpcSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsRedshiftClusterLoggingStatus.Builder getLoggingStatus() {
            return loggingStatus != null ? loggingStatus.toBuilder() : null;
        }

        public final void setLoggingStatus(AwsRedshiftClusterLoggingStatus.BuilderImpl loggingStatus) {
            this.loggingStatus = loggingStatus != null ? loggingStatus.build() : null;
        }

        @Override
        public final Builder loggingStatus(AwsRedshiftClusterLoggingStatus loggingStatus) {
            this.loggingStatus = loggingStatus;
            return this;
        }

        @Override
        public AwsRedshiftClusterDetails build() {
            return new AwsRedshiftClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
