/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A function's environment variable settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLambdaFunctionEnvironment implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLambdaFunctionEnvironment.Builder, AwsLambdaFunctionEnvironment> {
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Variables")
            .getter(getter(AwsLambdaFunctionEnvironment::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AwsLambdaFunctionEnvironmentError> ERROR_FIELD = SdkField
            .<AwsLambdaFunctionEnvironmentError> builder(MarshallingType.SDK_POJO).memberName("Error")
            .getter(getter(AwsLambdaFunctionEnvironment::error)).setter(setter(Builder::error))
            .constructor(AwsLambdaFunctionEnvironmentError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLES_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> variables;

    private final AwsLambdaFunctionEnvironmentError error;

    private AwsLambdaFunctionEnvironment(BuilderImpl builder) {
        this.variables = builder.variables;
        this.error = builder.error;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Environment variable key-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return Environment variable key-value pairs.
     */
    public final Map<String, String> variables() {
        return variables;
    }

    /**
     * <p>
     * An <code>AwsLambdaFunctionEnvironmentError</code> object.
     * </p>
     * 
     * @return An <code>AwsLambdaFunctionEnvironmentError</code> object.
     */
    public final AwsLambdaFunctionEnvironmentError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaFunctionEnvironment)) {
            return false;
        }
        AwsLambdaFunctionEnvironment other = (AwsLambdaFunctionEnvironment) obj;
        return hasVariables() == other.hasVariables() && Objects.equals(variables(), other.variables())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsLambdaFunctionEnvironment").add("Variables", hasVariables() ? variables() : null)
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaFunctionEnvironment, T> g) {
        return obj -> g.apply((AwsLambdaFunctionEnvironment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLambdaFunctionEnvironment> {
        /**
         * <p>
         * Environment variable key-value pairs.
         * </p>
         * 
         * @param variables
         *        Environment variable key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, String> variables);

        /**
         * <p>
         * An <code>AwsLambdaFunctionEnvironmentError</code> object.
         * </p>
         * 
         * @param error
         *        An <code>AwsLambdaFunctionEnvironmentError</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(AwsLambdaFunctionEnvironmentError error);

        /**
         * <p>
         * An <code>AwsLambdaFunctionEnvironmentError</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsLambdaFunctionEnvironmentError.Builder} avoiding the need to create one manually via
         * {@link AwsLambdaFunctionEnvironmentError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionEnvironmentError.Builder#build()} is called
         * immediately and its result is passed to {@link #error(AwsLambdaFunctionEnvironmentError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link AwsLambdaFunctionEnvironmentError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(AwsLambdaFunctionEnvironmentError)
         */
        default Builder error(Consumer<AwsLambdaFunctionEnvironmentError.Builder> error) {
            return error(AwsLambdaFunctionEnvironmentError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private AwsLambdaFunctionEnvironmentError error;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaFunctionEnvironment model) {
            variables(model.variables);
            error(model.error);
        }

        public final Map<String, String> getVariables() {
            if (variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = FieldMapCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = FieldMapCopier.copy(variables);
            return this;
        }

        public final AwsLambdaFunctionEnvironmentError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(AwsLambdaFunctionEnvironmentError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(AwsLambdaFunctionEnvironmentError error) {
            this.error = error;
            return this;
        }

        @Override
        public AwsLambdaFunctionEnvironment build() {
            return new AwsLambdaFunctionEnvironment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
