/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon Elastic File System file system that is used for task storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.Builder, AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails> {
    private static final SdkField<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails> AUTHORIZATION_CONFIG_FIELD = SdkField
            .<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AuthorizationConfig")
            .getter(getter(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails::authorizationConfig))
            .setter(setter(Builder::authorizationConfig))
            .constructor(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationConfig").build())
            .build();

    private static final SdkField<String> FILESYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilesystemId").getter(getter(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails::filesystemId))
            .setter(setter(Builder::filesystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesystemId").build()).build();

    private static final SdkField<String> ROOT_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootDirectory").getter(getter(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails::rootDirectory))
            .setter(setter(Builder::rootDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDirectory").build()).build();

    private static final SdkField<String> TRANSIT_ENCRYPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransitEncryption")
            .getter(getter(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails::transitEncryption))
            .setter(setter(Builder::transitEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryption").build()).build();

    private static final SdkField<Integer> TRANSIT_ENCRYPTION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TransitEncryptionPort")
            .getter(getter(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails::transitEncryptionPort))
            .setter(setter(Builder::transitEncryptionPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionPort").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_CONFIG_FIELD,
            FILESYSTEM_ID_FIELD, ROOT_DIRECTORY_FIELD, TRANSIT_ENCRYPTION_FIELD, TRANSIT_ENCRYPTION_PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails authorizationConfig;

    private final String filesystemId;

    private final String rootDirectory;

    private final String transitEncryption;

    private final Integer transitEncryptionPort;

    private AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(BuilderImpl builder) {
        this.authorizationConfig = builder.authorizationConfig;
        this.filesystemId = builder.filesystemId;
        this.rootDirectory = builder.rootDirectory;
        this.transitEncryption = builder.transitEncryption;
        this.transitEncryptionPort = builder.transitEncryptionPort;
    }

    /**
     * <p>
     * The authorization configuration details for the Amazon EFS file system.
     * </p>
     * 
     * @return The authorization configuration details for the Amazon EFS file system.
     */
    public final AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails authorizationConfig() {
        return authorizationConfig;
    }

    /**
     * <p>
     * The Amazon EFS file system identifier to use.
     * </p>
     * 
     * @return The Amazon EFS file system identifier to use.
     */
    public final String filesystemId() {
        return filesystemId;
    }

    /**
     * <p>
     * The directory within the Amazon EFS file system to mount as the root directory inside the host.
     * </p>
     * 
     * @return The directory within the Amazon EFS file system to mount as the root directory inside the host.
     */
    public final String rootDirectory() {
        return rootDirectory;
    }

    /**
     * <p>
     * Whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS
     * server.
     * </p>
     * 
     * @return Whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon
     *         EFS server.
     */
    public final String transitEncryption() {
        return transitEncryption;
    }

    /**
     * <p>
     * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
     * </p>
     * 
     * @return The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
     */
    public final Integer transitEncryptionPort() {
        return transitEncryptionPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(filesystemId());
        hashCode = 31 * hashCode + Objects.hashCode(rootDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(transitEncryptionPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails other = (AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) obj;
        return Objects.equals(authorizationConfig(), other.authorizationConfig())
                && Objects.equals(filesystemId(), other.filesystemId()) && Objects.equals(rootDirectory(), other.rootDirectory())
                && Objects.equals(transitEncryption(), other.transitEncryption())
                && Objects.equals(transitEncryptionPort(), other.transitEncryptionPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails")
                .add("AuthorizationConfig", authorizationConfig()).add("FilesystemId", filesystemId())
                .add("RootDirectory", rootDirectory()).add("TransitEncryption", transitEncryption())
                .add("TransitEncryptionPort", transitEncryptionPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationConfig":
            return Optional.ofNullable(clazz.cast(authorizationConfig()));
        case "FilesystemId":
            return Optional.ofNullable(clazz.cast(filesystemId()));
        case "RootDirectory":
            return Optional.ofNullable(clazz.cast(rootDirectory()));
        case "TransitEncryption":
            return Optional.ofNullable(clazz.cast(transitEncryption()));
        case "TransitEncryptionPort":
            return Optional.ofNullable(clazz.cast(transitEncryptionPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails> {
        /**
         * <p>
         * The authorization configuration details for the Amazon EFS file system.
         * </p>
         * 
         * @param authorizationConfig
         *        The authorization configuration details for the Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationConfig(
                AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails authorizationConfig);

        /**
         * <p>
         * The authorization configuration details for the Amazon EFS file system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.Builder} avoiding the need
         * to create one manually via
         * {@link AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #authorizationConfig(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails)}.
         * 
         * @param authorizationConfig
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationConfig(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails)
         */
        default Builder authorizationConfig(
                Consumer<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.Builder> authorizationConfig) {
            return authorizationConfig(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.builder()
                    .applyMutation(authorizationConfig).build());
        }

        /**
         * <p>
         * The Amazon EFS file system identifier to use.
         * </p>
         * 
         * @param filesystemId
         *        The Amazon EFS file system identifier to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filesystemId(String filesystemId);

        /**
         * <p>
         * The directory within the Amazon EFS file system to mount as the root directory inside the host.
         * </p>
         * 
         * @param rootDirectory
         *        The directory within the Amazon EFS file system to mount as the root directory inside the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDirectory(String rootDirectory);

        /**
         * <p>
         * Whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS
         * server.
         * </p>
         * 
         * @param transitEncryption
         *        Whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon
         *        EFS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryption(String transitEncryption);

        /**
         * <p>
         * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
         * </p>
         * 
         * @param transitEncryptionPort
         *        The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitEncryptionPort(Integer transitEncryptionPort);
    }

    static final class BuilderImpl implements Builder {
        private AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails authorizationConfig;

        private String filesystemId;

        private String rootDirectory;

        private String transitEncryption;

        private Integer transitEncryptionPort;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails model) {
            authorizationConfig(model.authorizationConfig);
            filesystemId(model.filesystemId);
            rootDirectory(model.rootDirectory);
            transitEncryption(model.transitEncryption);
            transitEncryptionPort(model.transitEncryptionPort);
        }

        public final AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.Builder getAuthorizationConfig() {
            return authorizationConfig != null ? authorizationConfig.toBuilder() : null;
        }

        public final void setAuthorizationConfig(
                AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.BuilderImpl authorizationConfig) {
            this.authorizationConfig = authorizationConfig != null ? authorizationConfig.build() : null;
        }

        @Override
        public final Builder authorizationConfig(
                AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        public final String getFilesystemId() {
            return filesystemId;
        }

        public final void setFilesystemId(String filesystemId) {
            this.filesystemId = filesystemId;
        }

        @Override
        public final Builder filesystemId(String filesystemId) {
            this.filesystemId = filesystemId;
            return this;
        }

        public final String getRootDirectory() {
            return rootDirectory;
        }

        public final void setRootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
        }

        @Override
        public final Builder rootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public final String getTransitEncryption() {
            return transitEncryption;
        }

        public final void setTransitEncryption(String transitEncryption) {
            this.transitEncryption = transitEncryption;
        }

        @Override
        public final Builder transitEncryption(String transitEncryption) {
            this.transitEncryption = transitEncryption;
            return this;
        }

        public final Integer getTransitEncryptionPort() {
            return transitEncryptionPort;
        }

        public final void setTransitEncryptionPort(Integer transitEncryptionPort) {
            this.transitEncryptionPort = transitEncryptionPort;
        }

        @Override
        public final Builder transitEncryptionPort(Integer transitEncryptionPort) {
            this.transitEncryptionPort = transitEncryptionPort;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails build() {
            return new AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
