/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A host device to expose to the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> {
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerPath")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails::containerPath))
            .setter(setter(Builder::containerPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPath").build()).build();

    private static final SdkField<String> HOST_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostPath")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails::hostPath))
            .setter(setter(Builder::hostPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostPath").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PATH_FIELD,
            HOST_PATH_FIELD, PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerPath;

    private final String hostPath;

    private final List<String> permissions;

    private AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.hostPath = builder.hostPath;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * The path inside the container at which to expose the host device.
     * </p>
     * 
     * @return The path inside the container at which to expose the host device.
     */
    public final String containerPath() {
        return containerPath;
    }

    /**
     * <p>
     * The path for the device on the host container instance.
     * </p>
     * 
     * @return The path for the device on the host container instance.
     */
    public final String hostPath() {
        return hostPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The explicit permissions to provide to the container for the device. By default, the container has permissions
     * for read, write, and <code>mknod</code> for the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The explicit permissions to provide to the container for the device. By default, the container has
     *         permissions for read, write, and <code>mknod</code> for the device.
     */
    public final List<String> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(hostPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails other = (AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) obj;
        return Objects.equals(containerPath(), other.containerPath()) && Objects.equals(hostPath(), other.hostPath())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails")
                .add("ContainerPath", containerPath()).add("HostPath", hostPath())
                .add("Permissions", hasPermissions() ? permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerPath":
            return Optional.ofNullable(clazz.cast(containerPath()));
        case "HostPath":
            return Optional.ofNullable(clazz.cast(hostPath()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> {
        /**
         * <p>
         * The path inside the container at which to expose the host device.
         * </p>
         * 
         * @param containerPath
         *        The path inside the container at which to expose the host device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPath(String containerPath);

        /**
         * <p>
         * The path for the device on the host container instance.
         * </p>
         * 
         * @param hostPath
         *        The path for the device on the host container instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostPath(String hostPath);

        /**
         * <p>
         * The explicit permissions to provide to the container for the device. By default, the container has
         * permissions for read, write, and <code>mknod</code> for the device.
         * </p>
         * 
         * @param permissions
         *        The explicit permissions to provide to the container for the device. By default, the container has
         *        permissions for read, write, and <code>mknod</code> for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<String> permissions);

        /**
         * <p>
         * The explicit permissions to provide to the container for the device. By default, the container has
         * permissions for read, write, and <code>mknod</code> for the device.
         * </p>
         * 
         * @param permissions
         *        The explicit permissions to provide to the container for the device. By default, the container has
         *        permissions for read, write, and <code>mknod</code> for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(String... permissions);
    }

    static final class BuilderImpl implements Builder {
        private String containerPath;

        private String hostPath;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails model) {
            containerPath(model.containerPath);
            hostPath(model.hostPath);
            permissions(model.permissions);
        }

        public final String getContainerPath() {
            return containerPath;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final String getHostPath() {
            return hostPath;
        }

        public final void setHostPath(String hostPath) {
            this.hostPath = hostPath;
        }

        @Override
        public final Builder hostPath(String hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = NonEmptyStringListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = NonEmptyStringListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
