/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a service discovery registry to assign to the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServiceServiceRegistriesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsServiceServiceRegistriesDetails.Builder, AwsEcsServiceServiceRegistriesDetails> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerName").getter(getter(AwsEcsServiceServiceRegistriesDetails::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()).build();

    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ContainerPort").getter(getter(AwsEcsServiceServiceRegistriesDetails::containerPort))
            .setter(setter(Builder::containerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPort").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AwsEcsServiceServiceRegistriesDetails::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryArn").getter(getter(AwsEcsServiceServiceRegistriesDetails::registryArn))
            .setter(setter(Builder::registryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            CONTAINER_PORT_FIELD, PORT_FIELD, REGISTRY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerName;

    private final Integer containerPort;

    private final Integer port;

    private final String registryArn;

    private AwsEcsServiceServiceRegistriesDetails(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.containerPort = builder.containerPort;
        this.port = builder.port;
        this.registryArn = builder.registryArn;
    }

    /**
     * <p>
     * The container name value to use for the service discovery service.
     * </p>
     * <p>
     * If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify
     * <code>ContainerName</code> and <code>ContainerPort</code>.
     * </p>
     * <p>
     * If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify
     * either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.
     * </p>
     * 
     * @return The container name value to use for the service discovery service.</p>
     *         <p>
     *         If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify
     *         <code>ContainerName</code> and <code>ContainerPort</code>.
     *         </p>
     *         <p>
     *         If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must
     *         specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not
     *         both.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The port value to use for the service discovery service.
     * </p>
     * <p>
     * If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify
     * <code>ContainerName</code> and <code>ContainerPort</code>.
     * </p>
     * <p>
     * If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify
     * either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.
     * </p>
     * 
     * @return The port value to use for the service discovery service.</p>
     *         <p>
     *         If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify
     *         <code>ContainerName</code> and <code>ContainerPort</code>.
     *         </p>
     *         <p>
     *         If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must
     *         specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not
     *         both.
     */
    public final Integer containerPort() {
        return containerPort;
    }

    /**
     * <p>
     * The port value to use for a service discovery service that specifies an SRV record. This field can be used if
     * both the <code>awsvpc</code>awsvpc network mode and SRV records are used.
     * </p>
     * 
     * @return The port value to use for a service discovery service that specifies an SRV record. This field can be
     *         used if both the <code>awsvpc</code>awsvpc network mode and SRV records are used.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The ARN of the service registry.
     * </p>
     * 
     * @return The ARN of the service registry.
     */
    public final String registryArn() {
        return registryArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(registryArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceServiceRegistriesDetails)) {
            return false;
        }
        AwsEcsServiceServiceRegistriesDetails other = (AwsEcsServiceServiceRegistriesDetails) obj;
        return Objects.equals(containerName(), other.containerName()) && Objects.equals(containerPort(), other.containerPort())
                && Objects.equals(port(), other.port()) && Objects.equals(registryArn(), other.registryArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServiceServiceRegistriesDetails").add("ContainerName", containerName())
                .add("ContainerPort", containerPort()).add("Port", port()).add("RegistryArn", registryArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "ContainerPort":
            return Optional.ofNullable(clazz.cast(containerPort()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "RegistryArn":
            return Optional.ofNullable(clazz.cast(registryArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServiceServiceRegistriesDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceServiceRegistriesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsServiceServiceRegistriesDetails> {
        /**
         * <p>
         * The container name value to use for the service discovery service.
         * </p>
         * <p>
         * If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify
         * <code>ContainerName</code> and <code>ContainerPort</code>.
         * </p>
         * <p>
         * If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify
         * either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.
         * </p>
         * 
         * @param containerName
         *        The container name value to use for the service discovery service.</p>
         *        <p>
         *        If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must
         *        specify <code>ContainerName</code> and <code>ContainerPort</code>.
         *        </p>
         *        <p>
         *        If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must
         *        specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but
         *        not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The port value to use for the service discovery service.
         * </p>
         * <p>
         * If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must specify
         * <code>ContainerName</code> and <code>ContainerPort</code>.
         * </p>
         * <p>
         * If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must specify
         * either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but not both.
         * </p>
         * 
         * @param containerPort
         *        The port value to use for the service discovery service.</p>
         *        <p>
         *        If the task definition uses the <code>bridge</code> or <code>host</code> network mode, you must
         *        specify <code>ContainerName</code> and <code>ContainerPort</code>.
         *        </p>
         *        <p>
         *        If the task definition uses the <code>awsvpc</code> network mode and a type SRV DNS record, you must
         *        specify either <code>ContainerName</code> and <code>ContainerPort</code>, or <code>Port</code> , but
         *        not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPort(Integer containerPort);

        /**
         * <p>
         * The port value to use for a service discovery service that specifies an SRV record. This field can be used if
         * both the <code>awsvpc</code>awsvpc network mode and SRV records are used.
         * </p>
         * 
         * @param port
         *        The port value to use for a service discovery service that specifies an SRV record. This field can be
         *        used if both the <code>awsvpc</code>awsvpc network mode and SRV records are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The ARN of the service registry.
         * </p>
         * 
         * @param registryArn
         *        The ARN of the service registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryArn(String registryArn);
    }

    static final class BuilderImpl implements Builder {
        private String containerName;

        private Integer containerPort;

        private Integer port;

        private String registryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceServiceRegistriesDetails model) {
            containerName(model.containerName);
            containerPort(model.containerPort);
            port(model.port);
            registryArn(model.registryArn);
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Integer getContainerPort() {
            return containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getRegistryArn() {
            return registryArn;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        @Override
        public AwsEcsServiceServiceRegistriesDetails build() {
            return new AwsEcsServiceServiceRegistriesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
