/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the run command configuration for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsClusterConfigurationExecuteCommandConfigurationDetails.Builder, AwsEcsClusterConfigurationExecuteCommandConfigurationDetails> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsEcsClusterConfigurationExecuteCommandConfigurationDetails::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails> LOG_CONFIGURATION_FIELD = SdkField
            .<AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("LogConfiguration")
            .getter(getter(AwsEcsClusterConfigurationExecuteCommandConfigurationDetails::logConfiguration))
            .setter(setter(Builder::logConfiguration))
            .constructor(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final SdkField<String> LOGGING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Logging")
            .getter(getter(AwsEcsClusterConfigurationExecuteCommandConfigurationDetails::logging))
            .setter(setter(Builder::logging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logging").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            LOG_CONFIGURATION_FIELD, LOGGING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails logConfiguration;

    private final String logging;

    private AwsEcsClusterConfigurationExecuteCommandConfigurationDetails(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.logConfiguration = builder.logConfiguration;
        this.logging = builder.logging;
    }

    /**
     * <p>
     * The identifier of the KMS key that is used to encrypt the data between the local client and the container.
     * </p>
     * 
     * @return The identifier of the KMS key that is used to encrypt the data between the local client and the
     *         container.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The log configuration for the results of the run command actions. Required if <code>Logging</code> is
     * <code>NONE</code>.
     * </p>
     * 
     * @return The log configuration for the results of the run command actions. Required if <code>Logging</code> is
     *         <code>NONE</code>.
     */
    public final AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The log setting to use for redirecting logs for run command results.
     * </p>
     * 
     * @return The log setting to use for redirecting logs for run command results.
     */
    public final String logging() {
        return logging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsClusterConfigurationExecuteCommandConfigurationDetails)) {
            return false;
        }
        AwsEcsClusterConfigurationExecuteCommandConfigurationDetails other = (AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(logging(), other.logging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsClusterConfigurationExecuteCommandConfigurationDetails").add("KmsKeyId", kmsKeyId())
                .add("LogConfiguration", logConfiguration()).add("Logging", logging()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "Logging":
            return Optional.ofNullable(clazz.cast(logging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsClusterConfigurationExecuteCommandConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsClusterConfigurationExecuteCommandConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsClusterConfigurationExecuteCommandConfigurationDetails> {
        /**
         * <p>
         * The identifier of the KMS key that is used to encrypt the data between the local client and the container.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier of the KMS key that is used to encrypt the data between the local client and the
         *        container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The log configuration for the results of the run command actions. Required if <code>Logging</code> is
         * <code>NONE</code>.
         * </p>
         * 
         * @param logConfiguration
         *        The log configuration for the results of the run command actions. Required if <code>Logging</code> is
         *        <code>NONE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails logConfiguration);

        /**
         * <p>
         * The log configuration for the results of the run command actions. Required if <code>Logging</code> is
         * <code>NONE</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.Builder} avoiding the
         * need to create one manually via
         * {@link AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #logConfiguration(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on
         *        {@link AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails)
         */
        default Builder logConfiguration(
                Consumer<AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.Builder> logConfiguration) {
            return logConfiguration(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.builder()
                    .applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The log setting to use for redirecting logs for run command results.
         * </p>
         * 
         * @param logging
         *        The log setting to use for redirecting logs for run command results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(String logging);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails logConfiguration;

        private String logging;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsClusterConfigurationExecuteCommandConfigurationDetails model) {
            kmsKeyId(model.kmsKeyId);
            logConfiguration(model.logConfiguration);
            logging(model.logging);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(
                AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(
                AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getLogging() {
            return logging;
        }

        public final void setLogging(String logging) {
            this.logging = logging;
        }

        @Override
        public final Builder logging(String logging) {
            this.logging = logging;
            return this;
        }

        @Override
        public AwsEcsClusterConfigurationExecuteCommandConfigurationDetails build() {
            return new AwsEcsClusterConfigurationExecuteCommandConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
