/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status codes that cause an origin group to fail over.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.Builder, AwsCloudFrontDistributionOriginGroupFailoverStatusCodes> {
    private static final SdkField<List<Integer>> ITEMS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity").getter(getter(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, QUANTITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Integer> items;

    private final Integer quantity;

    private AwsCloudFrontDistributionOriginGroupFailoverStatusCodes(BuilderImpl builder) {
        this.items = builder.items;
        this.quantity = builder.quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of status code values that can cause a failover to the next origin.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return The list of status code values that can cause a failover to the next origin.
     */
    public final List<Integer> items() {
        return items;
    }

    /**
     * <p>
     * The number of status codes that can cause a failover.
     * </p>
     * 
     * @return The number of status codes that can cause a failover.
     */
    public final Integer quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginGroupFailoverStatusCodes)) {
            return false;
        }
        AwsCloudFrontDistributionOriginGroupFailoverStatusCodes other = (AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(quantity(), other.quantity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionOriginGroupFailoverStatusCodes")
                .add("Items", hasItems() ? items() : null).add("Quantity", quantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginGroupFailoverStatusCodes, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginGroupFailoverStatusCodes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOriginGroupFailoverStatusCodes> {
        /**
         * <p>
         * The list of status code values that can cause a failover to the next origin.
         * </p>
         * 
         * @param items
         *        The list of status code values that can cause a failover to the next origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Integer> items);

        /**
         * <p>
         * The list of status code values that can cause a failover to the next origin.
         * </p>
         * 
         * @param items
         *        The list of status code values that can cause a failover to the next origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Integer... items);

        /**
         * <p>
         * The number of status codes that can cause a failover.
         * </p>
         * 
         * @param quantity
         *        The number of status codes that can cause a failover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> items = DefaultSdkAutoConstructList.getInstance();

        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes model) {
            items(model.items);
            quantity(model.quantity);
        }

        public final Collection<Integer> getItems() {
            if (items instanceof SdkAutoConstructList) {
                return null;
            }
            return items;
        }

        public final void setItems(Collection<Integer> items) {
            this.items = AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemListCopier.copy(items);
        }

        @Override
        public final Builder items(Collection<Integer> items) {
            this.items = AwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Integer... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionOriginGroupFailoverStatusCodes build() {
            return new AwsCloudFrontDistributionOriginGroupFailoverStatusCodes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
