/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instances distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails.Builder, AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails> {
    private static final SdkField<String> ON_DEMAND_ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OnDemandAllocationStrategy")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails::onDemandAllocationStrategy))
            .setter(setter(Builder::onDemandAllocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandAllocationStrategy").build())
            .build();

    private static final SdkField<Integer> ON_DEMAND_BASE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandBaseCapacity")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails::onDemandBaseCapacity))
            .setter(setter(Builder::onDemandBaseCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandBaseCapacity").build())
            .build();

    private static final SdkField<Integer> ON_DEMAND_PERCENTAGE_ABOVE_BASE_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandPercentageAboveBaseCapacity")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails::onDemandPercentageAboveBaseCapacity))
            .setter(setter(Builder::onDemandPercentageAboveBaseCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OnDemandPercentageAboveBaseCapacity").build()).build();

    private static final SdkField<String> SPOT_ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpotAllocationStrategy")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails::spotAllocationStrategy))
            .setter(setter(Builder::spotAllocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotAllocationStrategy").build())
            .build();

    private static final SdkField<Integer> SPOT_INSTANCE_POOLS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SpotInstancePools")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails::spotInstancePools))
            .setter(setter(Builder::spotInstancePools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstancePools").build()).build();

    private static final SdkField<String> SPOT_MAX_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpotMaxPrice")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails::spotMaxPrice))
            .setter(setter(Builder::spotMaxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotMaxPrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ON_DEMAND_ALLOCATION_STRATEGY_FIELD, ON_DEMAND_BASE_CAPACITY_FIELD, ON_DEMAND_PERCENTAGE_ABOVE_BASE_CAPACITY_FIELD,
            SPOT_ALLOCATION_STRATEGY_FIELD, SPOT_INSTANCE_POOLS_FIELD, SPOT_MAX_PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String onDemandAllocationStrategy;

    private final Integer onDemandBaseCapacity;

    private final Integer onDemandPercentageAboveBaseCapacity;

    private final String spotAllocationStrategy;

    private final Integer spotInstancePools;

    private final String spotMaxPrice;

    private AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails(BuilderImpl builder) {
        this.onDemandAllocationStrategy = builder.onDemandAllocationStrategy;
        this.onDemandBaseCapacity = builder.onDemandBaseCapacity;
        this.onDemandPercentageAboveBaseCapacity = builder.onDemandPercentageAboveBaseCapacity;
        this.spotAllocationStrategy = builder.spotAllocationStrategy;
        this.spotInstancePools = builder.spotInstancePools;
        this.spotMaxPrice = builder.spotMaxPrice;
    }

    /**
     * <p>
     * How to allocate instance types to fulfill On-Demand capacity. The valid value is <code>prioritized</code>.
     * </p>
     * 
     * @return How to allocate instance types to fulfill On-Demand capacity. The valid value is <code>prioritized</code>
     *         .
     */
    public final String onDemandAllocationStrategy() {
        return onDemandAllocationStrategy;
    }

    /**
     * <p>
     * The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances.
     * </p>
     * 
     * @return The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances.
     */
    public final Integer onDemandBaseCapacity() {
        return onDemandBaseCapacity;
    }

    /**
     * <p>
     * The percentage of On-Demand Instances and Spot Instances for additional capacity beyond
     * <code>OnDemandBaseCapacity</code>.
     * </p>
     * 
     * @return The percentage of On-Demand Instances and Spot Instances for additional capacity beyond
     *         <code>OnDemandBaseCapacity</code>.
     */
    public final Integer onDemandPercentageAboveBaseCapacity() {
        return onDemandPercentageAboveBaseCapacity;
    }

    /**
     * <p>
     * How to allocate instances across Spot Instance pools. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>lowest-price</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>capacity-optimized</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>capacity-optimized-prioritized</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return How to allocate instances across Spot Instance pools. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>lowest-price</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>capacity-optimized</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>capacity-optimized-prioritized</code>
     *         </p>
     *         </li>
     */
    public final String spotAllocationStrategy() {
        return spotAllocationStrategy;
    }

    /**
     * <p>
     * The number of Spot Instance pools across which to allocate your Spot Instances.
     * </p>
     * 
     * @return The number of Spot Instance pools across which to allocate your Spot Instances.
     */
    public final Integer spotInstancePools() {
        return spotInstancePools;
    }

    /**
     * <p>
     * The maximum price per unit hour that you are willing to pay for a Spot Instance.
     * </p>
     * 
     * @return The maximum price per unit hour that you are willing to pay for a Spot Instance.
     */
    public final String spotMaxPrice() {
        return spotMaxPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(onDemandAllocationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandBaseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandPercentageAboveBaseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(spotAllocationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstancePools());
        hashCode = 31 * hashCode + Objects.hashCode(spotMaxPrice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails)) {
            return false;
        }
        AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails other = (AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) obj;
        return Objects.equals(onDemandAllocationStrategy(), other.onDemandAllocationStrategy())
                && Objects.equals(onDemandBaseCapacity(), other.onDemandBaseCapacity())
                && Objects.equals(onDemandPercentageAboveBaseCapacity(), other.onDemandPercentageAboveBaseCapacity())
                && Objects.equals(spotAllocationStrategy(), other.spotAllocationStrategy())
                && Objects.equals(spotInstancePools(), other.spotInstancePools())
                && Objects.equals(spotMaxPrice(), other.spotMaxPrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails")
                .add("OnDemandAllocationStrategy", onDemandAllocationStrategy())
                .add("OnDemandBaseCapacity", onDemandBaseCapacity())
                .add("OnDemandPercentageAboveBaseCapacity", onDemandPercentageAboveBaseCapacity())
                .add("SpotAllocationStrategy", spotAllocationStrategy()).add("SpotInstancePools", spotInstancePools())
                .add("SpotMaxPrice", spotMaxPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OnDemandAllocationStrategy":
            return Optional.ofNullable(clazz.cast(onDemandAllocationStrategy()));
        case "OnDemandBaseCapacity":
            return Optional.ofNullable(clazz.cast(onDemandBaseCapacity()));
        case "OnDemandPercentageAboveBaseCapacity":
            return Optional.ofNullable(clazz.cast(onDemandPercentageAboveBaseCapacity()));
        case "SpotAllocationStrategy":
            return Optional.ofNullable(clazz.cast(spotAllocationStrategy()));
        case "SpotInstancePools":
            return Optional.ofNullable(clazz.cast(spotInstancePools()));
        case "SpotMaxPrice":
            return Optional.ofNullable(clazz.cast(spotMaxPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails> {
        /**
         * <p>
         * How to allocate instance types to fulfill On-Demand capacity. The valid value is <code>prioritized</code>.
         * </p>
         * 
         * @param onDemandAllocationStrategy
         *        How to allocate instance types to fulfill On-Demand capacity. The valid value is
         *        <code>prioritized</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandAllocationStrategy(String onDemandAllocationStrategy);

        /**
         * <p>
         * The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances.
         * </p>
         * 
         * @param onDemandBaseCapacity
         *        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandBaseCapacity(Integer onDemandBaseCapacity);

        /**
         * <p>
         * The percentage of On-Demand Instances and Spot Instances for additional capacity beyond
         * <code>OnDemandBaseCapacity</code>.
         * </p>
         * 
         * @param onDemandPercentageAboveBaseCapacity
         *        The percentage of On-Demand Instances and Spot Instances for additional capacity beyond
         *        <code>OnDemandBaseCapacity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity);

        /**
         * <p>
         * How to allocate instances across Spot Instance pools. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>lowest-price</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-optimized</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-optimized-prioritized</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param spotAllocationStrategy
         *        How to allocate instances across Spot Instance pools. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>lowest-price</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-optimized</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-optimized-prioritized</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotAllocationStrategy(String spotAllocationStrategy);

        /**
         * <p>
         * The number of Spot Instance pools across which to allocate your Spot Instances.
         * </p>
         * 
         * @param spotInstancePools
         *        The number of Spot Instance pools across which to allocate your Spot Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstancePools(Integer spotInstancePools);

        /**
         * <p>
         * The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * </p>
         * 
         * @param spotMaxPrice
         *        The maximum price per unit hour that you are willing to pay for a Spot Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotMaxPrice(String spotMaxPrice);
    }

    static final class BuilderImpl implements Builder {
        private String onDemandAllocationStrategy;

        private Integer onDemandBaseCapacity;

        private Integer onDemandPercentageAboveBaseCapacity;

        private String spotAllocationStrategy;

        private Integer spotInstancePools;

        private String spotMaxPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails model) {
            onDemandAllocationStrategy(model.onDemandAllocationStrategy);
            onDemandBaseCapacity(model.onDemandBaseCapacity);
            onDemandPercentageAboveBaseCapacity(model.onDemandPercentageAboveBaseCapacity);
            spotAllocationStrategy(model.spotAllocationStrategy);
            spotInstancePools(model.spotInstancePools);
            spotMaxPrice(model.spotMaxPrice);
        }

        public final String getOnDemandAllocationStrategy() {
            return onDemandAllocationStrategy;
        }

        public final void setOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
        }

        @Override
        public final Builder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
            return this;
        }

        public final Integer getOnDemandBaseCapacity() {
            return onDemandBaseCapacity;
        }

        public final void setOnDemandBaseCapacity(Integer onDemandBaseCapacity) {
            this.onDemandBaseCapacity = onDemandBaseCapacity;
        }

        @Override
        public final Builder onDemandBaseCapacity(Integer onDemandBaseCapacity) {
            this.onDemandBaseCapacity = onDemandBaseCapacity;
            return this;
        }

        public final Integer getOnDemandPercentageAboveBaseCapacity() {
            return onDemandPercentageAboveBaseCapacity;
        }

        public final void setOnDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity) {
            this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
        }

        @Override
        public final Builder onDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity) {
            this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
            return this;
        }

        public final String getSpotAllocationStrategy() {
            return spotAllocationStrategy;
        }

        public final void setSpotAllocationStrategy(String spotAllocationStrategy) {
            this.spotAllocationStrategy = spotAllocationStrategy;
        }

        @Override
        public final Builder spotAllocationStrategy(String spotAllocationStrategy) {
            this.spotAllocationStrategy = spotAllocationStrategy;
            return this;
        }

        public final Integer getSpotInstancePools() {
            return spotInstancePools;
        }

        public final void setSpotInstancePools(Integer spotInstancePools) {
            this.spotInstancePools = spotInstancePools;
        }

        @Override
        public final Builder spotInstancePools(Integer spotInstancePools) {
            this.spotInstancePools = spotInstancePools;
            return this;
        }

        public final String getSpotMaxPrice() {
            return spotMaxPrice;
        }

        public final void setSpotMaxPrice(String spotMaxPrice) {
            this.spotMaxPrice = spotMaxPrice;
        }

        @Override
        public final Builder spotMaxPrice(String spotMaxPrice) {
            this.spotMaxPrice = spotMaxPrice;
            return this;
        }

        @Override
        public AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails build() {
            return new AwsAutoScalingAutoScalingGroupMixedInstancesPolicyInstancesDistributionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
