/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Member;
import software.amazon.awssdk.services.securityhub.model.MemberListCopier;
import software.amazon.awssdk.services.securityhub.model.Result;
import software.amazon.awssdk.services.securityhub.model.ResultListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMembersResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetMembersResponse> {
    private static final SdkField<List<Member>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(GetMembersResponse.getter(GetMembersResponse::members)).setter(GetMembersResponse.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Member::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Result>> UNPROCESSED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAccounts").getter(GetMembersResponse.getter(GetMembersResponse::unprocessedAccounts)).setter(GetMembersResponse.setter(Builder::unprocessedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Result::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD, UNPROCESSED_ACCOUNTS_FIELD));
    private final List<Member> members;
    private final List<Result> unprocessedAccounts;

    private GetMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<Member> members() {
        return this.members;
    }

    public final boolean hasUnprocessedAccounts() {
        return this.unprocessedAccounts != null && !(this.unprocessedAccounts instanceof SdkAutoConstructList);
    }

    public final List<Result> unprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMembersResponse)) {
            return false;
        }
        GetMembersResponse other = (GetMembersResponse)((Object)obj);
        return this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && this.hasUnprocessedAccounts() == other.hasUnprocessedAccounts() && Objects.equals(this.unprocessedAccounts(), other.unprocessedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"GetMembersResponse").add("Members", this.hasMembers() ? this.members() : null).add("UnprocessedAccounts", this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "UnprocessedAccounts": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMembersResponse, T> g) {
        return obj -> g.apply((GetMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<Member> members = DefaultSdkAutoConstructList.getInstance();
        private List<Result> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMembersResponse model) {
            super(model);
            this.members(model.members);
            this.unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<Member.Builder> getMembers() {
            List<Member.Builder> result = MemberListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<Member.BuilderImpl> members) {
            this.members = MemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<Member> members) {
            this.members = MemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Member ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<Member.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (Member)((Member.Builder)Member.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Result.Builder> getUnprocessedAccounts() {
            List<Result.Builder> result = ResultListCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<Result.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = ResultListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public final Builder unprocessedAccounts(Collection<Result> unprocessedAccounts) {
            this.unprocessedAccounts = ResultListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Result ... unprocessedAccounts) {
            this.unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<Result.Builder> ... unprocessedAccounts) {
            this.unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> (Result)((Result.Builder)Result.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMembersResponse build() {
            return new GetMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMembersResponse> {
        public Builder members(Collection<Member> var1);

        public Builder members(Member ... var1);

        public Builder members(Consumer<Member.Builder> ... var1);

        public Builder unprocessedAccounts(Collection<Result> var1);

        public Builder unprocessedAccounts(Result ... var1);

        public Builder unprocessedAccounts(Consumer<Result.Builder> ... var1);
    }
}

