/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the vulnerabilities found in your Lambda function code. This field pertains to findings that
 * Security Hub receives from Amazon Inspector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VulnerabilityCodeVulnerabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<VulnerabilityCodeVulnerabilities.Builder, VulnerabilityCodeVulnerabilities> {
    private static final SdkField<List<String>> CWES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Cwes")
            .getter(getter(VulnerabilityCodeVulnerabilities::cwes))
            .setter(setter(Builder::cwes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cwes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CodeVulnerabilitiesFilePath> FILE_PATH_FIELD = SdkField
            .<CodeVulnerabilitiesFilePath> builder(MarshallingType.SDK_POJO).memberName("FilePath")
            .getter(getter(VulnerabilityCodeVulnerabilities::filePath)).setter(setter(Builder::filePath))
            .constructor(CodeVulnerabilitiesFilePath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(VulnerabilityCodeVulnerabilities::sourceArn))
            .setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CWES_FIELD, FILE_PATH_FIELD,
            SOURCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> cwes;

    private final CodeVulnerabilitiesFilePath filePath;

    private final String sourceArn;

    private VulnerabilityCodeVulnerabilities(BuilderImpl builder) {
        this.cwes = builder.cwes;
        this.filePath = builder.filePath;
        this.sourceArn = builder.sourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cwes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCwes() {
        return cwes != null && !(cwes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCwes} method.
     * </p>
     * 
     * @return The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
     */
    public final List<String> cwes() {
        return cwes;
    }

    /**
     * <p>
     * Provides details about where a code vulnerability is located in your Lambda function.
     * </p>
     * 
     * @return Provides details about where a code vulnerability is located in your Lambda function.
     */
    public final CodeVulnerabilitiesFilePath filePath() {
        return filePath;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCwes() ? cwes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VulnerabilityCodeVulnerabilities)) {
            return false;
        }
        VulnerabilityCodeVulnerabilities other = (VulnerabilityCodeVulnerabilities) obj;
        return hasCwes() == other.hasCwes() && Objects.equals(cwes(), other.cwes())
                && Objects.equals(filePath(), other.filePath()) && Objects.equals(sourceArn(), other.sourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VulnerabilityCodeVulnerabilities").add("Cwes", hasCwes() ? cwes() : null)
                .add("FilePath", filePath()).add("SourceArn", sourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cwes":
            return Optional.ofNullable(clazz.cast(cwes()));
        case "FilePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VulnerabilityCodeVulnerabilities, T> g) {
        return obj -> g.apply((VulnerabilityCodeVulnerabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VulnerabilityCodeVulnerabilities> {
        /**
         * <p>
         * The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
         * </p>
         * 
         * @param cwes
         *        The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwes(Collection<String> cwes);

        /**
         * <p>
         * The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
         * </p>
         * 
         * @param cwes
         *        The Common Weakness Enumeration (CWE) item associated with the detected code vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwes(String... cwes);

        /**
         * <p>
         * Provides details about where a code vulnerability is located in your Lambda function.
         * </p>
         * 
         * @param filePath
         *        Provides details about where a code vulnerability is located in your Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(CodeVulnerabilitiesFilePath filePath);

        /**
         * <p>
         * Provides details about where a code vulnerability is located in your Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeVulnerabilitiesFilePath.Builder}
         * avoiding the need to create one manually via {@link CodeVulnerabilitiesFilePath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeVulnerabilitiesFilePath.Builder#build()} is called
         * immediately and its result is passed to {@link #filePath(CodeVulnerabilitiesFilePath)}.
         * 
         * @param filePath
         *        a consumer that will call methods on {@link CodeVulnerabilitiesFilePath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filePath(CodeVulnerabilitiesFilePath)
         */
        default Builder filePath(Consumer<CodeVulnerabilitiesFilePath.Builder> filePath) {
            return filePath(CodeVulnerabilitiesFilePath.builder().applyMutation(filePath).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the Lambda layer in which the code vulnerability is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cwes = DefaultSdkAutoConstructList.getInstance();

        private CodeVulnerabilitiesFilePath filePath;

        private String sourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VulnerabilityCodeVulnerabilities model) {
            cwes(model.cwes);
            filePath(model.filePath);
            sourceArn(model.sourceArn);
        }

        public final Collection<String> getCwes() {
            if (cwes instanceof SdkAutoConstructList) {
                return null;
            }
            return cwes;
        }

        public final void setCwes(Collection<String> cwes) {
            this.cwes = TypeListCopier.copy(cwes);
        }

        @Override
        public final Builder cwes(Collection<String> cwes) {
            this.cwes = TypeListCopier.copy(cwes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cwes(String... cwes) {
            cwes(Arrays.asList(cwes));
            return this;
        }

        public final CodeVulnerabilitiesFilePath.Builder getFilePath() {
            return filePath != null ? filePath.toBuilder() : null;
        }

        public final void setFilePath(CodeVulnerabilitiesFilePath.BuilderImpl filePath) {
            this.filePath = filePath != null ? filePath.build() : null;
        }

        @Override
        public final Builder filePath(CodeVulnerabilitiesFilePath filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        @Override
        public VulnerabilityCodeVulnerabilities build() {
            return new VulnerabilityCodeVulnerabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
