/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A range of ports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortRange implements SdkPojo, Serializable, ToCopyableBuilder<PortRange.Builder, PortRange> {
    private static final SdkField<Integer> BEGIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Begin")
            .getter(getter(PortRange::begin)).setter(setter(Builder::begin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Begin").build()).build();

    private static final SdkField<Integer> END_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("End")
            .getter(getter(PortRange::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_FIELD, END_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer begin;

    private final Integer end;

    private PortRange(BuilderImpl builder) {
        this.begin = builder.begin;
        this.end = builder.end;
    }

    /**
     * <p>
     * The first port in the port range.
     * </p>
     * 
     * @return The first port in the port range.
     */
    public final Integer begin() {
        return begin;
    }

    /**
     * <p>
     * The last port in the port range.
     * </p>
     * 
     * @return The last port in the port range.
     */
    public final Integer end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(begin());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortRange)) {
            return false;
        }
        PortRange other = (PortRange) obj;
        return Objects.equals(begin(), other.begin()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortRange").add("Begin", begin()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Begin":
            return Optional.ofNullable(clazz.cast(begin()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortRange, T> g) {
        return obj -> g.apply((PortRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortRange> {
        /**
         * <p>
         * The first port in the port range.
         * </p>
         * 
         * @param begin
         *        The first port in the port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder begin(Integer begin);

        /**
         * <p>
         * The last port in the port range.
         * </p>
         * 
         * @param end
         *        The last port in the port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Integer end);
    }

    static final class BuilderImpl implements Builder {
        private Integer begin;

        private Integer end;

        private BuilderImpl() {
        }

        private BuilderImpl(PortRange model) {
            begin(model.begin);
            end(model.end);
        }

        public final Integer getBegin() {
            return begin;
        }

        public final void setBegin(Integer begin) {
            this.begin = begin;
        }

        @Override
        public final Builder begin(Integer begin) {
            this.begin = begin;
            return this;
        }

        public final Integer getEnd() {
            return end;
        }

        public final void setEnd(Integer end) {
            this.end = end;
        }

        @Override
        public final Builder end(Integer end) {
            this.end = end;
            return this;
        }

        @Override
        public PortRange build() {
            return new PortRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
