/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAutomationRulesResponse extends SecurityHubResponse implements
        ToCopyableBuilder<ListAutomationRulesResponse.Builder, ListAutomationRulesResponse> {
    private static final SdkField<List<AutomationRulesMetadata>> AUTOMATION_RULES_METADATA_FIELD = SdkField
            .<List<AutomationRulesMetadata>> builder(MarshallingType.LIST)
            .memberName("AutomationRulesMetadata")
            .getter(getter(ListAutomationRulesResponse::automationRulesMetadata))
            .setter(setter(Builder::automationRulesMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationRulesMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomationRulesMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomationRulesMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAutomationRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATION_RULES_METADATA_FIELD, NEXT_TOKEN_FIELD));

    private final List<AutomationRulesMetadata> automationRulesMetadata;

    private final String nextToken;

    private ListAutomationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.automationRulesMetadata = builder.automationRulesMetadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutomationRulesMetadata property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutomationRulesMetadata() {
        return automationRulesMetadata != null && !(automationRulesMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata for rules in the calling account. The response includes rules with a <code>RuleStatus</code> of
     * <code>ENABLED</code> and <code>DISABLED</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutomationRulesMetadata} method.
     * </p>
     * 
     * @return Metadata for rules in the calling account. The response includes rules with a <code>RuleStatus</code> of
     *         <code>ENABLED</code> and <code>DISABLED</code>.
     */
    public final List<AutomationRulesMetadata> automationRulesMetadata() {
        return automationRulesMetadata;
    }

    /**
     * <p>
     * A pagination token for the response.
     * </p>
     * 
     * @return A pagination token for the response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAutomationRulesMetadata() ? automationRulesMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationRulesResponse)) {
            return false;
        }
        ListAutomationRulesResponse other = (ListAutomationRulesResponse) obj;
        return hasAutomationRulesMetadata() == other.hasAutomationRulesMetadata()
                && Objects.equals(automationRulesMetadata(), other.automationRulesMetadata())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAutomationRulesResponse")
                .add("AutomationRulesMetadata", hasAutomationRulesMetadata() ? automationRulesMetadata() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationRulesMetadata":
            return Optional.ofNullable(clazz.cast(automationRulesMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationRulesResponse, T> g) {
        return obj -> g.apply((ListAutomationRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAutomationRulesResponse> {
        /**
         * <p>
         * Metadata for rules in the calling account. The response includes rules with a <code>RuleStatus</code> of
         * <code>ENABLED</code> and <code>DISABLED</code>.
         * </p>
         * 
         * @param automationRulesMetadata
         *        Metadata for rules in the calling account. The response includes rules with a <code>RuleStatus</code>
         *        of <code>ENABLED</code> and <code>DISABLED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationRulesMetadata(Collection<AutomationRulesMetadata> automationRulesMetadata);

        /**
         * <p>
         * Metadata for rules in the calling account. The response includes rules with a <code>RuleStatus</code> of
         * <code>ENABLED</code> and <code>DISABLED</code>.
         * </p>
         * 
         * @param automationRulesMetadata
         *        Metadata for rules in the calling account. The response includes rules with a <code>RuleStatus</code>
         *        of <code>ENABLED</code> and <code>DISABLED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationRulesMetadata(AutomationRulesMetadata... automationRulesMetadata);

        /**
         * <p>
         * Metadata for rules in the calling account. The response includes rules with a <code>RuleStatus</code> of
         * <code>ENABLED</code> and <code>DISABLED</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesMetadata.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #automationRulesMetadata(List<AutomationRulesMetadata>)}.
         * 
         * @param automationRulesMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AutomationRulesMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automationRulesMetadata(java.util.Collection<AutomationRulesMetadata>)
         */
        Builder automationRulesMetadata(Consumer<AutomationRulesMetadata.Builder>... automationRulesMetadata);

        /**
         * <p>
         * A pagination token for the response.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<AutomationRulesMetadata> automationRulesMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationRulesResponse model) {
            super(model);
            automationRulesMetadata(model.automationRulesMetadata);
            nextToken(model.nextToken);
        }

        public final List<AutomationRulesMetadata.Builder> getAutomationRulesMetadata() {
            List<AutomationRulesMetadata.Builder> result = AutomationRulesMetadataListCopier
                    .copyToBuilder(this.automationRulesMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomationRulesMetadata(Collection<AutomationRulesMetadata.BuilderImpl> automationRulesMetadata) {
            this.automationRulesMetadata = AutomationRulesMetadataListCopier.copyFromBuilder(automationRulesMetadata);
        }

        @Override
        public final Builder automationRulesMetadata(Collection<AutomationRulesMetadata> automationRulesMetadata) {
            this.automationRulesMetadata = AutomationRulesMetadataListCopier.copy(automationRulesMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationRulesMetadata(AutomationRulesMetadata... automationRulesMetadata) {
            automationRulesMetadata(Arrays.asList(automationRulesMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automationRulesMetadata(Consumer<AutomationRulesMetadata.Builder>... automationRulesMetadata) {
            automationRulesMetadata(Stream.of(automationRulesMetadata)
                    .map(c -> AutomationRulesMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomationRulesResponse build() {
            return new ListAutomationRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
