/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStandardsControlsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<DescribeStandardsControlsResponse.Builder, DescribeStandardsControlsResponse> {
    private static final SdkField<List<StandardsControl>> CONTROLS_FIELD = SdkField
            .<List<StandardsControl>> builder(MarshallingType.LIST)
            .memberName("Controls")
            .getter(getter(DescribeStandardsControlsResponse::controls))
            .setter(setter(Builder::controls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Controls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StandardsControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(StandardsControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeStandardsControlsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROLS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StandardsControl> controls;

    private final String nextToken;

    private DescribeStandardsControlsResponse(BuilderImpl builder) {
        super(builder);
        this.controls = builder.controls;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Controls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasControls() {
        return controls != null && !(controls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security standards controls.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControls} method.
     * </p>
     * 
     * @return A list of security standards controls.
     */
    public final List<StandardsControl> controls() {
        return controls;
    }

    /**
     * <p>
     * The pagination token to use to request the next page of results.
     * </p>
     * 
     * @return The pagination token to use to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasControls() ? controls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStandardsControlsResponse)) {
            return false;
        }
        DescribeStandardsControlsResponse other = (DescribeStandardsControlsResponse) obj;
        return hasControls() == other.hasControls() && Objects.equals(controls(), other.controls())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStandardsControlsResponse").add("Controls", hasControls() ? controls() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Controls":
            return Optional.ofNullable(clazz.cast(controls()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStandardsControlsResponse, T> g) {
        return obj -> g.apply((DescribeStandardsControlsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStandardsControlsResponse> {
        /**
         * <p>
         * A list of security standards controls.
         * </p>
         * 
         * @param controls
         *        A list of security standards controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controls(Collection<StandardsControl> controls);

        /**
         * <p>
         * A list of security standards controls.
         * </p>
         * 
         * @param controls
         *        A list of security standards controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controls(StandardsControl... controls);

        /**
         * <p>
         * A list of security standards controls.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StandardsControl.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityhub.model.StandardsControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StandardsControl.Builder#build()} is called
         * immediately and its result is passed to {@link #controls(List<StandardsControl>)}.
         * 
         * @param controls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StandardsControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controls(java.util.Collection<StandardsControl>)
         */
        Builder controls(Consumer<StandardsControl.Builder>... controls);

        /**
         * <p>
         * The pagination token to use to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<StandardsControl> controls = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStandardsControlsResponse model) {
            super(model);
            controls(model.controls);
            nextToken(model.nextToken);
        }

        public final List<StandardsControl.Builder> getControls() {
            List<StandardsControl.Builder> result = StandardsControlsCopier.copyToBuilder(this.controls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControls(Collection<StandardsControl.BuilderImpl> controls) {
            this.controls = StandardsControlsCopier.copyFromBuilder(controls);
        }

        @Override
        public final Builder controls(Collection<StandardsControl> controls) {
            this.controls = StandardsControlsCopier.copy(controls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(StandardsControl... controls) {
            controls(Arrays.asList(controls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(Consumer<StandardsControl.Builder>... controls) {
            controls(Stream.of(controls).map(c -> StandardsControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStandardsControlsResponse build() {
            return new DescribeStandardsControlsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
