/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Boolean filter for querying findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BooleanFilter implements SdkPojo, Serializable, ToCopyableBuilder<BooleanFilter.Builder, BooleanFilter> {
    private static final SdkField<Boolean> VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Value")
            .getter(getter(BooleanFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean value;

    private BooleanFilter(BuilderImpl builder) {
        this.value = builder.value;
    }

    /**
     * <p>
     * The value of the boolean.
     * </p>
     * 
     * @return The value of the boolean.
     */
    public final Boolean value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanFilter)) {
            return false;
        }
        BooleanFilter other = (BooleanFilter) obj;
        return Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BooleanFilter").add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BooleanFilter, T> g) {
        return obj -> g.apply((BooleanFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BooleanFilter> {
        /**
         * <p>
         * The value of the boolean.
         * </p>
         * 
         * @param value
         *        The value of the boolean.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Boolean value);
    }

    static final class BuilderImpl implements Builder {
        private Boolean value;

        private BuilderImpl() {
        }

        private BuilderImpl(BooleanFilter model) {
            value(model.value);
        }

        public final Boolean getValue() {
            return value;
        }

        public final void setValue(Boolean value) {
            this.value = value;
        }

        @Override
        public final Builder value(Boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public BooleanFilter build() {
            return new BooleanFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
