/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateAutomationRulesResponse extends SecurityHubResponse implements
        ToCopyableBuilder<BatchUpdateAutomationRulesResponse.Builder, BatchUpdateAutomationRulesResponse> {
    private static final SdkField<List<String>> PROCESSED_AUTOMATION_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProcessedAutomationRules")
            .getter(getter(BatchUpdateAutomationRulesResponse::processedAutomationRules))
            .setter(setter(Builder::processedAutomationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedAutomationRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedAutomationRule>> UNPROCESSED_AUTOMATION_RULES_FIELD = SdkField
            .<List<UnprocessedAutomationRule>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAutomationRules")
            .getter(getter(BatchUpdateAutomationRulesResponse::unprocessedAutomationRules))
            .setter(setter(Builder::unprocessedAutomationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAutomationRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAutomationRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAutomationRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PROCESSED_AUTOMATION_RULES_FIELD, UNPROCESSED_AUTOMATION_RULES_FIELD));

    private final List<String> processedAutomationRules;

    private final List<UnprocessedAutomationRule> unprocessedAutomationRules;

    private BatchUpdateAutomationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.processedAutomationRules = builder.processedAutomationRules;
        this.unprocessedAutomationRules = builder.unprocessedAutomationRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessedAutomationRules property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProcessedAutomationRules() {
        return processedAutomationRules != null && !(processedAutomationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of properly processed rule ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessedAutomationRules} method.
     * </p>
     * 
     * @return A list of properly processed rule ARNs.
     */
    public final List<String> processedAutomationRules() {
        return processedAutomationRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedAutomationRules property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnprocessedAutomationRules() {
        return unprocessedAutomationRules != null && !(unprocessedAutomationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>. This
     * parameter tells you which automation rules the request didn't update and why.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedAutomationRules} method.
     * </p>
     * 
     * @return A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>.
     *         This parameter tells you which automation rules the request didn't update and why.
     */
    public final List<UnprocessedAutomationRule> unprocessedAutomationRules() {
        return unprocessedAutomationRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessedAutomationRules() ? processedAutomationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAutomationRules() ? unprocessedAutomationRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateAutomationRulesResponse)) {
            return false;
        }
        BatchUpdateAutomationRulesResponse other = (BatchUpdateAutomationRulesResponse) obj;
        return hasProcessedAutomationRules() == other.hasProcessedAutomationRules()
                && Objects.equals(processedAutomationRules(), other.processedAutomationRules())
                && hasUnprocessedAutomationRules() == other.hasUnprocessedAutomationRules()
                && Objects.equals(unprocessedAutomationRules(), other.unprocessedAutomationRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateAutomationRulesResponse")
                .add("ProcessedAutomationRules", hasProcessedAutomationRules() ? processedAutomationRules() : null)
                .add("UnprocessedAutomationRules", hasUnprocessedAutomationRules() ? unprocessedAutomationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessedAutomationRules":
            return Optional.ofNullable(clazz.cast(processedAutomationRules()));
        case "UnprocessedAutomationRules":
            return Optional.ofNullable(clazz.cast(unprocessedAutomationRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateAutomationRulesResponse, T> g) {
        return obj -> g.apply((BatchUpdateAutomationRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateAutomationRulesResponse> {
        /**
         * <p>
         * A list of properly processed rule ARNs.
         * </p>
         * 
         * @param processedAutomationRules
         *        A list of properly processed rule ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedAutomationRules(Collection<String> processedAutomationRules);

        /**
         * <p>
         * A list of properly processed rule ARNs.
         * </p>
         * 
         * @param processedAutomationRules
         *        A list of properly processed rule ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedAutomationRules(String... processedAutomationRules);

        /**
         * <p>
         * A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>.
         * This parameter tells you which automation rules the request didn't update and why.
         * </p>
         * 
         * @param unprocessedAutomationRules
         *        A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and
         *        <code>ErrorMessage</code>. This parameter tells you which automation rules the request didn't update
         *        and why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAutomationRules(Collection<UnprocessedAutomationRule> unprocessedAutomationRules);

        /**
         * <p>
         * A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>.
         * This parameter tells you which automation rules the request didn't update and why.
         * </p>
         * 
         * @param unprocessedAutomationRules
         *        A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and
         *        <code>ErrorMessage</code>. This parameter tells you which automation rules the request didn't update
         *        and why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAutomationRules(UnprocessedAutomationRule... unprocessedAutomationRules);

        /**
         * <p>
         * A list of objects containing <code>RuleArn</code>, <code>ErrorCode</code>, and <code>ErrorMessage</code>.
         * This parameter tells you which automation rules the request didn't update and why.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedAutomationRules(List<UnprocessedAutomationRule>)}.
         * 
         * @param unprocessedAutomationRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAutomationRules(java.util.Collection<UnprocessedAutomationRule>)
         */
        Builder unprocessedAutomationRules(Consumer<UnprocessedAutomationRule.Builder>... unprocessedAutomationRules);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<String> processedAutomationRules = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedAutomationRule> unprocessedAutomationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateAutomationRulesResponse model) {
            super(model);
            processedAutomationRules(model.processedAutomationRules);
            unprocessedAutomationRules(model.unprocessedAutomationRules);
        }

        public final Collection<String> getProcessedAutomationRules() {
            if (processedAutomationRules instanceof SdkAutoConstructList) {
                return null;
            }
            return processedAutomationRules;
        }

        public final void setProcessedAutomationRules(Collection<String> processedAutomationRules) {
            this.processedAutomationRules = AutomationRulesArnsListCopier.copy(processedAutomationRules);
        }

        @Override
        public final Builder processedAutomationRules(Collection<String> processedAutomationRules) {
            this.processedAutomationRules = AutomationRulesArnsListCopier.copy(processedAutomationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedAutomationRules(String... processedAutomationRules) {
            processedAutomationRules(Arrays.asList(processedAutomationRules));
            return this;
        }

        public final List<UnprocessedAutomationRule.Builder> getUnprocessedAutomationRules() {
            List<UnprocessedAutomationRule.Builder> result = UnprocessedAutomationRulesListCopier
                    .copyToBuilder(this.unprocessedAutomationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAutomationRules(
                Collection<UnprocessedAutomationRule.BuilderImpl> unprocessedAutomationRules) {
            this.unprocessedAutomationRules = UnprocessedAutomationRulesListCopier.copyFromBuilder(unprocessedAutomationRules);
        }

        @Override
        public final Builder unprocessedAutomationRules(Collection<UnprocessedAutomationRule> unprocessedAutomationRules) {
            this.unprocessedAutomationRules = UnprocessedAutomationRulesListCopier.copy(unprocessedAutomationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAutomationRules(UnprocessedAutomationRule... unprocessedAutomationRules) {
            unprocessedAutomationRules(Arrays.asList(unprocessedAutomationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAutomationRules(Consumer<UnprocessedAutomationRule.Builder>... unprocessedAutomationRules) {
            unprocessedAutomationRules(Stream.of(unprocessedAutomationRules)
                    .map(c -> UnprocessedAutomationRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateAutomationRulesResponse build() {
            return new BatchUpdateAutomationRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
