/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom response to send to the client. You can define a custom response for rule actions and default web ACL
 * actions that are set to block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafv2CustomResponseDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafv2CustomResponseDetails.Builder, AwsWafv2CustomResponseDetails> {
    private static final SdkField<String> CUSTOM_RESPONSE_BODY_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomResponseBodyKey").getter(getter(AwsWafv2CustomResponseDetails::customResponseBodyKey))
            .setter(setter(Builder::customResponseBodyKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomResponseBodyKey").build())
            .build();

    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResponseCode").getter(getter(AwsWafv2CustomResponseDetails::responseCode))
            .setter(setter(Builder::responseCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()).build();

    private static final SdkField<List<AwsWafv2CustomHttpHeader>> RESPONSE_HEADERS_FIELD = SdkField
            .<List<AwsWafv2CustomHttpHeader>> builder(MarshallingType.LIST)
            .memberName("ResponseHeaders")
            .getter(getter(AwsWafv2CustomResponseDetails::responseHeaders))
            .setter(setter(Builder::responseHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafv2CustomHttpHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafv2CustomHttpHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_RESPONSE_BODY_KEY_FIELD, RESPONSE_CODE_FIELD, RESPONSE_HEADERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customResponseBodyKey;

    private final Integer responseCode;

    private final List<AwsWafv2CustomHttpHeader> responseHeaders;

    private AwsWafv2CustomResponseDetails(BuilderImpl builder) {
        this.customResponseBodyKey = builder.customResponseBodyKey;
        this.responseCode = builder.responseCode;
        this.responseHeaders = builder.responseHeaders;
    }

    /**
     * <p>
     * References the response body that you want WAF to return to the web request client. You can define a custom
     * response for a rule action or a default web ACL action that is set to block.
     * </p>
     * 
     * @return References the response body that you want WAF to return to the web request client. You can define a
     *         custom response for a rule action or a default web ACL action that is set to block.
     */
    public final String customResponseBodyKey() {
        return customResponseBodyKey;
    }

    /**
     * <p>
     * The HTTP status code to return to the client. For a list of status codes that you can use in your custom
     * responses, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html">Supported
     * status codes for custom response</a> in the <i>WAF Developer Guide.</i>
     * </p>
     * 
     * @return The HTTP status code to return to the client. For a list of status codes that you can use in your custom
     *         responses, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html"
     *         >Supported status codes for custom response</a> in the <i>WAF Developer Guide.</i>
     */
    public final Integer responseCode() {
        return responseCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResponseHeaders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResponseHeaders() {
        return responseHeaders != null && !(responseHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The HTTP headers to use in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponseHeaders} method.
     * </p>
     * 
     * @return The HTTP headers to use in the response.
     */
    public final List<AwsWafv2CustomHttpHeader> responseHeaders() {
        return responseHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customResponseBodyKey());
        hashCode = 31 * hashCode + Objects.hashCode(responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseHeaders() ? responseHeaders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafv2CustomResponseDetails)) {
            return false;
        }
        AwsWafv2CustomResponseDetails other = (AwsWafv2CustomResponseDetails) obj;
        return Objects.equals(customResponseBodyKey(), other.customResponseBodyKey())
                && Objects.equals(responseCode(), other.responseCode()) && hasResponseHeaders() == other.hasResponseHeaders()
                && Objects.equals(responseHeaders(), other.responseHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafv2CustomResponseDetails").add("CustomResponseBodyKey", customResponseBodyKey())
                .add("ResponseCode", responseCode()).add("ResponseHeaders", hasResponseHeaders() ? responseHeaders() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomResponseBodyKey":
            return Optional.ofNullable(clazz.cast(customResponseBodyKey()));
        case "ResponseCode":
            return Optional.ofNullable(clazz.cast(responseCode()));
        case "ResponseHeaders":
            return Optional.ofNullable(clazz.cast(responseHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafv2CustomResponseDetails, T> g) {
        return obj -> g.apply((AwsWafv2CustomResponseDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafv2CustomResponseDetails> {
        /**
         * <p>
         * References the response body that you want WAF to return to the web request client. You can define a custom
         * response for a rule action or a default web ACL action that is set to block.
         * </p>
         * 
         * @param customResponseBodyKey
         *        References the response body that you want WAF to return to the web request client. You can define a
         *        custom response for a rule action or a default web ACL action that is set to block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customResponseBodyKey(String customResponseBodyKey);

        /**
         * <p>
         * The HTTP status code to return to the client. For a list of status codes that you can use in your custom
         * responses, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html"
         * >Supported status codes for custom response</a> in the <i>WAF Developer Guide.</i>
         * </p>
         * 
         * @param responseCode
         *        The HTTP status code to return to the client. For a list of status codes that you can use in your
         *        custom responses, see <a href=
         *        "https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html"
         *        >Supported status codes for custom response</a> in the <i>WAF Developer Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCode(Integer responseCode);

        /**
         * <p>
         * The HTTP headers to use in the response.
         * </p>
         * 
         * @param responseHeaders
         *        The HTTP headers to use in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseHeaders(Collection<AwsWafv2CustomHttpHeader> responseHeaders);

        /**
         * <p>
         * The HTTP headers to use in the response.
         * </p>
         * 
         * @param responseHeaders
         *        The HTTP headers to use in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseHeaders(AwsWafv2CustomHttpHeader... responseHeaders);

        /**
         * <p>
         * The HTTP headers to use in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader.Builder#build()} is called
         * immediately and its result is passed to {@link #responseHeaders(List<AwsWafv2CustomHttpHeader>)}.
         * 
         * @param responseHeaders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsWafv2CustomHttpHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseHeaders(java.util.Collection<AwsWafv2CustomHttpHeader>)
         */
        Builder responseHeaders(Consumer<AwsWafv2CustomHttpHeader.Builder>... responseHeaders);
    }

    static final class BuilderImpl implements Builder {
        private String customResponseBodyKey;

        private Integer responseCode;

        private List<AwsWafv2CustomHttpHeader> responseHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafv2CustomResponseDetails model) {
            customResponseBodyKey(model.customResponseBodyKey);
            responseCode(model.responseCode);
            responseHeaders(model.responseHeaders);
        }

        public final String getCustomResponseBodyKey() {
            return customResponseBodyKey;
        }

        public final void setCustomResponseBodyKey(String customResponseBodyKey) {
            this.customResponseBodyKey = customResponseBodyKey;
        }

        @Override
        public final Builder customResponseBodyKey(String customResponseBodyKey) {
            this.customResponseBodyKey = customResponseBodyKey;
            return this;
        }

        public final Integer getResponseCode() {
            return responseCode;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final List<AwsWafv2CustomHttpHeader.Builder> getResponseHeaders() {
            List<AwsWafv2CustomHttpHeader.Builder> result = AwsWafv2InsertHeadersListCopier.copyToBuilder(this.responseHeaders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponseHeaders(Collection<AwsWafv2CustomHttpHeader.BuilderImpl> responseHeaders) {
            this.responseHeaders = AwsWafv2InsertHeadersListCopier.copyFromBuilder(responseHeaders);
        }

        @Override
        public final Builder responseHeaders(Collection<AwsWafv2CustomHttpHeader> responseHeaders) {
            this.responseHeaders = AwsWafv2InsertHeadersListCopier.copy(responseHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseHeaders(AwsWafv2CustomHttpHeader... responseHeaders) {
            responseHeaders(Arrays.asList(responseHeaders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseHeaders(Consumer<AwsWafv2CustomHttpHeader.Builder>... responseHeaders) {
            responseHeaders(Stream.of(responseHeaders).map(c -> AwsWafv2CustomHttpHeader.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsWafv2CustomResponseDetails build() {
            return new AwsWafv2CustomResponseDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
