/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Changes to a DB instance that are currently pending.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbPendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbPendingModifiedValues.Builder, AwsRdsDbPendingModifiedValues> {
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbInstanceClass").getter(getter(AwsRdsDbPendingModifiedValues::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstanceClass").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(AwsRdsDbPendingModifiedValues::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(AwsRdsDbPendingModifiedValues::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AwsRdsDbPendingModifiedValues::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(AwsRdsDbPendingModifiedValues::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(AwsRdsDbPendingModifiedValues::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(AwsRdsDbPendingModifiedValues::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(AwsRdsDbPendingModifiedValues::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(AwsRdsDbPendingModifiedValues::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbInstanceIdentifier").getter(getter(AwsRdsDbPendingModifiedValues::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstanceIdentifier").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(AwsRdsDbPendingModifiedValues::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaCertificateIdentifier").getter(getter(AwsRdsDbPendingModifiedValues::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificateIdentifier").build())
            .build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbSubnetGroupName").getter(getter(AwsRdsDbPendingModifiedValues::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSubnetGroupName").build()).build();

    private static final SdkField<AwsRdsPendingCloudWatchLogsExports> PENDING_CLOUD_WATCH_LOGS_EXPORTS_FIELD = SdkField
            .<AwsRdsPendingCloudWatchLogsExports> builder(MarshallingType.SDK_POJO)
            .memberName("PendingCloudWatchLogsExports")
            .getter(getter(AwsRdsDbPendingModifiedValues::pendingCloudWatchLogsExports))
            .setter(setter(Builder::pendingCloudWatchLogsExports))
            .constructor(AwsRdsPendingCloudWatchLogsExports::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingCloudWatchLogsExports")
                    .build()).build();

    private static final SdkField<List<AwsRdsDbProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField
            .<List<AwsRdsDbProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ProcessorFeatures")
            .getter(getter(AwsRdsDbPendingModifiedValues::processorFeatures))
            .setter(setter(Builder::processorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_CLASS_FIELD,
            ALLOCATED_STORAGE_FIELD, MASTER_USER_PASSWORD_FIELD, PORT_FIELD, BACKUP_RETENTION_PERIOD_FIELD, MULTI_AZ_FIELD,
            ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, STORAGE_TYPE_FIELD,
            CA_CERTIFICATE_IDENTIFIER_FIELD, DB_SUBNET_GROUP_NAME_FIELD, PENDING_CLOUD_WATCH_LOGS_EXPORTS_FIELD,
            PROCESSOR_FEATURES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbInstanceClass;

    private final Integer allocatedStorage;

    private final String masterUserPassword;

    private final Integer port;

    private final Integer backupRetentionPeriod;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final String licenseModel;

    private final Integer iops;

    private final String dbInstanceIdentifier;

    private final String storageType;

    private final String caCertificateIdentifier;

    private final String dbSubnetGroupName;

    private final AwsRdsPendingCloudWatchLogsExports pendingCloudWatchLogsExports;

    private final List<AwsRdsDbProcessorFeature> processorFeatures;

    private AwsRdsDbPendingModifiedValues(BuilderImpl builder) {
        this.dbInstanceClass = builder.dbInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.masterUserPassword = builder.masterUserPassword;
        this.port = builder.port;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.storageType = builder.storageType;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.pendingCloudWatchLogsExports = builder.pendingCloudWatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
    }

    /**
     * <p>
     * The new DB instance class for the DB instance.
     * </p>
     * 
     * @return The new DB instance class for the DB instance.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The new value of the allocated storage for the DB instance.
     * </p>
     * 
     * @return The new value of the allocated storage for the DB instance.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The new master user password for the DB instance.
     * </p>
     * 
     * @return The new master user password for the DB instance.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The new port for the DB instance.
     * </p>
     * 
     * @return The new port for the DB instance.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The new backup retention period for the DB instance.
     * </p>
     * 
     * @return The new backup retention period for the DB instance.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * Indicates that a single Availability Zone DB instance is changing to a multiple Availability Zone deployment.
     * </p>
     * 
     * @return Indicates that a single Availability Zone DB instance is changing to a multiple Availability Zone
     *         deployment.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The new engine version for the DB instance.
     * </p>
     * 
     * @return The new engine version for the DB instance.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The new license model value for the DB instance.
     * </p>
     * 
     * @return The new license model value for the DB instance.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The new provisioned IOPS value for the DB instance.
     * </p>
     * 
     * @return The new provisioned IOPS value for the DB instance.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The new DB instance identifier for the DB instance.
     * </p>
     * 
     * @return The new DB instance identifier for the DB instance.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The new storage type for the DB instance.
     * </p>
     * 
     * @return The new storage type for the DB instance.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The new CA certificate identifier for the DB instance.
     * </p>
     * 
     * @return The new CA certificate identifier for the DB instance.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * The name of the new subnet group for the DB instance.
     * </p>
     * 
     * @return The name of the new subnet group for the DB instance.
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * <p>
     * A list of log types that are being enabled or disabled.
     * </p>
     * 
     * @return A list of log types that are being enabled or disabled.
     */
    public final AwsRdsPendingCloudWatchLogsExports pendingCloudWatchLogsExports() {
        return pendingCloudWatchLogsExports;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessorFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessorFeatures() {
        return processorFeatures != null && !(processorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Processor features that are being updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessorFeatures} method.
     * </p>
     * 
     * @return Processor features that are being updated.
     */
    public final List<AwsRdsDbProcessorFeature> processorFeatures() {
        return processorFeatures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(pendingCloudWatchLogsExports());
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessorFeatures() ? processorFeatures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbPendingModifiedValues)) {
            return false;
        }
        AwsRdsDbPendingModifiedValues other = (AwsRdsDbPendingModifiedValues) obj;
        return Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(masterUserPassword(), other.masterUserPassword()) && Objects.equals(port(), other.port())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && Objects.equals(pendingCloudWatchLogsExports(), other.pendingCloudWatchLogsExports())
                && hasProcessorFeatures() == other.hasProcessorFeatures()
                && Objects.equals(processorFeatures(), other.processorFeatures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbPendingModifiedValues").add("DbInstanceClass", dbInstanceClass())
                .add("AllocatedStorage", allocatedStorage()).add("MasterUserPassword", masterUserPassword()).add("Port", port())
                .add("BackupRetentionPeriod", backupRetentionPeriod()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("LicenseModel", licenseModel()).add("Iops", iops())
                .add("DbInstanceIdentifier", dbInstanceIdentifier()).add("StorageType", storageType())
                .add("CaCertificateIdentifier", caCertificateIdentifier()).add("DbSubnetGroupName", dbSubnetGroupName())
                .add("PendingCloudWatchLogsExports", pendingCloudWatchLogsExports())
                .add("ProcessorFeatures", hasProcessorFeatures() ? processorFeatures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "DbInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "CaCertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "DbSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "PendingCloudWatchLogsExports":
            return Optional.ofNullable(clazz.cast(pendingCloudWatchLogsExports()));
        case "ProcessorFeatures":
            return Optional.ofNullable(clazz.cast(processorFeatures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbPendingModifiedValues, T> g) {
        return obj -> g.apply((AwsRdsDbPendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbPendingModifiedValues> {
        /**
         * <p>
         * The new DB instance class for the DB instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        The new DB instance class for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The new value of the allocated storage for the DB instance.
         * </p>
         * 
         * @param allocatedStorage
         *        The new value of the allocated storage for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The new master user password for the DB instance.
         * </p>
         * 
         * @param masterUserPassword
         *        The new master user password for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The new port for the DB instance.
         * </p>
         * 
         * @param port
         *        The new port for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The new backup retention period for the DB instance.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The new backup retention period for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * Indicates that a single Availability Zone DB instance is changing to a multiple Availability Zone deployment.
         * </p>
         * 
         * @param multiAZ
         *        Indicates that a single Availability Zone DB instance is changing to a multiple Availability Zone
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The new engine version for the DB instance.
         * </p>
         * 
         * @param engineVersion
         *        The new engine version for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The new license model value for the DB instance.
         * </p>
         * 
         * @param licenseModel
         *        The new license model value for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The new provisioned IOPS value for the DB instance.
         * </p>
         * 
         * @param iops
         *        The new provisioned IOPS value for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The new DB instance identifier for the DB instance.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The new DB instance identifier for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The new storage type for the DB instance.
         * </p>
         * 
         * @param storageType
         *        The new storage type for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The new CA certificate identifier for the DB instance.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The new CA certificate identifier for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * The name of the new subnet group for the DB instance.
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The name of the new subnet group for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * A list of log types that are being enabled or disabled.
         * </p>
         * 
         * @param pendingCloudWatchLogsExports
         *        A list of log types that are being enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingCloudWatchLogsExports(AwsRdsPendingCloudWatchLogsExports pendingCloudWatchLogsExports);

        /**
         * <p>
         * A list of log types that are being enabled or disabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsRdsPendingCloudWatchLogsExports.Builder} avoiding the need to create one manually via
         * {@link AwsRdsPendingCloudWatchLogsExports#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsPendingCloudWatchLogsExports.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pendingCloudWatchLogsExports(AwsRdsPendingCloudWatchLogsExports)}.
         * 
         * @param pendingCloudWatchLogsExports
         *        a consumer that will call methods on {@link AwsRdsPendingCloudWatchLogsExports.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingCloudWatchLogsExports(AwsRdsPendingCloudWatchLogsExports)
         */
        default Builder pendingCloudWatchLogsExports(
                Consumer<AwsRdsPendingCloudWatchLogsExports.Builder> pendingCloudWatchLogsExports) {
            return pendingCloudWatchLogsExports(AwsRdsPendingCloudWatchLogsExports.builder()
                    .applyMutation(pendingCloudWatchLogsExports).build());
        }

        /**
         * <p>
         * Processor features that are being updated.
         * </p>
         * 
         * @param processorFeatures
         *        Processor features that are being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(Collection<AwsRdsDbProcessorFeature> processorFeatures);

        /**
         * <p>
         * Processor features that are being updated.
         * </p>
         * 
         * @param processorFeatures
         *        Processor features that are being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(AwsRdsDbProcessorFeature... processorFeatures);

        /**
         * <p>
         * Processor features that are being updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature.Builder#build()} is called
         * immediately and its result is passed to {@link #processorFeatures(List<AwsRdsDbProcessorFeature>)}.
         * 
         * @param processorFeatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorFeatures(java.util.Collection<AwsRdsDbProcessorFeature>)
         */
        Builder processorFeatures(Consumer<AwsRdsDbProcessorFeature.Builder>... processorFeatures);
    }

    static final class BuilderImpl implements Builder {
        private String dbInstanceClass;

        private Integer allocatedStorage;

        private String masterUserPassword;

        private Integer port;

        private Integer backupRetentionPeriod;

        private Boolean multiAZ;

        private String engineVersion;

        private String licenseModel;

        private Integer iops;

        private String dbInstanceIdentifier;

        private String storageType;

        private String caCertificateIdentifier;

        private String dbSubnetGroupName;

        private AwsRdsPendingCloudWatchLogsExports pendingCloudWatchLogsExports;

        private List<AwsRdsDbProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbPendingModifiedValues model) {
            dbInstanceClass(model.dbInstanceClass);
            allocatedStorage(model.allocatedStorage);
            masterUserPassword(model.masterUserPassword);
            port(model.port);
            backupRetentionPeriod(model.backupRetentionPeriod);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            licenseModel(model.licenseModel);
            iops(model.iops);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            storageType(model.storageType);
            caCertificateIdentifier(model.caCertificateIdentifier);
            dbSubnetGroupName(model.dbSubnetGroupName);
            pendingCloudWatchLogsExports(model.pendingCloudWatchLogsExports);
            processorFeatures(model.processorFeatures);
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final AwsRdsPendingCloudWatchLogsExports.Builder getPendingCloudWatchLogsExports() {
            return pendingCloudWatchLogsExports != null ? pendingCloudWatchLogsExports.toBuilder() : null;
        }

        public final void setPendingCloudWatchLogsExports(
                AwsRdsPendingCloudWatchLogsExports.BuilderImpl pendingCloudWatchLogsExports) {
            this.pendingCloudWatchLogsExports = pendingCloudWatchLogsExports != null ? pendingCloudWatchLogsExports.build()
                    : null;
        }

        @Override
        public final Builder pendingCloudWatchLogsExports(AwsRdsPendingCloudWatchLogsExports pendingCloudWatchLogsExports) {
            this.pendingCloudWatchLogsExports = pendingCloudWatchLogsExports;
            return this;
        }

        public final List<AwsRdsDbProcessorFeature.Builder> getProcessorFeatures() {
            List<AwsRdsDbProcessorFeature.Builder> result = AwsRdsDbProcessorFeaturesCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<AwsRdsDbProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = AwsRdsDbProcessorFeaturesCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        public final Builder processorFeatures(Collection<AwsRdsDbProcessorFeature> processorFeatures) {
            this.processorFeatures = AwsRdsDbProcessorFeaturesCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(AwsRdsDbProcessorFeature... processorFeatures) {
            processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<AwsRdsDbProcessorFeature.Builder>... processorFeatures) {
            processorFeatures(Stream.of(processorFeatures).map(c -> AwsRdsDbProcessorFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsRdsDbPendingModifiedValues build() {
            return new AwsRdsDbPendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
