/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the state of the domain relative to the latest service software.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder, AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails> {
    private static final SdkField<String> AUTOMATED_UPDATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomatedUpdateDate")
            .getter(getter(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::automatedUpdateDate))
            .setter(setter(Builder::automatedUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedUpdateDate").build())
            .build();

    private static final SdkField<Boolean> CANCELLABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Cancellable").getter(getter(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::cancellable))
            .setter(setter(Builder::cancellable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cancellable").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NEW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewVersion").getter(getter(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::newVersion))
            .setter(setter(Builder::newVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewVersion").build()).build();

    private static final SdkField<Boolean> UPDATE_AVAILABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UpdateAvailable")
            .getter(getter(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::updateAvailable))
            .setter(setter(Builder::updateAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateAvailable").build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateStatus").getter(getter(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::updateStatus))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()).build();

    private static final SdkField<Boolean> OPTIONAL_DEPLOYMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OptionalDeployment")
            .getter(getter(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails::optionalDeployment))
            .setter(setter(Builder::optionalDeployment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionalDeployment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATED_UPDATE_DATE_FIELD,
            CANCELLABLE_FIELD, CURRENT_VERSION_FIELD, DESCRIPTION_FIELD, NEW_VERSION_FIELD, UPDATE_AVAILABLE_FIELD,
            UPDATE_STATUS_FIELD, OPTIONAL_DEPLOYMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String automatedUpdateDate;

    private final Boolean cancellable;

    private final String currentVersion;

    private final String description;

    private final String newVersion;

    private final Boolean updateAvailable;

    private final String updateStatus;

    private final Boolean optionalDeployment;

    private AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails(BuilderImpl builder) {
        this.automatedUpdateDate = builder.automatedUpdateDate;
        this.cancellable = builder.cancellable;
        this.currentVersion = builder.currentVersion;
        this.description = builder.description;
        this.newVersion = builder.newVersion;
        this.updateAvailable = builder.updateAvailable;
        this.updateStatus = builder.updateStatus;
        this.optionalDeployment = builder.optionalDeployment;
    }

    /**
     * <p>
     * The epoch time when the deployment window closes for required updates. After this time, OpenSearch Service
     * schedules the software upgrade automatically.
     * </p>
     * 
     * @return The epoch time when the deployment window closes for required updates. After this time, OpenSearch
     *         Service schedules the software upgrade automatically.
     */
    public final String automatedUpdateDate() {
        return automatedUpdateDate;
    }

    /**
     * <p>
     * Whether a request to update the domain can be canceled.
     * </p>
     * 
     * @return Whether a request to update the domain can be canceled.
     */
    public final Boolean cancellable() {
        return cancellable;
    }

    /**
     * <p>
     * The version of the service software that is currently installed on the domain.
     * </p>
     * 
     * @return The version of the service software that is currently installed on the domain.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * A more detailed description of the service software status.
     * </p>
     * 
     * @return A more detailed description of the service software status.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The most recent version of the service software.
     * </p>
     * 
     * @return The most recent version of the service software.
     */
    public final String newVersion() {
        return newVersion;
    }

    /**
     * <p>
     * Whether a service software update is available for the domain.
     * </p>
     * 
     * @return Whether a service software update is available for the domain.
     */
    public final Boolean updateAvailable() {
        return updateAvailable;
    }

    /**
     * <p>
     * The status of the service software update. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLETED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ELIGIBLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_ELIGIBLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_UPDATE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the service software update. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ELIGIBLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_ELIGIBLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_UPDATE</code>
     *         </p>
     *         </li>
     */
    public final String updateStatus() {
        return updateStatus;
    }

    /**
     * <p>
     * Whether the service software update is optional.
     * </p>
     * 
     * @return Whether the service software update is optional.
     */
    public final Boolean optionalDeployment() {
        return optionalDeployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automatedUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(cancellable());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(newVersion());
        hashCode = 31 * hashCode + Objects.hashCode(updateAvailable());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(optionalDeployment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails)) {
            return false;
        }
        AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails other = (AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) obj;
        return Objects.equals(automatedUpdateDate(), other.automatedUpdateDate())
                && Objects.equals(cancellable(), other.cancellable()) && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(description(), other.description()) && Objects.equals(newVersion(), other.newVersion())
                && Objects.equals(updateAvailable(), other.updateAvailable())
                && Objects.equals(updateStatus(), other.updateStatus())
                && Objects.equals(optionalDeployment(), other.optionalDeployment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails")
                .add("AutomatedUpdateDate", automatedUpdateDate()).add("Cancellable", cancellable())
                .add("CurrentVersion", currentVersion()).add("Description", description()).add("NewVersion", newVersion())
                .add("UpdateAvailable", updateAvailable()).add("UpdateStatus", updateStatus())
                .add("OptionalDeployment", optionalDeployment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomatedUpdateDate":
            return Optional.ofNullable(clazz.cast(automatedUpdateDate()));
        case "Cancellable":
            return Optional.ofNullable(clazz.cast(cancellable()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NewVersion":
            return Optional.ofNullable(clazz.cast(newVersion()));
        case "UpdateAvailable":
            return Optional.ofNullable(clazz.cast(updateAvailable()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatus()));
        case "OptionalDeployment":
            return Optional.ofNullable(clazz.cast(optionalDeployment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails, T> g) {
        return obj -> g.apply((AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails> {
        /**
         * <p>
         * The epoch time when the deployment window closes for required updates. After this time, OpenSearch Service
         * schedules the software upgrade automatically.
         * </p>
         * 
         * @param automatedUpdateDate
         *        The epoch time when the deployment window closes for required updates. After this time, OpenSearch
         *        Service schedules the software upgrade automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedUpdateDate(String automatedUpdateDate);

        /**
         * <p>
         * Whether a request to update the domain can be canceled.
         * </p>
         * 
         * @param cancellable
         *        Whether a request to update the domain can be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancellable(Boolean cancellable);

        /**
         * <p>
         * The version of the service software that is currently installed on the domain.
         * </p>
         * 
         * @param currentVersion
         *        The version of the service software that is currently installed on the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * A more detailed description of the service software status.
         * </p>
         * 
         * @param description
         *        A more detailed description of the service software status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The most recent version of the service software.
         * </p>
         * 
         * @param newVersion
         *        The most recent version of the service software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newVersion(String newVersion);

        /**
         * <p>
         * Whether a service software update is available for the domain.
         * </p>
         * 
         * @param updateAvailable
         *        Whether a service software update is available for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateAvailable(Boolean updateAvailable);

        /**
         * <p>
         * The status of the service software update. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLETED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ELIGIBLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_ELIGIBLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_UPDATE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        The status of the service software update. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ELIGIBLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_ELIGIBLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_UPDATE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * Whether the service software update is optional.
         * </p>
         * 
         * @param optionalDeployment
         *        Whether the service software update is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionalDeployment(Boolean optionalDeployment);
    }

    static final class BuilderImpl implements Builder {
        private String automatedUpdateDate;

        private Boolean cancellable;

        private String currentVersion;

        private String description;

        private String newVersion;

        private Boolean updateAvailable;

        private String updateStatus;

        private Boolean optionalDeployment;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails model) {
            automatedUpdateDate(model.automatedUpdateDate);
            cancellable(model.cancellable);
            currentVersion(model.currentVersion);
            description(model.description);
            newVersion(model.newVersion);
            updateAvailable(model.updateAvailable);
            updateStatus(model.updateStatus);
            optionalDeployment(model.optionalDeployment);
        }

        public final String getAutomatedUpdateDate() {
            return automatedUpdateDate;
        }

        public final void setAutomatedUpdateDate(String automatedUpdateDate) {
            this.automatedUpdateDate = automatedUpdateDate;
        }

        @Override
        public final Builder automatedUpdateDate(String automatedUpdateDate) {
            this.automatedUpdateDate = automatedUpdateDate;
            return this;
        }

        public final Boolean getCancellable() {
            return cancellable;
        }

        public final void setCancellable(Boolean cancellable) {
            this.cancellable = cancellable;
        }

        @Override
        public final Builder cancellable(Boolean cancellable) {
            this.cancellable = cancellable;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNewVersion() {
            return newVersion;
        }

        public final void setNewVersion(String newVersion) {
            this.newVersion = newVersion;
        }

        @Override
        public final Builder newVersion(String newVersion) {
            this.newVersion = newVersion;
            return this;
        }

        public final Boolean getUpdateAvailable() {
            return updateAvailable;
        }

        public final void setUpdateAvailable(Boolean updateAvailable) {
            this.updateAvailable = updateAvailable;
        }

        @Override
        public final Builder updateAvailable(Boolean updateAvailable) {
            this.updateAvailable = updateAvailable;
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        public final Boolean getOptionalDeployment() {
            return optionalDeployment;
        }

        public final void setOptionalDeployment(Boolean optionalDeployment) {
            this.optionalDeployment = optionalDeployment;
        }

        @Override
        public final Builder optionalDeployment(Boolean optionalDeployment) {
            this.optionalDeployment = optionalDeployment;
            return this;
        }

        @Override
        public AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails build() {
            return new AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
