/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for a volume mount point that's used in a container definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsMountPoint implements SdkPojo, Serializable, ToCopyableBuilder<AwsMountPoint.Builder, AwsMountPoint> {
    private static final SdkField<String> SOURCE_VOLUME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceVolume").getter(getter(AwsMountPoint::sourceVolume)).setter(setter(Builder::sourceVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVolume").build()).build();

    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerPath").getter(getter(AwsMountPoint::containerPath)).setter(setter(Builder::containerPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VOLUME_FIELD,
            CONTAINER_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceVolume;

    private final String containerPath;

    private AwsMountPoint(BuilderImpl builder) {
        this.sourceVolume = builder.sourceVolume;
        this.containerPath = builder.containerPath;
    }

    /**
     * <p>
     * The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter of task
     * definition <code>volume</code>.
     * </p>
     * 
     * @return The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter of
     *         task definition <code>volume</code>.
     */
    public final String sourceVolume() {
        return sourceVolume;
    }

    /**
     * <p>
     * The path on the container to mount the host volume at.
     * </p>
     * 
     * @return The path on the container to mount the host volume at.
     */
    public final String containerPath() {
        return containerPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceVolume());
        hashCode = 31 * hashCode + Objects.hashCode(containerPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsMountPoint)) {
            return false;
        }
        AwsMountPoint other = (AwsMountPoint) obj;
        return Objects.equals(sourceVolume(), other.sourceVolume()) && Objects.equals(containerPath(), other.containerPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsMountPoint").add("SourceVolume", sourceVolume()).add("ContainerPath", containerPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceVolume":
            return Optional.ofNullable(clazz.cast(sourceVolume()));
        case "ContainerPath":
            return Optional.ofNullable(clazz.cast(containerPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsMountPoint, T> g) {
        return obj -> g.apply((AwsMountPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsMountPoint> {
        /**
         * <p>
         * The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter of task
         * definition <code>volume</code>.
         * </p>
         * 
         * @param sourceVolume
         *        The name of the volume to mount. Must be a volume name referenced in the <code>name</code> parameter
         *        of task definition <code>volume</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVolume(String sourceVolume);

        /**
         * <p>
         * The path on the container to mount the host volume at.
         * </p>
         * 
         * @param containerPath
         *        The path on the container to mount the host volume at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPath(String containerPath);
    }

    static final class BuilderImpl implements Builder {
        private String sourceVolume;

        private String containerPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsMountPoint model) {
            sourceVolume(model.sourceVolume);
            containerPath(model.containerPath);
        }

        public final String getSourceVolume() {
            return sourceVolume;
        }

        public final void setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
        }

        @Override
        public final Builder sourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public final String getContainerPath() {
            return containerPath;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        @Override
        public AwsMountPoint build() {
            return new AwsMountPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
