/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the policy used to set the permissions boundary for an IAM principal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamPermissionsBoundary implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamPermissionsBoundary.Builder, AwsIamPermissionsBoundary> {
    private static final SdkField<String> PERMISSIONS_BOUNDARY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionsBoundaryArn").getter(getter(AwsIamPermissionsBoundary::permissionsBoundaryArn))
            .setter(setter(Builder::permissionsBoundaryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundaryArn").build())
            .build();

    private static final SdkField<String> PERMISSIONS_BOUNDARY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionsBoundaryType").getter(getter(AwsIamPermissionsBoundary::permissionsBoundaryType))
            .setter(setter(Builder::permissionsBoundaryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundaryType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PERMISSIONS_BOUNDARY_ARN_FIELD, PERMISSIONS_BOUNDARY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String permissionsBoundaryArn;

    private final String permissionsBoundaryType;

    private AwsIamPermissionsBoundary(BuilderImpl builder) {
        this.permissionsBoundaryArn = builder.permissionsBoundaryArn;
        this.permissionsBoundaryType = builder.permissionsBoundaryType;
    }

    /**
     * <p>
     * The ARN of the policy used to set the permissions boundary.
     * </p>
     * 
     * @return The ARN of the policy used to set the permissions boundary.
     */
    public final String permissionsBoundaryArn() {
        return permissionsBoundaryArn;
    }

    /**
     * <p>
     * The usage type for the permissions boundary.
     * </p>
     * 
     * @return The usage type for the permissions boundary.
     */
    public final String permissionsBoundaryType() {
        return permissionsBoundaryType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundaryType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamPermissionsBoundary)) {
            return false;
        }
        AwsIamPermissionsBoundary other = (AwsIamPermissionsBoundary) obj;
        return Objects.equals(permissionsBoundaryArn(), other.permissionsBoundaryArn())
                && Objects.equals(permissionsBoundaryType(), other.permissionsBoundaryType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamPermissionsBoundary").add("PermissionsBoundaryArn", permissionsBoundaryArn())
                .add("PermissionsBoundaryType", permissionsBoundaryType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PermissionsBoundaryArn":
            return Optional.ofNullable(clazz.cast(permissionsBoundaryArn()));
        case "PermissionsBoundaryType":
            return Optional.ofNullable(clazz.cast(permissionsBoundaryType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamPermissionsBoundary, T> g) {
        return obj -> g.apply((AwsIamPermissionsBoundary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamPermissionsBoundary> {
        /**
         * <p>
         * The ARN of the policy used to set the permissions boundary.
         * </p>
         * 
         * @param permissionsBoundaryArn
         *        The ARN of the policy used to set the permissions boundary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundaryArn(String permissionsBoundaryArn);

        /**
         * <p>
         * The usage type for the permissions boundary.
         * </p>
         * 
         * @param permissionsBoundaryType
         *        The usage type for the permissions boundary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundaryType(String permissionsBoundaryType);
    }

    static final class BuilderImpl implements Builder {
        private String permissionsBoundaryArn;

        private String permissionsBoundaryType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamPermissionsBoundary model) {
            permissionsBoundaryArn(model.permissionsBoundaryArn);
            permissionsBoundaryType(model.permissionsBoundaryType);
        }

        public final String getPermissionsBoundaryArn() {
            return permissionsBoundaryArn;
        }

        public final void setPermissionsBoundaryArn(String permissionsBoundaryArn) {
            this.permissionsBoundaryArn = permissionsBoundaryArn;
        }

        @Override
        public final Builder permissionsBoundaryArn(String permissionsBoundaryArn) {
            this.permissionsBoundaryArn = permissionsBoundaryArn;
            return this;
        }

        public final String getPermissionsBoundaryType() {
            return permissionsBoundaryType;
        }

        public final void setPermissionsBoundaryType(String permissionsBoundaryType) {
            this.permissionsBoundaryType = permissionsBoundaryType;
        }

        @Override
        public final Builder permissionsBoundaryType(String permissionsBoundaryType) {
            this.permissionsBoundaryType = permissionsBoundaryType;
            return this;
        }

        @Override
        public AwsIamPermissionsBoundary build() {
            return new AwsIamPermissionsBoundary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
