/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an Elastic Beanstalk environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElasticBeanstalkEnvironmentDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElasticBeanstalkEnvironmentDetails.Builder, AwsElasticBeanstalkEnvironmentDetails> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(AwsElasticBeanstalkEnvironmentDetails::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> CNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cname")
            .getter(getter(AwsElasticBeanstalkEnvironmentDetails::cname)).setter(setter(Builder::cname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cname").build()).build();

    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateCreated").getter(getter(AwsElasticBeanstalkEnvironmentDetails::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<String> DATE_UPDATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DateUpdated").getter(getter(AwsElasticBeanstalkEnvironmentDetails::dateUpdated))
            .setter(setter(Builder::dateUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsElasticBeanstalkEnvironmentDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointUrl").getter(getter(AwsElasticBeanstalkEnvironmentDetails::endpointUrl))
            .setter(setter(Builder::endpointUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()).build();

    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentArn").getter(getter(AwsElasticBeanstalkEnvironmentDetails::environmentArn))
            .setter(setter(Builder::environmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(AwsElasticBeanstalkEnvironmentDetails::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()).build();

    private static final SdkField<List<AwsElasticBeanstalkEnvironmentEnvironmentLink>> ENVIRONMENT_LINKS_FIELD = SdkField
            .<List<AwsElasticBeanstalkEnvironmentEnvironmentLink>> builder(MarshallingType.LIST)
            .memberName("EnvironmentLinks")
            .getter(getter(AwsElasticBeanstalkEnvironmentDetails::environmentLinks))
            .setter(setter(Builder::environmentLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentLinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsElasticBeanstalkEnvironmentEnvironmentLink> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsElasticBeanstalkEnvironmentEnvironmentLink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentName").getter(getter(AwsElasticBeanstalkEnvironmentDetails::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()).build();

    private static final SdkField<List<AwsElasticBeanstalkEnvironmentOptionSetting>> OPTION_SETTINGS_FIELD = SdkField
            .<List<AwsElasticBeanstalkEnvironmentOptionSetting>> builder(MarshallingType.LIST)
            .memberName("OptionSettings")
            .getter(getter(AwsElasticBeanstalkEnvironmentDetails::optionSettings))
            .setter(setter(Builder::optionSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsElasticBeanstalkEnvironmentOptionSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsElasticBeanstalkEnvironmentOptionSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformArn").getter(getter(AwsElasticBeanstalkEnvironmentDetails::platformArn))
            .setter(setter(Builder::platformArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()).build();

    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SolutionStackName").getter(getter(AwsElasticBeanstalkEnvironmentDetails::solutionStackName))
            .setter(setter(Builder::solutionStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsElasticBeanstalkEnvironmentDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<AwsElasticBeanstalkEnvironmentTier> TIER_FIELD = SdkField
            .<AwsElasticBeanstalkEnvironmentTier> builder(MarshallingType.SDK_POJO).memberName("Tier")
            .getter(getter(AwsElasticBeanstalkEnvironmentDetails::tier)).setter(setter(Builder::tier))
            .constructor(AwsElasticBeanstalkEnvironmentTier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionLabel").getter(getter(AwsElasticBeanstalkEnvironmentDetails::versionLabel))
            .setter(setter(Builder::versionLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CNAME_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, DESCRIPTION_FIELD, ENDPOINT_URL_FIELD, ENVIRONMENT_ARN_FIELD,
            ENVIRONMENT_ID_FIELD, ENVIRONMENT_LINKS_FIELD, ENVIRONMENT_NAME_FIELD, OPTION_SETTINGS_FIELD, PLATFORM_ARN_FIELD,
            SOLUTION_STACK_NAME_FIELD, STATUS_FIELD, TIER_FIELD, VERSION_LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationName;

    private final String cname;

    private final String dateCreated;

    private final String dateUpdated;

    private final String description;

    private final String endpointUrl;

    private final String environmentArn;

    private final String environmentId;

    private final List<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks;

    private final String environmentName;

    private final List<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings;

    private final String platformArn;

    private final String solutionStackName;

    private final String status;

    private final AwsElasticBeanstalkEnvironmentTier tier;

    private final String versionLabel;

    private AwsElasticBeanstalkEnvironmentDetails(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.cname = builder.cname;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.description = builder.description;
        this.endpointUrl = builder.endpointUrl;
        this.environmentArn = builder.environmentArn;
        this.environmentId = builder.environmentId;
        this.environmentLinks = builder.environmentLinks;
        this.environmentName = builder.environmentName;
        this.optionSettings = builder.optionSettings;
        this.platformArn = builder.platformArn;
        this.solutionStackName = builder.solutionStackName;
        this.status = builder.status;
        this.tier = builder.tier;
        this.versionLabel = builder.versionLabel;
    }

    /**
     * <p>
     * The name of the application that is associated with the environment.
     * </p>
     * 
     * @return The name of the application that is associated with the environment.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The URL to the CNAME for this environment.
     * </p>
     * 
     * @return The URL to the CNAME for this environment.
     */
    public final String cname() {
        return cname;
    }

    /**
     * <p>
     * The creation date for this environment.
     * </p>
     * 
     * @return The creation date for this environment.
     */
    public final String dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date when this environment was last modified.
     * </p>
     * 
     * @return The date when this environment was last modified.
     */
    public final String dateUpdated() {
        return dateUpdated;
    }

    /**
     * <p>
     * A description of the environment.
     * </p>
     * 
     * @return A description of the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * For load-balanced, autoscaling environments, the URL to the load balancer. For single-instance environments, the
     * IP address of the instance.
     * </p>
     * 
     * @return For load-balanced, autoscaling environments, the URL to the load balancer. For single-instance
     *         environments, the IP address of the instance.
     */
    public final String endpointUrl() {
        return endpointUrl;
    }

    /**
     * <p>
     * The ARN of the environment.
     * </p>
     * 
     * @return The ARN of the environment.
     */
    public final String environmentArn() {
        return environmentArn;
    }

    /**
     * <p>
     * The identifier of the environment.
     * </p>
     * 
     * @return The identifier of the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentLinks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentLinks() {
        return environmentLinks != null && !(environmentLinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Links to other environments in the same group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentLinks} method.
     * </p>
     * 
     * @return Links to other environments in the same group.
     */
    public final List<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks() {
        return environmentLinks;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionSettings() {
        return optionSettings != null && !(optionSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration setting for the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionSettings} method.
     * </p>
     * 
     * @return The configuration setting for the environment.
     */
    public final List<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings() {
        return optionSettings;
    }

    /**
     * <p>
     * The ARN of the platform version for the environment.
     * </p>
     * 
     * @return The ARN of the platform version for the environment.
     */
    public final String platformArn() {
        return platformArn;
    }

    /**
     * <p>
     * The name of the solution stack that is deployed with the environment.
     * </p>
     * 
     * @return The name of the solution stack that is deployed with the environment.
     */
    public final String solutionStackName() {
        return solutionStackName;
    }

    /**
     * <p>
     * The current operational status of the environment. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Aborting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Launching</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LinkingFrom</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LinkingTo</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Ready</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Updating</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current operational status of the environment. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Aborting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Launching</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LinkingFrom</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LinkingTo</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Ready</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminating</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Updating</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The tier of the environment.
     * </p>
     * 
     * @return The tier of the environment.
     */
    public final AwsElasticBeanstalkEnvironmentTier tier() {
        return tier;
    }

    /**
     * <p>
     * The application version of the environment.
     * </p>
     * 
     * @return The application version of the environment.
     */
    public final String versionLabel() {
        return versionLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(cname());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentLinks() ? environmentLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionSettings() ? optionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(tier());
        hashCode = 31 * hashCode + Objects.hashCode(versionLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticBeanstalkEnvironmentDetails)) {
            return false;
        }
        AwsElasticBeanstalkEnvironmentDetails other = (AwsElasticBeanstalkEnvironmentDetails) obj;
        return Objects.equals(applicationName(), other.applicationName()) && Objects.equals(cname(), other.cname())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateUpdated(), other.dateUpdated())
                && Objects.equals(description(), other.description()) && Objects.equals(endpointUrl(), other.endpointUrl())
                && Objects.equals(environmentArn(), other.environmentArn())
                && Objects.equals(environmentId(), other.environmentId()) && hasEnvironmentLinks() == other.hasEnvironmentLinks()
                && Objects.equals(environmentLinks(), other.environmentLinks())
                && Objects.equals(environmentName(), other.environmentName()) && hasOptionSettings() == other.hasOptionSettings()
                && Objects.equals(optionSettings(), other.optionSettings()) && Objects.equals(platformArn(), other.platformArn())
                && Objects.equals(solutionStackName(), other.solutionStackName()) && Objects.equals(status(), other.status())
                && Objects.equals(tier(), other.tier()) && Objects.equals(versionLabel(), other.versionLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElasticBeanstalkEnvironmentDetails").add("ApplicationName", applicationName())
                .add("Cname", cname()).add("DateCreated", dateCreated()).add("DateUpdated", dateUpdated())
                .add("Description", description()).add("EndpointUrl", endpointUrl()).add("EnvironmentArn", environmentArn())
                .add("EnvironmentId", environmentId()).add("EnvironmentLinks", hasEnvironmentLinks() ? environmentLinks() : null)
                .add("EnvironmentName", environmentName()).add("OptionSettings", hasOptionSettings() ? optionSettings() : null)
                .add("PlatformArn", platformArn()).add("SolutionStackName", solutionStackName()).add("Status", status())
                .add("Tier", tier()).add("VersionLabel", versionLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "Cname":
            return Optional.ofNullable(clazz.cast(cname()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateUpdated":
            return Optional.ofNullable(clazz.cast(dateUpdated()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndpointUrl":
            return Optional.ofNullable(clazz.cast(endpointUrl()));
        case "EnvironmentArn":
            return Optional.ofNullable(clazz.cast(environmentArn()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "EnvironmentLinks":
            return Optional.ofNullable(clazz.cast(environmentLinks()));
        case "EnvironmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "OptionSettings":
            return Optional.ofNullable(clazz.cast(optionSettings()));
        case "PlatformArn":
            return Optional.ofNullable(clazz.cast(platformArn()));
        case "SolutionStackName":
            return Optional.ofNullable(clazz.cast(solutionStackName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tier()));
        case "VersionLabel":
            return Optional.ofNullable(clazz.cast(versionLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticBeanstalkEnvironmentDetails, T> g) {
        return obj -> g.apply((AwsElasticBeanstalkEnvironmentDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElasticBeanstalkEnvironmentDetails> {
        /**
         * <p>
         * The name of the application that is associated with the environment.
         * </p>
         * 
         * @param applicationName
         *        The name of the application that is associated with the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The URL to the CNAME for this environment.
         * </p>
         * 
         * @param cname
         *        The URL to the CNAME for this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cname(String cname);

        /**
         * <p>
         * The creation date for this environment.
         * </p>
         * 
         * @param dateCreated
         *        The creation date for this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(String dateCreated);

        /**
         * <p>
         * The date when this environment was last modified.
         * </p>
         * 
         * @param dateUpdated
         *        The date when this environment was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateUpdated(String dateUpdated);

        /**
         * <p>
         * A description of the environment.
         * </p>
         * 
         * @param description
         *        A description of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * For load-balanced, autoscaling environments, the URL to the load balancer. For single-instance environments,
         * the IP address of the instance.
         * </p>
         * 
         * @param endpointUrl
         *        For load-balanced, autoscaling environments, the URL to the load balancer. For single-instance
         *        environments, the IP address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointUrl(String endpointUrl);

        /**
         * <p>
         * The ARN of the environment.
         * </p>
         * 
         * @param environmentArn
         *        The ARN of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentArn(String environmentArn);

        /**
         * <p>
         * The identifier of the environment.
         * </p>
         * 
         * @param environmentId
         *        The identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Links to other environments in the same group.
         * </p>
         * 
         * @param environmentLinks
         *        Links to other environments in the same group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentLinks(Collection<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks);

        /**
         * <p>
         * Links to other environments in the same group.
         * </p>
         * 
         * @param environmentLinks
         *        Links to other environments in the same group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentLinks(AwsElasticBeanstalkEnvironmentEnvironmentLink... environmentLinks);

        /**
         * <p>
         * Links to other environments in the same group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #environmentLinks(List<AwsElasticBeanstalkEnvironmentEnvironmentLink>)}.
         * 
         * @param environmentLinks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentLinks(java.util.Collection<AwsElasticBeanstalkEnvironmentEnvironmentLink>)
         */
        Builder environmentLinks(Consumer<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder>... environmentLinks);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The configuration setting for the environment.
         * </p>
         * 
         * @param optionSettings
         *        The configuration setting for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(Collection<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings);

        /**
         * <p>
         * The configuration setting for the environment.
         * </p>
         * 
         * @param optionSettings
         *        The configuration setting for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionSettings(AwsElasticBeanstalkEnvironmentOptionSetting... optionSettings);

        /**
         * <p>
         * The configuration setting for the environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #optionSettings(List<AwsElasticBeanstalkEnvironmentOptionSetting>)}.
         * 
         * @param optionSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionSettings(java.util.Collection<AwsElasticBeanstalkEnvironmentOptionSetting>)
         */
        Builder optionSettings(Consumer<AwsElasticBeanstalkEnvironmentOptionSetting.Builder>... optionSettings);

        /**
         * <p>
         * The ARN of the platform version for the environment.
         * </p>
         * 
         * @param platformArn
         *        The ARN of the platform version for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformArn(String platformArn);

        /**
         * <p>
         * The name of the solution stack that is deployed with the environment.
         * </p>
         * 
         * @param solutionStackName
         *        The name of the solution stack that is deployed with the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionStackName(String solutionStackName);

        /**
         * <p>
         * The current operational status of the environment. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Aborting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Launching</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LinkingFrom</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LinkingTo</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Ready</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminating</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Updating</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current operational status of the environment. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Aborting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Launching</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LinkingFrom</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LinkingTo</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Ready</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminating</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Updating</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The tier of the environment.
         * </p>
         * 
         * @param tier
         *        The tier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tier(AwsElasticBeanstalkEnvironmentTier tier);

        /**
         * <p>
         * The tier of the environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElasticBeanstalkEnvironmentTier.Builder} avoiding the need to create one manually via
         * {@link AwsElasticBeanstalkEnvironmentTier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsElasticBeanstalkEnvironmentTier.Builder#build()} is called
         * immediately and its result is passed to {@link #tier(AwsElasticBeanstalkEnvironmentTier)}.
         * 
         * @param tier
         *        a consumer that will call methods on {@link AwsElasticBeanstalkEnvironmentTier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tier(AwsElasticBeanstalkEnvironmentTier)
         */
        default Builder tier(Consumer<AwsElasticBeanstalkEnvironmentTier.Builder> tier) {
            return tier(AwsElasticBeanstalkEnvironmentTier.builder().applyMutation(tier).build());
        }

        /**
         * <p>
         * The application version of the environment.
         * </p>
         * 
         * @param versionLabel
         *        The application version of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionLabel(String versionLabel);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private String cname;

        private String dateCreated;

        private String dateUpdated;

        private String description;

        private String endpointUrl;

        private String environmentArn;

        private String environmentId;

        private List<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks = DefaultSdkAutoConstructList.getInstance();

        private String environmentName;

        private List<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private String platformArn;

        private String solutionStackName;

        private String status;

        private AwsElasticBeanstalkEnvironmentTier tier;

        private String versionLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticBeanstalkEnvironmentDetails model) {
            applicationName(model.applicationName);
            cname(model.cname);
            dateCreated(model.dateCreated);
            dateUpdated(model.dateUpdated);
            description(model.description);
            endpointUrl(model.endpointUrl);
            environmentArn(model.environmentArn);
            environmentId(model.environmentId);
            environmentLinks(model.environmentLinks);
            environmentName(model.environmentName);
            optionSettings(model.optionSettings);
            platformArn(model.platformArn);
            solutionStackName(model.solutionStackName);
            status(model.status);
            tier(model.tier);
            versionLabel(model.versionLabel);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getCname() {
            return cname;
        }

        public final void setCname(String cname) {
            this.cname = cname;
        }

        @Override
        public final Builder cname(String cname) {
            this.cname = cname;
            return this;
        }

        public final String getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final String getDateUpdated() {
            return dateUpdated;
        }

        public final void setDateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        public final Builder dateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointUrl() {
            return endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final String getEnvironmentArn() {
            return environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final List<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder> getEnvironmentLinks() {
            List<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder> result = AwsElasticBeanstalkEnvironmentEnvironmentLinksCopier
                    .copyToBuilder(this.environmentLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentLinks(
                Collection<AwsElasticBeanstalkEnvironmentEnvironmentLink.BuilderImpl> environmentLinks) {
            this.environmentLinks = AwsElasticBeanstalkEnvironmentEnvironmentLinksCopier.copyFromBuilder(environmentLinks);
        }

        @Override
        public final Builder environmentLinks(Collection<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks) {
            this.environmentLinks = AwsElasticBeanstalkEnvironmentEnvironmentLinksCopier.copy(environmentLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentLinks(AwsElasticBeanstalkEnvironmentEnvironmentLink... environmentLinks) {
            environmentLinks(Arrays.asList(environmentLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentLinks(Consumer<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder>... environmentLinks) {
            environmentLinks(Stream.of(environmentLinks)
                    .map(c -> AwsElasticBeanstalkEnvironmentEnvironmentLink.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final List<AwsElasticBeanstalkEnvironmentOptionSetting.Builder> getOptionSettings() {
            List<AwsElasticBeanstalkEnvironmentOptionSetting.Builder> result = AwsElasticBeanstalkEnvironmentOptionSettingsCopier
                    .copyToBuilder(this.optionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionSettings(Collection<AwsElasticBeanstalkEnvironmentOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = AwsElasticBeanstalkEnvironmentOptionSettingsCopier.copyFromBuilder(optionSettings);
        }

        @Override
        public final Builder optionSettings(Collection<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings) {
            this.optionSettings = AwsElasticBeanstalkEnvironmentOptionSettingsCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(AwsElasticBeanstalkEnvironmentOptionSetting... optionSettings) {
            optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<AwsElasticBeanstalkEnvironmentOptionSetting.Builder>... optionSettings) {
            optionSettings(Stream.of(optionSettings)
                    .map(c -> AwsElasticBeanstalkEnvironmentOptionSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformArn() {
            return platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final String getSolutionStackName() {
            return solutionStackName;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final AwsElasticBeanstalkEnvironmentTier.Builder getTier() {
            return tier != null ? tier.toBuilder() : null;
        }

        public final void setTier(AwsElasticBeanstalkEnvironmentTier.BuilderImpl tier) {
            this.tier = tier != null ? tier.build() : null;
        }

        @Override
        public final Builder tier(AwsElasticBeanstalkEnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final String getVersionLabel() {
            return versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        @Override
        public AwsElasticBeanstalkEnvironmentDetails build() {
            return new AwsElasticBeanstalkEnvironmentDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
