/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container path, mount options, and size (in MiB) of a tmpfs mount.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> {
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerPath")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails::containerPath))
            .setter(setter(Builder::containerPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPath").build()).build();

    private static final SdkField<List<String>> MOUNT_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MountOptions")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails::mountOptions))
            .setter(setter(Builder::mountOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Size")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails::size))
            .setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PATH_FIELD,
            MOUNT_OPTIONS_FIELD, SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerPath;

    private final List<String> mountOptions;

    private final Integer size;

    private AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.mountOptions = builder.mountOptions;
        this.size = builder.size;
    }

    /**
     * <p>
     * The absolute file path where the tmpfs volume is to be mounted.
     * </p>
     * 
     * @return The absolute file path where the tmpfs volume is to be mounted.
     */
    public final String containerPath() {
        return containerPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the MountOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMountOptions() {
        return mountOptions != null && !(mountOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tmpfs volume mount options.
     * </p>
     * <p>
     * Valid values: <code>"defaults"</code> | <code>"ro"</code> | <code>"rw"</code> | <code>"suid"</code> |
     * <code>"nosuid"</code> | <code>"dev"</code> | <code>"nodev"</code> |<code> "exec"</code> | <code>"noexec"</code> |
     * <code>"sync"</code> | <code>"async"</code> | <code>"dirsync"</code> | <code>"remount"</code> |
     * <code>"mand"</code> | <code>"nomand"</code> | <code>"atime"</code> | <code>"noatime"</code> |
     * <code>"diratime"</code> | <code>"nodiratime"</code> | <code>"bind"</code> | <code>"rbind"</code> |
     * <code>"unbindable"</code> | <code>"runbindable"</code> | <code>"private"</code> | <code>"rprivate"</code> |
     * <code>"shared"</code> | <code>"rshared"</code> | <code>"slave"</code> | <code>"rslave"</code> |
     * <code>"relatime"</code> | <code>"norelatime"</code> | <code>"strictatime"</code> | <code>"nostrictatime"</code> |
     * <code> "mode"</code> | <code>"uid"</code> | <code>"gid"</code> | <code>"nr_inodes"</code> |
     * <code> "nr_blocks"</code> | <code>"mpol"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMountOptions} method.
     * </p>
     * 
     * @return The list of tmpfs volume mount options.</p>
     *         <p>
     *         Valid values: <code>"defaults"</code> | <code>"ro"</code> | <code>"rw"</code> | <code>"suid"</code> |
     *         <code>"nosuid"</code> | <code>"dev"</code> | <code>"nodev"</code> |<code> "exec"</code> |
     *         <code>"noexec"</code> | <code>"sync"</code> | <code>"async"</code> | <code>"dirsync"</code> |
     *         <code>"remount"</code> | <code>"mand"</code> | <code>"nomand"</code> | <code>"atime"</code> |
     *         <code>"noatime"</code> | <code>"diratime"</code> | <code>"nodiratime"</code> | <code>"bind"</code> |
     *         <code>"rbind"</code> | <code>"unbindable"</code> | <code>"runbindable"</code> | <code>"private"</code> |
     *         <code>"rprivate"</code> | <code>"shared"</code> | <code>"rshared"</code> | <code>"slave"</code> |
     *         <code>"rslave"</code> | <code>"relatime"</code> | <code>"norelatime"</code> | <code>"strictatime"</code>
     *         | <code>"nostrictatime"</code> |<code> "mode"</code> | <code>"uid"</code> | <code>"gid"</code> |
     *         <code>"nr_inodes"</code> |<code> "nr_blocks"</code> | <code>"mpol"</code>
     */
    public final List<String> mountOptions() {
        return mountOptions;
    }

    /**
     * <p>
     * The maximum size (in MiB) of the tmpfs volume.
     * </p>
     * 
     * @return The maximum size (in MiB) of the tmpfs volume.
     */
    public final Integer size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasMountOptions() ? mountOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) obj;
        return Objects.equals(containerPath(), other.containerPath()) && hasMountOptions() == other.hasMountOptions()
                && Objects.equals(mountOptions(), other.mountOptions()) && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails")
                .add("ContainerPath", containerPath()).add("MountOptions", hasMountOptions() ? mountOptions() : null)
                .add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerPath":
            return Optional.ofNullable(clazz.cast(containerPath()));
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> {
        /**
         * <p>
         * The absolute file path where the tmpfs volume is to be mounted.
         * </p>
         * 
         * @param containerPath
         *        The absolute file path where the tmpfs volume is to be mounted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPath(String containerPath);

        /**
         * <p>
         * The list of tmpfs volume mount options.
         * </p>
         * <p>
         * Valid values: <code>"defaults"</code> | <code>"ro"</code> | <code>"rw"</code> | <code>"suid"</code> |
         * <code>"nosuid"</code> | <code>"dev"</code> | <code>"nodev"</code> |<code> "exec"</code> |
         * <code>"noexec"</code> | <code>"sync"</code> | <code>"async"</code> | <code>"dirsync"</code> |
         * <code>"remount"</code> | <code>"mand"</code> | <code>"nomand"</code> | <code>"atime"</code> |
         * <code>"noatime"</code> | <code>"diratime"</code> | <code>"nodiratime"</code> | <code>"bind"</code> |
         * <code>"rbind"</code> | <code>"unbindable"</code> | <code>"runbindable"</code> | <code>"private"</code> |
         * <code>"rprivate"</code> | <code>"shared"</code> | <code>"rshared"</code> | <code>"slave"</code> |
         * <code>"rslave"</code> | <code>"relatime"</code> | <code>"norelatime"</code> | <code>"strictatime"</code> |
         * <code>"nostrictatime"</code> |<code> "mode"</code> | <code>"uid"</code> | <code>"gid"</code> |
         * <code>"nr_inodes"</code> |<code> "nr_blocks"</code> | <code>"mpol"</code>
         * </p>
         * 
         * @param mountOptions
         *        The list of tmpfs volume mount options.</p>
         *        <p>
         *        Valid values: <code>"defaults"</code> | <code>"ro"</code> | <code>"rw"</code> | <code>"suid"</code> |
         *        <code>"nosuid"</code> | <code>"dev"</code> | <code>"nodev"</code> |<code> "exec"</code> |
         *        <code>"noexec"</code> | <code>"sync"</code> | <code>"async"</code> | <code>"dirsync"</code> |
         *        <code>"remount"</code> | <code>"mand"</code> | <code>"nomand"</code> | <code>"atime"</code> |
         *        <code>"noatime"</code> | <code>"diratime"</code> | <code>"nodiratime"</code> | <code>"bind"</code> |
         *        <code>"rbind"</code> | <code>"unbindable"</code> | <code>"runbindable"</code> | <code>"private"</code>
         *        | <code>"rprivate"</code> | <code>"shared"</code> | <code>"rshared"</code> | <code>"slave"</code> |
         *        <code>"rslave"</code> | <code>"relatime"</code> | <code>"norelatime"</code> |
         *        <code>"strictatime"</code> | <code>"nostrictatime"</code> |<code> "mode"</code> | <code>"uid"</code> |
         *        <code>"gid"</code> | <code>"nr_inodes"</code> |<code> "nr_blocks"</code> | <code>"mpol"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(Collection<String> mountOptions);

        /**
         * <p>
         * The list of tmpfs volume mount options.
         * </p>
         * <p>
         * Valid values: <code>"defaults"</code> | <code>"ro"</code> | <code>"rw"</code> | <code>"suid"</code> |
         * <code>"nosuid"</code> | <code>"dev"</code> | <code>"nodev"</code> |<code> "exec"</code> |
         * <code>"noexec"</code> | <code>"sync"</code> | <code>"async"</code> | <code>"dirsync"</code> |
         * <code>"remount"</code> | <code>"mand"</code> | <code>"nomand"</code> | <code>"atime"</code> |
         * <code>"noatime"</code> | <code>"diratime"</code> | <code>"nodiratime"</code> | <code>"bind"</code> |
         * <code>"rbind"</code> | <code>"unbindable"</code> | <code>"runbindable"</code> | <code>"private"</code> |
         * <code>"rprivate"</code> | <code>"shared"</code> | <code>"rshared"</code> | <code>"slave"</code> |
         * <code>"rslave"</code> | <code>"relatime"</code> | <code>"norelatime"</code> | <code>"strictatime"</code> |
         * <code>"nostrictatime"</code> |<code> "mode"</code> | <code>"uid"</code> | <code>"gid"</code> |
         * <code>"nr_inodes"</code> |<code> "nr_blocks"</code> | <code>"mpol"</code>
         * </p>
         * 
         * @param mountOptions
         *        The list of tmpfs volume mount options.</p>
         *        <p>
         *        Valid values: <code>"defaults"</code> | <code>"ro"</code> | <code>"rw"</code> | <code>"suid"</code> |
         *        <code>"nosuid"</code> | <code>"dev"</code> | <code>"nodev"</code> |<code> "exec"</code> |
         *        <code>"noexec"</code> | <code>"sync"</code> | <code>"async"</code> | <code>"dirsync"</code> |
         *        <code>"remount"</code> | <code>"mand"</code> | <code>"nomand"</code> | <code>"atime"</code> |
         *        <code>"noatime"</code> | <code>"diratime"</code> | <code>"nodiratime"</code> | <code>"bind"</code> |
         *        <code>"rbind"</code> | <code>"unbindable"</code> | <code>"runbindable"</code> | <code>"private"</code>
         *        | <code>"rprivate"</code> | <code>"shared"</code> | <code>"rshared"</code> | <code>"slave"</code> |
         *        <code>"rslave"</code> | <code>"relatime"</code> | <code>"norelatime"</code> |
         *        <code>"strictatime"</code> | <code>"nostrictatime"</code> |<code> "mode"</code> | <code>"uid"</code> |
         *        <code>"gid"</code> | <code>"nr_inodes"</code> |<code> "nr_blocks"</code> | <code>"mpol"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(String... mountOptions);

        /**
         * <p>
         * The maximum size (in MiB) of the tmpfs volume.
         * </p>
         * 
         * @param size
         *        The maximum size (in MiB) of the tmpfs volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);
    }

    static final class BuilderImpl implements Builder {
        private String containerPath;

        private List<String> mountOptions = DefaultSdkAutoConstructList.getInstance();

        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails model) {
            containerPath(model.containerPath);
            mountOptions(model.mountOptions);
            size(model.size);
        }

        public final String getContainerPath() {
            return containerPath;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final Collection<String> getMountOptions() {
            if (mountOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return mountOptions;
        }

        public final void setMountOptions(Collection<String> mountOptions) {
            this.mountOptions = NonEmptyStringListCopier.copy(mountOptions);
        }

        @Override
        public final Builder mountOptions(Collection<String> mountOptions) {
            this.mountOptions = NonEmptyStringListCopier.copy(mountOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountOptions(String... mountOptions) {
            mountOptions(Arrays.asList(mountOptions));
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
