/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC in a VPC peering connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VpcPeeringConnectionVpcInfoDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder, AwsEc2VpcPeeringConnectionVpcInfoDetails> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock").getter(getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::cidrBlock))
            .setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").build()).build();

    private static final SdkField<List<VpcInfoCidrBlockSetDetails>> CIDR_BLOCK_SET_FIELD = SdkField
            .<List<VpcInfoCidrBlockSetDetails>> builder(MarshallingType.LIST)
            .memberName("CidrBlockSet")
            .getter(getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::cidrBlockSet))
            .setter(setter(Builder::cidrBlockSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcInfoCidrBlockSetDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcInfoCidrBlockSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VpcInfoIpv6CidrBlockSetDetails>> IPV6_CIDR_BLOCK_SET_FIELD = SdkField
            .<List<VpcInfoIpv6CidrBlockSetDetails>> builder(MarshallingType.LIST)
            .memberName("Ipv6CidrBlockSet")
            .getter(getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::ipv6CidrBlockSet))
            .setter(setter(Builder::ipv6CidrBlockSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcInfoIpv6CidrBlockSetDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcInfoIpv6CidrBlockSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<VpcInfoPeeringOptionsDetails> PEERING_OPTIONS_FIELD = SdkField
            .<VpcInfoPeeringOptionsDetails> builder(MarshallingType.SDK_POJO).memberName("PeeringOptions")
            .getter(getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::peeringOptions)).setter(setter(Builder::peeringOptions))
            .constructor(VpcInfoPeeringOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringOptions").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsEc2VpcPeeringConnectionVpcInfoDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD,
            CIDR_BLOCK_SET_FIELD, IPV6_CIDR_BLOCK_SET_FIELD, OWNER_ID_FIELD, PEERING_OPTIONS_FIELD, REGION_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidrBlock;

    private final List<VpcInfoCidrBlockSetDetails> cidrBlockSet;

    private final List<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet;

    private final String ownerId;

    private final VpcInfoPeeringOptionsDetails peeringOptions;

    private final String region;

    private final String vpcId;

    private AwsEc2VpcPeeringConnectionVpcInfoDetails(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.cidrBlockSet = builder.cidrBlockSet;
        this.ipv6CidrBlockSet = builder.ipv6CidrBlockSet;
        this.ownerId = builder.ownerId;
        this.peeringOptions = builder.peeringOptions;
        this.region = builder.region;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The IPv4 CIDR block for the VPC.
     * </p>
     * 
     * @return The IPv4 CIDR block for the VPC.
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrBlockSet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCidrBlockSet() {
        return cidrBlockSet != null && !(cidrBlockSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the IPv4 CIDR blocks for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrBlockSet} method.
     * </p>
     * 
     * @return Information about the IPv4 CIDR blocks for the VPC.
     */
    public final List<VpcInfoCidrBlockSetDetails> cidrBlockSet() {
        return cidrBlockSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6CidrBlockSet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6CidrBlockSet() {
        return ipv6CidrBlockSet != null && !(ipv6CidrBlockSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 CIDR block for the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6CidrBlockSet} method.
     * </p>
     * 
     * @return The IPv6 CIDR block for the VPC.
     */
    public final List<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet() {
        return ipv6CidrBlockSet;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the VPC.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the VPC.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Information about the VPC peering connection options for the accepter or requester VPC.
     * </p>
     * 
     * @return Information about the VPC peering connection options for the accepter or requester VPC.
     */
    public final VpcInfoPeeringOptionsDetails peeringOptions() {
        return peeringOptions;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which the VPC is located.
     * </p>
     * 
     * @return The Amazon Web Services Region in which the VPC is located.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrBlockSet() ? cidrBlockSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6CidrBlockSet() ? ipv6CidrBlockSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(peeringOptions());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpcPeeringConnectionVpcInfoDetails)) {
            return false;
        }
        AwsEc2VpcPeeringConnectionVpcInfoDetails other = (AwsEc2VpcPeeringConnectionVpcInfoDetails) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock()) && hasCidrBlockSet() == other.hasCidrBlockSet()
                && Objects.equals(cidrBlockSet(), other.cidrBlockSet()) && hasIpv6CidrBlockSet() == other.hasIpv6CidrBlockSet()
                && Objects.equals(ipv6CidrBlockSet(), other.ipv6CidrBlockSet()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(peeringOptions(), other.peeringOptions()) && Objects.equals(region(), other.region())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VpcPeeringConnectionVpcInfoDetails").add("CidrBlock", cidrBlock())
                .add("CidrBlockSet", hasCidrBlockSet() ? cidrBlockSet() : null)
                .add("Ipv6CidrBlockSet", hasIpv6CidrBlockSet() ? ipv6CidrBlockSet() : null).add("OwnerId", ownerId())
                .add("PeeringOptions", peeringOptions()).add("Region", region()).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        case "CidrBlockSet":
            return Optional.ofNullable(clazz.cast(cidrBlockSet()));
        case "Ipv6CidrBlockSet":
            return Optional.ofNullable(clazz.cast(ipv6CidrBlockSet()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PeeringOptions":
            return Optional.ofNullable(clazz.cast(peeringOptions()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpcPeeringConnectionVpcInfoDetails, T> g) {
        return obj -> g.apply((AwsEc2VpcPeeringConnectionVpcInfoDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VpcPeeringConnectionVpcInfoDetails> {
        /**
         * <p>
         * The IPv4 CIDR block for the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks for the VPC.
         * </p>
         * 
         * @param cidrBlockSet
         *        Information about the IPv4 CIDR blocks for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockSet(Collection<VpcInfoCidrBlockSetDetails> cidrBlockSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks for the VPC.
         * </p>
         * 
         * @param cidrBlockSet
         *        Information about the IPv4 CIDR blocks for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockSet(VpcInfoCidrBlockSetDetails... cidrBlockSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks for the VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #cidrBlockSet(List<VpcInfoCidrBlockSetDetails>)}.
         * 
         * @param cidrBlockSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.VpcInfoCidrBlockSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlockSet(java.util.Collection<VpcInfoCidrBlockSetDetails>)
         */
        Builder cidrBlockSet(Consumer<VpcInfoCidrBlockSetDetails.Builder>... cidrBlockSet);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockSet
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockSet(Collection<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockSet
         *        The IPv6 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockSet(VpcInfoIpv6CidrBlockSetDetails... ipv6CidrBlockSet);

        /**
         * <p>
         * The IPv6 CIDR block for the VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #ipv6CidrBlockSet(List<VpcInfoIpv6CidrBlockSetDetails>)}.
         * 
         * @param ipv6CidrBlockSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.VpcInfoIpv6CidrBlockSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockSet(java.util.Collection<VpcInfoIpv6CidrBlockSetDetails>)
         */
        Builder ipv6CidrBlockSet(Consumer<VpcInfoIpv6CidrBlockSetDetails.Builder>... ipv6CidrBlockSet);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the VPC.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Information about the VPC peering connection options for the accepter or requester VPC.
         * </p>
         * 
         * @param peeringOptions
         *        Information about the VPC peering connection options for the accepter or requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringOptions(VpcInfoPeeringOptionsDetails peeringOptions);

        /**
         * <p>
         * Information about the VPC peering connection options for the accepter or requester VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcInfoPeeringOptionsDetails.Builder}
         * avoiding the need to create one manually via {@link VpcInfoPeeringOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcInfoPeeringOptionsDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #peeringOptions(VpcInfoPeeringOptionsDetails)}.
         * 
         * @param peeringOptions
         *        a consumer that will call methods on {@link VpcInfoPeeringOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #peeringOptions(VpcInfoPeeringOptionsDetails)
         */
        default Builder peeringOptions(Consumer<VpcInfoPeeringOptionsDetails.Builder> peeringOptions) {
            return peeringOptions(VpcInfoPeeringOptionsDetails.builder().applyMutation(peeringOptions).build());
        }

        /**
         * <p>
         * The Amazon Web Services Region in which the VPC is located.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region in which the VPC is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private List<VpcInfoCidrBlockSetDetails> cidrBlockSet = DefaultSdkAutoConstructList.getInstance();

        private List<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet = DefaultSdkAutoConstructList.getInstance();

        private String ownerId;

        private VpcInfoPeeringOptionsDetails peeringOptions;

        private String region;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpcPeeringConnectionVpcInfoDetails model) {
            cidrBlock(model.cidrBlock);
            cidrBlockSet(model.cidrBlockSet);
            ipv6CidrBlockSet(model.ipv6CidrBlockSet);
            ownerId(model.ownerId);
            peeringOptions(model.peeringOptions);
            region(model.region);
            vpcId(model.vpcId);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final List<VpcInfoCidrBlockSetDetails.Builder> getCidrBlockSet() {
            List<VpcInfoCidrBlockSetDetails.Builder> result = VpcInfoCidrBlockSetListCopier.copyToBuilder(this.cidrBlockSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlockSet(Collection<VpcInfoCidrBlockSetDetails.BuilderImpl> cidrBlockSet) {
            this.cidrBlockSet = VpcInfoCidrBlockSetListCopier.copyFromBuilder(cidrBlockSet);
        }

        @Override
        public final Builder cidrBlockSet(Collection<VpcInfoCidrBlockSetDetails> cidrBlockSet) {
            this.cidrBlockSet = VpcInfoCidrBlockSetListCopier.copy(cidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(VpcInfoCidrBlockSetDetails... cidrBlockSet) {
            cidrBlockSet(Arrays.asList(cidrBlockSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(Consumer<VpcInfoCidrBlockSetDetails.Builder>... cidrBlockSet) {
            cidrBlockSet(Stream.of(cidrBlockSet).map(c -> VpcInfoCidrBlockSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<VpcInfoIpv6CidrBlockSetDetails.Builder> getIpv6CidrBlockSet() {
            List<VpcInfoIpv6CidrBlockSetDetails.Builder> result = VpcInfoIpv6CidrBlockSetListCopier
                    .copyToBuilder(this.ipv6CidrBlockSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockSet(Collection<VpcInfoIpv6CidrBlockSetDetails.BuilderImpl> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = VpcInfoIpv6CidrBlockSetListCopier.copyFromBuilder(ipv6CidrBlockSet);
        }

        @Override
        public final Builder ipv6CidrBlockSet(Collection<VpcInfoIpv6CidrBlockSetDetails> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = VpcInfoIpv6CidrBlockSetListCopier.copy(ipv6CidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(VpcInfoIpv6CidrBlockSetDetails... ipv6CidrBlockSet) {
            ipv6CidrBlockSet(Arrays.asList(ipv6CidrBlockSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Consumer<VpcInfoIpv6CidrBlockSetDetails.Builder>... ipv6CidrBlockSet) {
            ipv6CidrBlockSet(Stream.of(ipv6CidrBlockSet)
                    .map(c -> VpcInfoIpv6CidrBlockSetDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final VpcInfoPeeringOptionsDetails.Builder getPeeringOptions() {
            return peeringOptions != null ? peeringOptions.toBuilder() : null;
        }

        public final void setPeeringOptions(VpcInfoPeeringOptionsDetails.BuilderImpl peeringOptions) {
            this.peeringOptions = peeringOptions != null ? peeringOptions.build() : null;
        }

        @Override
        public final Builder peeringOptions(VpcInfoPeeringOptionsDetails peeringOptions) {
            this.peeringOptions = peeringOptions;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public AwsEc2VpcPeeringConnectionVpcInfoDetails build() {
            return new AwsEc2VpcPeeringConnectionVpcInfoDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
