/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a VPC peering connection between two VPCs: a requester VPC that you own and an accepter
 * VPC with which to create the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VpcPeeringConnectionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VpcPeeringConnectionDetails.Builder, AwsEc2VpcPeeringConnectionDetails> {
    private static final SdkField<AwsEc2VpcPeeringConnectionVpcInfoDetails> ACCEPTER_VPC_INFO_FIELD = SdkField
            .<AwsEc2VpcPeeringConnectionVpcInfoDetails> builder(MarshallingType.SDK_POJO).memberName("AccepterVpcInfo")
            .getter(getter(AwsEc2VpcPeeringConnectionDetails::accepterVpcInfo)).setter(setter(Builder::accepterVpcInfo))
            .constructor(AwsEc2VpcPeeringConnectionVpcInfoDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterVpcInfo").build()).build();

    private static final SdkField<String> EXPIRATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationTime").getter(getter(AwsEc2VpcPeeringConnectionDetails::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build()).build();

    private static final SdkField<AwsEc2VpcPeeringConnectionVpcInfoDetails> REQUESTER_VPC_INFO_FIELD = SdkField
            .<AwsEc2VpcPeeringConnectionVpcInfoDetails> builder(MarshallingType.SDK_POJO).memberName("RequesterVpcInfo")
            .getter(getter(AwsEc2VpcPeeringConnectionDetails::requesterVpcInfo)).setter(setter(Builder::requesterVpcInfo))
            .constructor(AwsEc2VpcPeeringConnectionVpcInfoDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterVpcInfo").build()).build();

    private static final SdkField<AwsEc2VpcPeeringConnectionStatusDetails> STATUS_FIELD = SdkField
            .<AwsEc2VpcPeeringConnectionStatusDetails> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(AwsEc2VpcPeeringConnectionDetails::status)).setter(setter(Builder::status))
            .constructor(AwsEc2VpcPeeringConnectionStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcPeeringConnectionId").getter(getter(AwsEc2VpcPeeringConnectionDetails::vpcPeeringConnectionId))
            .setter(setter(Builder::vpcPeeringConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTER_VPC_INFO_FIELD,
            EXPIRATION_TIME_FIELD, REQUESTER_VPC_INFO_FIELD, STATUS_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsEc2VpcPeeringConnectionVpcInfoDetails accepterVpcInfo;

    private final String expirationTime;

    private final AwsEc2VpcPeeringConnectionVpcInfoDetails requesterVpcInfo;

    private final AwsEc2VpcPeeringConnectionStatusDetails status;

    private final String vpcPeeringConnectionId;

    private AwsEc2VpcPeeringConnectionDetails(BuilderImpl builder) {
        this.accepterVpcInfo = builder.accepterVpcInfo;
        this.expirationTime = builder.expirationTime;
        this.requesterVpcInfo = builder.requesterVpcInfo;
        this.status = builder.status;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * Information about the accepter VPC.
     * </p>
     * 
     * @return Information about the accepter VPC.
     */
    public final AwsEc2VpcPeeringConnectionVpcInfoDetails accepterVpcInfo() {
        return accepterVpcInfo;
    }

    /**
     * <p>
     * The time at which an unaccepted VPC peering connection will expire.
     * </p>
     * 
     * @return The time at which an unaccepted VPC peering connection will expire.
     */
    public final String expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * Information about the requester VPC.
     * </p>
     * 
     * @return Information about the requester VPC.
     */
    public final AwsEc2VpcPeeringConnectionVpcInfoDetails requesterVpcInfo() {
        return requesterVpcInfo;
    }

    /**
     * <p>
     * The status of the VPC peering connection.
     * </p>
     * 
     * @return The status of the VPC peering connection.
     */
    public final AwsEc2VpcPeeringConnectionStatusDetails status() {
        return status;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public final String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accepterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(requesterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpcPeeringConnectionDetails)) {
            return false;
        }
        AwsEc2VpcPeeringConnectionDetails other = (AwsEc2VpcPeeringConnectionDetails) obj;
        return Objects.equals(accepterVpcInfo(), other.accepterVpcInfo())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(requesterVpcInfo(), other.requesterVpcInfo()) && Objects.equals(status(), other.status())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VpcPeeringConnectionDetails").add("AccepterVpcInfo", accepterVpcInfo())
                .add("ExpirationTime", expirationTime()).add("RequesterVpcInfo", requesterVpcInfo()).add("Status", status())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccepterVpcInfo":
            return Optional.ofNullable(clazz.cast(accepterVpcInfo()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "RequesterVpcInfo":
            return Optional.ofNullable(clazz.cast(requesterVpcInfo()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "VpcPeeringConnectionId":
            return Optional.ofNullable(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpcPeeringConnectionDetails, T> g) {
        return obj -> g.apply((AwsEc2VpcPeeringConnectionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VpcPeeringConnectionDetails> {
        /**
         * <p>
         * Information about the accepter VPC.
         * </p>
         * 
         * @param accepterVpcInfo
         *        Information about the accepter VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails accepterVpcInfo);

        /**
         * <p>
         * Information about the accepter VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2VpcPeeringConnectionVpcInfoDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #accepterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails)}.
         * 
         * @param accepterVpcInfo
         *        a consumer that will call methods on {@link AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accepterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails)
         */
        default Builder accepterVpcInfo(Consumer<AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder> accepterVpcInfo) {
            return accepterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails.builder().applyMutation(accepterVpcInfo).build());
        }

        /**
         * <p>
         * The time at which an unaccepted VPC peering connection will expire.
         * </p>
         * 
         * @param expirationTime
         *        The time at which an unaccepted VPC peering connection will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(String expirationTime);

        /**
         * <p>
         * Information about the requester VPC.
         * </p>
         * 
         * @param requesterVpcInfo
         *        Information about the requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails requesterVpcInfo);

        /**
         * <p>
         * Information about the requester VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2VpcPeeringConnectionVpcInfoDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #requesterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails)}.
         * 
         * @param requesterVpcInfo
         *        a consumer that will call methods on {@link AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requesterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails)
         */
        default Builder requesterVpcInfo(Consumer<AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder> requesterVpcInfo) {
            return requesterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails.builder().applyMutation(requesterVpcInfo).build());
        }

        /**
         * <p>
         * The status of the VPC peering connection.
         * </p>
         * 
         * @param status
         *        The status of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AwsEc2VpcPeeringConnectionStatusDetails status);

        /**
         * <p>
         * The status of the VPC peering connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2VpcPeeringConnectionStatusDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2VpcPeeringConnectionStatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2VpcPeeringConnectionStatusDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #status(AwsEc2VpcPeeringConnectionStatusDetails)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AwsEc2VpcPeeringConnectionStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AwsEc2VpcPeeringConnectionStatusDetails)
         */
        default Builder status(Consumer<AwsEc2VpcPeeringConnectionStatusDetails.Builder> status) {
            return status(AwsEc2VpcPeeringConnectionStatusDetails.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private AwsEc2VpcPeeringConnectionVpcInfoDetails accepterVpcInfo;

        private String expirationTime;

        private AwsEc2VpcPeeringConnectionVpcInfoDetails requesterVpcInfo;

        private AwsEc2VpcPeeringConnectionStatusDetails status;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpcPeeringConnectionDetails model) {
            accepterVpcInfo(model.accepterVpcInfo);
            expirationTime(model.expirationTime);
            requesterVpcInfo(model.requesterVpcInfo);
            status(model.status);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder getAccepterVpcInfo() {
            return accepterVpcInfo != null ? accepterVpcInfo.toBuilder() : null;
        }

        public final void setAccepterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails.BuilderImpl accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo != null ? accepterVpcInfo.build() : null;
        }

        @Override
        public final Builder accepterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo;
            return this;
        }

        public final String getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final AwsEc2VpcPeeringConnectionVpcInfoDetails.Builder getRequesterVpcInfo() {
            return requesterVpcInfo != null ? requesterVpcInfo.toBuilder() : null;
        }

        public final void setRequesterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails.BuilderImpl requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo != null ? requesterVpcInfo.build() : null;
        }

        @Override
        public final Builder requesterVpcInfo(AwsEc2VpcPeeringConnectionVpcInfoDetails requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo;
            return this;
        }

        public final AwsEc2VpcPeeringConnectionStatusDetails.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(AwsEc2VpcPeeringConnectionStatusDetails.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AwsEc2VpcPeeringConnectionStatusDetails status) {
            this.status = status;
            return this;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        @Override
        public AwsEc2VpcPeeringConnectionDetails build() {
            return new AwsEc2VpcPeeringConnectionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
