/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for Amazon EC2 instance hostnames.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.Builder, AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails> {
    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableResourceNameDnsAAAARecord")
            .getter(getter(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails::enableResourceNameDnsAAAARecord))
            .setter(setter(Builder::enableResourceNameDnsAAAARecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsAAAARecord")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableResourceNameDnsARecord")
            .getter(getter(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails::enableResourceNameDnsARecord))
            .setter(setter(Builder::enableResourceNameDnsARecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsARecord")
                    .build()).build();

    private static final SdkField<String> HOSTNAME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostnameType").getter(getter(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails::hostnameType))
            .setter(setter(Builder::hostnameType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostnameType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD, ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD, HOSTNAME_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableResourceNameDnsAAAARecord;

    private final Boolean enableResourceNameDnsARecord;

    private final String hostnameType;

    private AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails(BuilderImpl builder) {
        this.enableResourceNameDnsAAAARecord = builder.enableResourceNameDnsAAAARecord;
        this.enableResourceNameDnsARecord = builder.enableResourceNameDnsARecord;
        this.hostnameType = builder.hostnameType;
    }

    /**
     * <p>
     * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     * </p>
     * 
     * @return Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     */
    public final Boolean enableResourceNameDnsAAAARecord() {
        return enableResourceNameDnsAAAARecord;
    }

    /**
     * <p>
     * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     * </p>
     * 
     * @return Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     */
    public final Boolean enableResourceNameDnsARecord() {
        return enableResourceNameDnsARecord;
    }

    /**
     * <p>
     * The type of hostname for EC2 instances.
     * </p>
     * 
     * @return The type of hostname for EC2 instances.
     */
    public final String hostnameType() {
        return hostnameType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsAAAARecord());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsARecord());
        hashCode = 31 * hashCode + Objects.hashCode(hostnameType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails other = (AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails) obj;
        return Objects.equals(enableResourceNameDnsAAAARecord(), other.enableResourceNameDnsAAAARecord())
                && Objects.equals(enableResourceNameDnsARecord(), other.enableResourceNameDnsARecord())
                && Objects.equals(hostnameType(), other.hostnameType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails")
                .add("EnableResourceNameDnsAAAARecord", enableResourceNameDnsAAAARecord())
                .add("EnableResourceNameDnsARecord", enableResourceNameDnsARecord()).add("HostnameType", hostnameType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableResourceNameDnsAAAARecord":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsAAAARecord()));
        case "EnableResourceNameDnsARecord":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsARecord()));
        case "HostnameType":
            return Optional.ofNullable(clazz.cast(hostnameType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails> {
        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * 
         * @param enableResourceNameDnsAAAARecord
         *        Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord);

        /**
         * <p>
         * Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * 
         * @param enableResourceNameDnsARecord
         *        Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord);

        /**
         * <p>
         * The type of hostname for EC2 instances.
         * </p>
         * 
         * @param hostnameType
         *        The type of hostname for EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostnameType(String hostnameType);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableResourceNameDnsAAAARecord;

        private Boolean enableResourceNameDnsARecord;

        private String hostnameType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails model) {
            enableResourceNameDnsAAAARecord(model.enableResourceNameDnsAAAARecord);
            enableResourceNameDnsARecord(model.enableResourceNameDnsARecord);
            hostnameType(model.hostnameType);
        }

        public final Boolean getEnableResourceNameDnsAAAARecord() {
            return enableResourceNameDnsAAAARecord;
        }

        public final void setEnableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
        }

        @Override
        public final Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
            return this;
        }

        public final Boolean getEnableResourceNameDnsARecord() {
            return enableResourceNameDnsARecord;
        }

        public final void setEnableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
        }

        @Override
        public final Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
            return this;
        }

        public final String getHostnameType() {
            return hostnameType;
        }

        public final void setHostnameType(String hostnameType) {
            this.hostnameType = hostnameType;
        }

        @Override
        public final Builder hostnameType(String hostnameType) {
            this.hostnameType = hostnameType;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails build() {
            return new AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
