/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a block device mapping for an Amazon Elastic Compute Cloud (Amazon EC2) launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.Builder, AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails> EBS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails> builder(MarshallingType.SDK_POJO).memberName("Ebs")
            .getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails::ebs)).setter(setter(Builder::ebs))
            .constructor(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").build()).build();

    private static final SdkField<String> NO_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NoDevice").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails::noDevice))
            .setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice").build()).build();

    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VirtualName").getter(getter(AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails::virtualName))
            .setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD,
            NO_DEVICE_FIELD, VIRTUAL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails ebs;

    private final String noDevice;

    private final String virtualName;

    private AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    /**
     * <p>
     * The device name.
     * </p>
     * 
     * @return The device name.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Parameters used to automatically set up Amazon EBS volumes when the instance is launched.
     * </p>
     * 
     * @return Parameters used to automatically set up Amazon EBS volumes when the instance is launched.
     */
    public final AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails ebs() {
        return ebs;
    }

    /**
     * <p>
     * Omits the device from the block device mapping when an empty string is specified.
     * </p>
     * 
     * @return Omits the device from the block device mapping when an empty string is specified.
     */
    public final String noDevice() {
        return noDevice;
    }

    /**
     * <p>
     * The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0. An instance type with
     * 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and <code>ephemeral1</code>.
     * The number of available instance store volumes depends on the instance type.
     * </p>
     * 
     * @return The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0. An instance
     *         type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and
     *         <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type.
     */
    public final String virtualName() {
        return virtualName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails other = (AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ebs(), other.ebs())
                && Objects.equals(noDevice(), other.noDevice()) && Objects.equals(virtualName(), other.virtualName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails").add("DeviceName", deviceName())
                .add("Ebs", ebs()).add("NoDevice", noDevice()).add("VirtualName", virtualName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        case "VirtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails> {
        /**
         * <p>
         * The device name.
         * </p>
         * 
         * @param deviceName
         *        The device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Parameters used to automatically set up Amazon EBS volumes when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to automatically set up Amazon EBS volumes when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails ebs);

        /**
         * <p>
         * Parameters used to automatically set up Amazon EBS volumes when the instance is launched.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #ebs(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails)}.
         * 
         * @param ebs
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails)
         */
        default Builder ebs(Consumer<AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.Builder> ebs) {
            return ebs(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.builder().applyMutation(ebs).build());
        }

        /**
         * <p>
         * Omits the device from the block device mapping when an empty string is specified.
         * </p>
         * 
         * @param noDevice
         *        Omits the device from the block device mapping when an empty string is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);

        /**
         * <p>
         * The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0. An instance type
         * with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and
         * <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name (ephemeralN). Instance store volumes are numbered starting from 0. An instance
         *        type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and
         *        <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails ebs;

        private String noDevice;

        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
            noDevice(model.noDevice);
            virtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        public final void setEbs(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public final Builder ebs(AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails ebs) {
            this.ebs = ebs;
            return this;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails build() {
            return new AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
