/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a local secondary index for a DynamoDB table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableLocalSecondaryIndex implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableLocalSecondaryIndex.Builder, AwsDynamoDbTableLocalSecondaryIndex> {
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexArn").getter(getter(AwsDynamoDbTableLocalSecondaryIndex::indexArn))
            .setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexArn").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(AwsDynamoDbTableLocalSecondaryIndex::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<List<AwsDynamoDbTableKeySchema>> KEY_SCHEMA_FIELD = SdkField
            .<List<AwsDynamoDbTableKeySchema>> builder(MarshallingType.LIST)
            .memberName("KeySchema")
            .getter(getter(AwsDynamoDbTableLocalSecondaryIndex::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDynamoDbTableKeySchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDynamoDbTableKeySchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsDynamoDbTableProjection> PROJECTION_FIELD = SdkField
            .<AwsDynamoDbTableProjection> builder(MarshallingType.SDK_POJO).memberName("Projection")
            .getter(getter(AwsDynamoDbTableLocalSecondaryIndex::projection)).setter(setter(Builder::projection))
            .constructor(AwsDynamoDbTableProjection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Projection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ARN_FIELD,
            INDEX_NAME_FIELD, KEY_SCHEMA_FIELD, PROJECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexArn;

    private final String indexName;

    private final List<AwsDynamoDbTableKeySchema> keySchema;

    private final AwsDynamoDbTableProjection projection;

    private AwsDynamoDbTableLocalSecondaryIndex(BuilderImpl builder) {
        this.indexArn = builder.indexArn;
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
    }

    /**
     * <p>
     * The ARN of the index.
     * </p>
     * 
     * @return The ARN of the index.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * <p>
     * The name of the index.
     * </p>
     * 
     * @return The name of the index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeySchema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The complete key schema for the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeySchema} method.
     * </p>
     * 
     * @return The complete key schema for the index.
     */
    public final List<AwsDynamoDbTableKeySchema> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * Attributes that are copied from the table into the index. These are in addition to the primary key attributes and
     * index key attributes, which are automatically projected.
     * </p>
     * 
     * @return Attributes that are copied from the table into the index. These are in addition to the primary key
     *         attributes and index key attributes, which are automatically projected.
     */
    public final AwsDynamoDbTableProjection projection() {
        return projection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySchema() ? keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(projection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableLocalSecondaryIndex)) {
            return false;
        }
        AwsDynamoDbTableLocalSecondaryIndex other = (AwsDynamoDbTableLocalSecondaryIndex) obj;
        return Objects.equals(indexArn(), other.indexArn()) && Objects.equals(indexName(), other.indexName())
                && hasKeySchema() == other.hasKeySchema() && Objects.equals(keySchema(), other.keySchema())
                && Objects.equals(projection(), other.projection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableLocalSecondaryIndex").add("IndexArn", indexArn()).add("IndexName", indexName())
                .add("KeySchema", hasKeySchema() ? keySchema() : null).add("Projection", projection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "Projection":
            return Optional.ofNullable(clazz.cast(projection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableLocalSecondaryIndex, T> g) {
        return obj -> g.apply((AwsDynamoDbTableLocalSecondaryIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableLocalSecondaryIndex> {
        /**
         * <p>
         * The ARN of the index.
         * </p>
         * 
         * @param indexArn
         *        The ARN of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The name of the index.
         * </p>
         * 
         * @param indexName
         *        The name of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The complete key schema for the index.
         * </p>
         * 
         * @param keySchema
         *        The complete key schema for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema);

        /**
         * <p>
         * The complete key schema for the index.
         * </p>
         * 
         * @param keySchema
         *        The complete key schema for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(AwsDynamoDbTableKeySchema... keySchema);

        /**
         * <p>
         * The complete key schema for the index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema.Builder#build()} is called
         * immediately and its result is passed to {@link #keySchema(List<AwsDynamoDbTableKeySchema>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(java.util.Collection<AwsDynamoDbTableKeySchema>)
         */
        Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder>... keySchema);

        /**
         * <p>
         * Attributes that are copied from the table into the index. These are in addition to the primary key attributes
         * and index key attributes, which are automatically projected.
         * </p>
         * 
         * @param projection
         *        Attributes that are copied from the table into the index. These are in addition to the primary key
         *        attributes and index key attributes, which are automatically projected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projection(AwsDynamoDbTableProjection projection);

        /**
         * <p>
         * Attributes that are copied from the table into the index. These are in addition to the primary key attributes
         * and index key attributes, which are automatically projected.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsDynamoDbTableProjection.Builder}
         * avoiding the need to create one manually via {@link AwsDynamoDbTableProjection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableProjection.Builder#build()} is called immediately
         * and its result is passed to {@link #projection(AwsDynamoDbTableProjection)}.
         * 
         * @param projection
         *        a consumer that will call methods on {@link AwsDynamoDbTableProjection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projection(AwsDynamoDbTableProjection)
         */
        default Builder projection(Consumer<AwsDynamoDbTableProjection.Builder> projection) {
            return projection(AwsDynamoDbTableProjection.builder().applyMutation(projection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexArn;

        private String indexName;

        private List<AwsDynamoDbTableKeySchema> keySchema = DefaultSdkAutoConstructList.getInstance();

        private AwsDynamoDbTableProjection projection;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableLocalSecondaryIndex model) {
            indexArn(model.indexArn);
            indexName(model.indexName);
            keySchema(model.keySchema);
            projection(model.projection);
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final List<AwsDynamoDbTableKeySchema.Builder> getKeySchema() {
            List<AwsDynamoDbTableKeySchema.Builder> result = AwsDynamoDbTableKeySchemaListCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<AwsDynamoDbTableKeySchema.BuilderImpl> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copyFromBuilder(keySchema);
        }

        @Override
        public final Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(AwsDynamoDbTableKeySchema... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> AwsDynamoDbTableKeySchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableProjection.Builder getProjection() {
            return projection != null ? projection.toBuilder() : null;
        }

        public final void setProjection(AwsDynamoDbTableProjection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        @Override
        public final Builder projection(AwsDynamoDbTableProjection projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public AwsDynamoDbTableLocalSecondaryIndex build() {
            return new AwsDynamoDbTableLocalSecondaryIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
