/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about logs built to an S3 bucket for a build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectLogsConfigS3LogsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectLogsConfigS3LogsDetails.Builder, AwsCodeBuildProjectLogsConfigS3LogsDetails> {
    private static final SdkField<Boolean> ENCRYPTION_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EncryptionDisabled").getter(getter(AwsCodeBuildProjectLogsConfigS3LogsDetails::encryptionDisabled))
            .setter(setter(Builder::encryptionDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionDisabled").build())
            .build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(AwsCodeBuildProjectLogsConfigS3LogsDetails::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsCodeBuildProjectLogsConfigS3LogsDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_DISABLED_FIELD,
            LOCATION_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean encryptionDisabled;

    private final String location;

    private final String status;

    private AwsCodeBuildProjectLogsConfigS3LogsDetails(BuilderImpl builder) {
        this.encryptionDisabled = builder.encryptionDisabled;
        this.location = builder.location;
        this.status = builder.status;
    }

    /**
     * <p>
     * Whether to disable encryption of the S3 build log output.
     * </p>
     * 
     * @return Whether to disable encryption of the S3 build log output.
     */
    public final Boolean encryptionDisabled() {
        return encryptionDisabled;
    }

    /**
     * <p>
     * The ARN of the S3 bucket and the path prefix for S3 logs.
     * </p>
     * 
     * @return The ARN of the S3 bucket and the path prefix for S3 logs.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The current status of the S3 build logs.
     * </p>
     * 
     * @return The current status of the S3 build logs.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectLogsConfigS3LogsDetails)) {
            return false;
        }
        AwsCodeBuildProjectLogsConfigS3LogsDetails other = (AwsCodeBuildProjectLogsConfigS3LogsDetails) obj;
        return Objects.equals(encryptionDisabled(), other.encryptionDisabled()) && Objects.equals(location(), other.location())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectLogsConfigS3LogsDetails").add("EncryptionDisabled", encryptionDisabled())
                .add("Location", location()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionDisabled":
            return Optional.ofNullable(clazz.cast(encryptionDisabled()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectLogsConfigS3LogsDetails, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectLogsConfigS3LogsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectLogsConfigS3LogsDetails> {
        /**
         * <p>
         * Whether to disable encryption of the S3 build log output.
         * </p>
         * 
         * @param encryptionDisabled
         *        Whether to disable encryption of the S3 build log output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionDisabled(Boolean encryptionDisabled);

        /**
         * <p>
         * The ARN of the S3 bucket and the path prefix for S3 logs.
         * </p>
         * 
         * @param location
         *        The ARN of the S3 bucket and the path prefix for S3 logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The current status of the S3 build logs.
         * </p>
         * 
         * @param status
         *        The current status of the S3 build logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private Boolean encryptionDisabled;

        private String location;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectLogsConfigS3LogsDetails model) {
            encryptionDisabled(model.encryptionDisabled);
            location(model.location);
            status(model.status);
        }

        public final Boolean getEncryptionDisabled() {
            return encryptionDisabled;
        }

        public final void setEncryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
        }

        @Override
        public final Builder encryptionDisabled(Boolean encryptionDisabled) {
            this.encryptionDisabled = encryptionDisabled;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsCodeBuildProjectLogsConfigS3LogsDetails build() {
            return new AwsCodeBuildProjectLogsConfigS3LogsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
