/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the CloudFormation stack output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFormationStackOutputsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFormationStackOutputsDetails.Builder, AwsCloudFormationStackOutputsDetails> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsCloudFormationStackOutputsDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputKey").getter(getter(AwsCloudFormationStackOutputsDetails::outputKey))
            .setter(setter(Builder::outputKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()).build();

    private static final SdkField<String> OUTPUT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputValue").getter(getter(AwsCloudFormationStackOutputsDetails::outputValue))
            .setter(setter(Builder::outputValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            OUTPUT_KEY_FIELD, OUTPUT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String outputKey;

    private final String outputValue;

    private AwsCloudFormationStackOutputsDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
    }

    /**
     * <p>
     * A user-defined description associated with the output.
     * </p>
     * 
     * @return A user-defined description associated with the output.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The key associated with the output.
     * </p>
     * 
     * @return The key associated with the output.
     */
    public final String outputKey() {
        return outputKey;
    }

    /**
     * <p>
     * The value associated with the output.
     * </p>
     * 
     * @return The value associated with the output.
     */
    public final String outputValue() {
        return outputValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(outputValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFormationStackOutputsDetails)) {
            return false;
        }
        AwsCloudFormationStackOutputsDetails other = (AwsCloudFormationStackOutputsDetails) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(outputKey(), other.outputKey())
                && Objects.equals(outputValue(), other.outputValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFormationStackOutputsDetails").add("Description", description())
                .add("OutputKey", outputKey()).add("OutputValue", outputValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OutputKey":
            return Optional.ofNullable(clazz.cast(outputKey()));
        case "OutputValue":
            return Optional.ofNullable(clazz.cast(outputValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFormationStackOutputsDetails, T> g) {
        return obj -> g.apply((AwsCloudFormationStackOutputsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFormationStackOutputsDetails> {
        /**
         * <p>
         * A user-defined description associated with the output.
         * </p>
         * 
         * @param description
         *        A user-defined description associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The key associated with the output.
         * </p>
         * 
         * @param outputKey
         *        The key associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKey(String outputKey);

        /**
         * <p>
         * The value associated with the output.
         * </p>
         * 
         * @param outputValue
         *        The value associated with the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputValue(String outputValue);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String outputKey;

        private String outputValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFormationStackOutputsDetails model) {
            description(model.description);
            outputKey(model.outputKey);
            outputValue(model.outputValue);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOutputKey() {
            return outputKey;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final String getOutputValue() {
            return outputValue;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        @Override
        public AwsCloudFormationStackOutputsDetails build() {
            return new AwsCloudFormationStackOutputsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
