/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides lifecycle details for the backup plan. A lifecycle defines when a backup is transitioned to cold storage and
 * when it expires.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupBackupPlanLifecycleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupBackupPlanLifecycleDetails.Builder, AwsBackupBackupPlanLifecycleDetails> {
    private static final SdkField<Long> DELETE_AFTER_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DeleteAfterDays").getter(getter(AwsBackupBackupPlanLifecycleDetails::deleteAfterDays))
            .setter(setter(Builder::deleteAfterDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAfterDays").build()).build();

    private static final SdkField<Long> MOVE_TO_COLD_STORAGE_AFTER_DAYS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MoveToColdStorageAfterDays")
            .getter(getter(AwsBackupBackupPlanLifecycleDetails::moveToColdStorageAfterDays))
            .setter(setter(Builder::moveToColdStorageAfterDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoveToColdStorageAfterDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_AFTER_DAYS_FIELD,
            MOVE_TO_COLD_STORAGE_AFTER_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long deleteAfterDays;

    private final Long moveToColdStorageAfterDays;

    private AwsBackupBackupPlanLifecycleDetails(BuilderImpl builder) {
        this.deleteAfterDays = builder.deleteAfterDays;
        this.moveToColdStorageAfterDays = builder.moveToColdStorageAfterDays;
    }

    /**
     * <p>
     * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus
     * <code>MoveToColdStorageAfterDays</code>.
     * </p>
     * 
     * @return Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90
     *         days plus <code>MoveToColdStorageAfterDays</code>.
     */
    public final Long deleteAfterDays() {
        return deleteAfterDays;
    }

    /**
     * <p>
     * Specifies the number of days after creation that a recovery point is moved to cold storage.
     * </p>
     * 
     * @return Specifies the number of days after creation that a recovery point is moved to cold storage.
     */
    public final Long moveToColdStorageAfterDays() {
        return moveToColdStorageAfterDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleteAfterDays());
        hashCode = 31 * hashCode + Objects.hashCode(moveToColdStorageAfterDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupPlanLifecycleDetails)) {
            return false;
        }
        AwsBackupBackupPlanLifecycleDetails other = (AwsBackupBackupPlanLifecycleDetails) obj;
        return Objects.equals(deleteAfterDays(), other.deleteAfterDays())
                && Objects.equals(moveToColdStorageAfterDays(), other.moveToColdStorageAfterDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupBackupPlanLifecycleDetails").add("DeleteAfterDays", deleteAfterDays())
                .add("MoveToColdStorageAfterDays", moveToColdStorageAfterDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteAfterDays":
            return Optional.ofNullable(clazz.cast(deleteAfterDays()));
        case "MoveToColdStorageAfterDays":
            return Optional.ofNullable(clazz.cast(moveToColdStorageAfterDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupPlanLifecycleDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupPlanLifecycleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupBackupPlanLifecycleDetails> {
        /**
         * <p>
         * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days
         * plus <code>MoveToColdStorageAfterDays</code>.
         * </p>
         * 
         * @param deleteAfterDays
         *        Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90
         *        days plus <code>MoveToColdStorageAfterDays</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAfterDays(Long deleteAfterDays);

        /**
         * <p>
         * Specifies the number of days after creation that a recovery point is moved to cold storage.
         * </p>
         * 
         * @param moveToColdStorageAfterDays
         *        Specifies the number of days after creation that a recovery point is moved to cold storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moveToColdStorageAfterDays(Long moveToColdStorageAfterDays);
    }

    static final class BuilderImpl implements Builder {
        private Long deleteAfterDays;

        private Long moveToColdStorageAfterDays;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupPlanLifecycleDetails model) {
            deleteAfterDays(model.deleteAfterDays);
            moveToColdStorageAfterDays(model.moveToColdStorageAfterDays);
        }

        public final Long getDeleteAfterDays() {
            return deleteAfterDays;
        }

        public final void setDeleteAfterDays(Long deleteAfterDays) {
            this.deleteAfterDays = deleteAfterDays;
        }

        @Override
        public final Builder deleteAfterDays(Long deleteAfterDays) {
            this.deleteAfterDays = deleteAfterDays;
            return this;
        }

        public final Long getMoveToColdStorageAfterDays() {
            return moveToColdStorageAfterDays;
        }

        public final void setMoveToColdStorageAfterDays(Long moveToColdStorageAfterDays) {
            this.moveToColdStorageAfterDays = moveToColdStorageAfterDays;
        }

        @Override
        public final Builder moveToColdStorageAfterDays(Long moveToColdStorageAfterDays) {
            this.moveToColdStorageAfterDays = moveToColdStorageAfterDays;
            return this;
        }

        @Override
        public AwsBackupBackupPlanLifecycleDetails build() {
            return new AwsBackupBackupPlanLifecycleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
