/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the workgroup, which includes the location in Amazon Simple Storage Service (Amazon S3) where
 * query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch metrics
 * are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAthenaWorkGroupConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAthenaWorkGroupConfigurationDetails.Builder, AwsAthenaWorkGroupConfigurationDetails> {
    private static final SdkField<AwsAthenaWorkGroupConfigurationResultConfigurationDetails> RESULT_CONFIGURATION_FIELD = SdkField
            .<AwsAthenaWorkGroupConfigurationResultConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ResultConfiguration").getter(getter(AwsAthenaWorkGroupConfigurationDetails::resultConfiguration))
            .setter(setter(Builder::resultConfiguration))
            .constructor(AwsAthenaWorkGroupConfigurationResultConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsAthenaWorkGroupConfigurationResultConfigurationDetails resultConfiguration;

    private AwsAthenaWorkGroupConfigurationDetails(BuilderImpl builder) {
        this.resultConfiguration = builder.resultConfiguration;
    }

    /**
     * <p>
     * The location in Amazon S3 where query and calculation results are stored and the encryption option, if any, used
     * for query and calculation results. These are known as client-side settings. If workgroup settings override
     * client-side settings, then the query uses the workgroup settings.
     * </p>
     * 
     * @return The location in Amazon S3 where query and calculation results are stored and the encryption option, if
     *         any, used for query and calculation results. These are known as client-side settings. If workgroup
     *         settings override client-side settings, then the query uses the workgroup settings.
     */
    public final AwsAthenaWorkGroupConfigurationResultConfigurationDetails resultConfiguration() {
        return resultConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAthenaWorkGroupConfigurationDetails)) {
            return false;
        }
        AwsAthenaWorkGroupConfigurationDetails other = (AwsAthenaWorkGroupConfigurationDetails) obj;
        return Objects.equals(resultConfiguration(), other.resultConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAthenaWorkGroupConfigurationDetails").add("ResultConfiguration", resultConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultConfiguration":
            return Optional.ofNullable(clazz.cast(resultConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsAthenaWorkGroupConfigurationDetails, T> g) {
        return obj -> g.apply((AwsAthenaWorkGroupConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAthenaWorkGroupConfigurationDetails> {
        /**
         * <p>
         * The location in Amazon S3 where query and calculation results are stored and the encryption option, if any,
         * used for query and calculation results. These are known as client-side settings. If workgroup settings
         * override client-side settings, then the query uses the workgroup settings.
         * </p>
         * 
         * @param resultConfiguration
         *        The location in Amazon S3 where query and calculation results are stored and the encryption option, if
         *        any, used for query and calculation results. These are known as client-side settings. If workgroup
         *        settings override client-side settings, then the query uses the workgroup settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultConfiguration(AwsAthenaWorkGroupConfigurationResultConfigurationDetails resultConfiguration);

        /**
         * <p>
         * The location in Amazon S3 where query and calculation results are stored and the encryption option, if any,
         * used for query and calculation results. These are known as client-side settings. If workgroup settings
         * override client-side settings, then the query uses the workgroup settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAthenaWorkGroupConfigurationResultConfigurationDetails.Builder} avoiding the need to create one
         * manually via {@link AwsAthenaWorkGroupConfigurationResultConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAthenaWorkGroupConfigurationResultConfigurationDetails.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #resultConfiguration(AwsAthenaWorkGroupConfigurationResultConfigurationDetails)}.
         * 
         * @param resultConfiguration
         *        a consumer that will call methods on
         *        {@link AwsAthenaWorkGroupConfigurationResultConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultConfiguration(AwsAthenaWorkGroupConfigurationResultConfigurationDetails)
         */
        default Builder resultConfiguration(
                Consumer<AwsAthenaWorkGroupConfigurationResultConfigurationDetails.Builder> resultConfiguration) {
            return resultConfiguration(AwsAthenaWorkGroupConfigurationResultConfigurationDetails.builder()
                    .applyMutation(resultConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsAthenaWorkGroupConfigurationResultConfigurationDetails resultConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAthenaWorkGroupConfigurationDetails model) {
            resultConfiguration(model.resultConfiguration);
        }

        public final AwsAthenaWorkGroupConfigurationResultConfigurationDetails.Builder getResultConfiguration() {
            return resultConfiguration != null ? resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(
                AwsAthenaWorkGroupConfigurationResultConfigurationDetails.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(AwsAthenaWorkGroupConfigurationResultConfigurationDetails resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        @Override
        public AwsAthenaWorkGroupConfigurationDetails build() {
            return new AwsAthenaWorkGroupConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
